/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sensors.blackfly;

import controller_msgs.msg.dds.UIConnectedPacket;
import java.util.HashMap;
import java.util.Map;
import perception_msgs.msg.dds.BlackFlyParameterPacket;
import us.ihmc.commons.PrintTools;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.utilities.ros.RosDynamicReconfigure;
import us.ihmc.utilities.ros.RosMainNode;

public class BlackFlyParameterSetter
implements PacketConsumer<BlackFlyParameterPacket> {
    private final PacketCommunicator packetCommunicator;
    private final boolean DEBUG = false;
    RosDynamicReconfigure dynamicReconfigureClient;
    String cameraNodeName;
    RobotSide side;

    public BlackFlyParameterSetter(RosMainNode rosMainNode, RobotSide side, String cameraNode, PacketCommunicator packetCommunicator) {
        this.packetCommunicator = packetCommunicator;
        this.dynamicReconfigureClient = new RosDynamicReconfigure(cameraNode, rosMainNode);
        this.side = side;
        this.cameraNodeName = cameraNode;
        packetCommunicator.attachListener(BlackFlyParameterPacket.class, (PacketConsumer)this);
        this.setupUIOnConnectResponder();
    }

    public void sendDeviceSettingToUI(Map<String, Object> params) {
        BlackFlyParameterPacket packet = HumanoidMessageTools.createBlackFlyParameterPacket((boolean)false, (double)((Double)params.get("gain")), (double)((Double)params.get("exposure")), (double)((Double)params.get("frame_rate")), (double)((Double)params.get("shutter_speed")), (boolean)((Boolean)params.get("auto_exposure")), (boolean)((Boolean)params.get("auto_gain")), (boolean)((Boolean)params.get("auto_shutter")), (RobotSide)this.side);
        this.packetCommunicator.send((Packet)packet);
        PrintTools.debug((boolean)false, (Object)this, (String)("packet to UI " + String.valueOf(packet)));
    }

    public Map<String, Object> setBlackFlyParameters(BlackFlyParameterPacket packet) {
        PrintTools.debug((boolean)false, (Object)this, (String)("packet fr UI " + String.valueOf(packet)));
        HashMap<String, Comparable<Boolean>> parameters = new HashMap<String, Comparable<Boolean>>();
        parameters.put("auto_exposure", Boolean.valueOf(packet.getAutoExposure()));
        parameters.put("auto_gain", Boolean.valueOf(packet.getAutoGain()));
        parameters.put("auto_shutter", Boolean.valueOf(packet.getAutoShutter()));
        parameters.put("exposure", Double.valueOf(packet.getExposure()));
        parameters.put("gain", Double.valueOf(packet.getGain()));
        parameters.put("shutter_speed", Double.valueOf(packet.getShutter()));
        parameters.put("frame_rate", Double.valueOf(packet.getFrameRate()));
        return this.dynamicReconfigureClient.setParameters(parameters);
    }

    public void setupUIOnConnectResponder() {
        this.packetCommunicator.attachListener(UIConnectedPacket.class, (PacketConsumer)new PacketConsumer<UIConnectedPacket>(){

            public void receivedPacket(UIConnectedPacket packet) {
                BlackFlyParameterSetter.this.sendDeviceSettingToUI(BlackFlyParameterSetter.this.dynamicReconfigureClient.getParameters());
                PrintTools.info((Object)this, (String)"UIConnected - send parameters");
            }
        });
    }

    public void receivedPacket(final BlackFlyParameterPacket packet) {
        if (this.dynamicReconfigureClient.isConnected()) {
            if (packet.getFromUi() && packet.getRobotSide() == this.side.toByte()) {
                new Thread("BlackflyDynamicReconfigureSetter"){

                    @Override
                    public void run() {
                        Map<String, Object> result = BlackFlyParameterSetter.this.setBlackFlyParameters(packet);
                        BlackFlyParameterSetter.this.sendDeviceSettingToUI(result);
                    }
                }.start();
            } else {
                PrintTools.info((Object)this, (String)("blackfly dynamic reconfigure serivce not ready, skipping " + String.valueOf(packet)));
            }
        }
    }
}

