/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGenerator;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;

public class SCS2RobotRigidBodyMutator
implements Controller {
    private final List<RigidBodyMutator> rigidBodyMutators = new ArrayList<RigidBodyMutator>();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());

    public SCS2RobotRigidBodyMutator(Robot robot, DoubleProvider time, double dt) {
        for (RigidBodyBasics rigidBody : robot.getRootBody().subtreeList()) {
            if (rigidBody.getInertia() == null) continue;
            this.rigidBodyMutators.add(new RigidBodyMutator(rigidBody, time, this.registry, dt));
        }
    }

    public void doControl() {
        for (RigidBodyMutator mutator : this.rigidBodyMutators) {
            mutator.mutate();
        }
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    private static class RigidBodyMutator {
        private static final double DEFAULT_MASS_PERCENTAGE_MIN_MAX = 0.1;
        private static final double DEFAULT_COM_OFFSET_MIN_MAX = 0.1;
        private static final double DEFAULT_INERTIA_PERCENTAGE_MIN_MAX = 0.1;
        private final RigidBodyBasics rigidBody;
        private final YoFunctionGenerator massMutator;
        private final YoFunctionGenerator[] comOffsetMutators;
        private final YoFunctionGenerator[] momentOfInertiaMutators;

        public RigidBodyMutator(RigidBodyBasics rigidBody, DoubleProvider time, YoRegistry registry, double dt) {
            this.rigidBody = rigidBody;
            this.massMutator = new YoFunctionGenerator(rigidBody.getName() + "_MassMutator", time, registry, false, dt);
            double defaultMass = rigidBody.getInertia().getMass();
            this.massMutator.setOffset(defaultMass);
            this.massMutator.setAmplitude(defaultMass * 0.1);
            this.comOffsetMutators = new YoFunctionGenerator[3];
            this.comOffsetMutators[0] = new YoFunctionGenerator(YoGeometryNameTools.createXName((String)(rigidBody.getName() + "_CoMOffset"), (String)"Mutator"), time, registry, false, dt);
            this.comOffsetMutators[1] = new YoFunctionGenerator(YoGeometryNameTools.createYName((String)(rigidBody.getName() + "_CoMOffset"), (String)"Mutator"), time, registry, false, dt);
            this.comOffsetMutators[2] = new YoFunctionGenerator(YoGeometryNameTools.createZName((String)(rigidBody.getName() + "_CoMOffset"), (String)"Mutator"), time, registry, false, dt);
            for (YoFunctionGenerator mutator : this.comOffsetMutators) {
                mutator.setOffset(0.0);
                mutator.setAmplitude(0.1);
            }
            this.momentOfInertiaMutators = new YoFunctionGenerator[3];
            this.momentOfInertiaMutators[0] = new YoFunctionGenerator(rigidBody.getName() + "_MomentOfInertiaIxxMutator", time, registry, false, dt);
            this.momentOfInertiaMutators[0].setOffset(rigidBody.getInertia().getMomentOfInertia().getM00());
            this.momentOfInertiaMutators[1] = new YoFunctionGenerator(rigidBody.getName() + "_MomentOfInertiaIyyMutator", time, registry, false, dt);
            this.momentOfInertiaMutators[1].setOffset(rigidBody.getInertia().getMomentOfInertia().getM11());
            this.momentOfInertiaMutators[2] = new YoFunctionGenerator(rigidBody.getName() + "_MomentOfInertiaIzzMutator", time, registry, false, dt);
            this.momentOfInertiaMutators[2].setOffset(rigidBody.getInertia().getMomentOfInertia().getM22());
            double[] defaultInertiaDiagonals = new double[]{rigidBody.getInertia().getMomentOfInertia().getM00(), rigidBody.getInertia().getMomentOfInertia().getM11(), rigidBody.getInertia().getMomentOfInertia().getM22()};
            for (int i = 0; i < 3; ++i) {
                this.momentOfInertiaMutators[i].setOffset(defaultInertiaDiagonals[i]);
                this.momentOfInertiaMutators[i].setAmplitude(0.1);
            }
        }

        public void mutate() {
            this.rigidBody.getInertia().setMass(this.massMutator.getValue());
            this.rigidBody.getInertia().setCenterOfMassOffset(this.comOffsetMutators[0].getValue(), this.comOffsetMutators[1].getValue(), this.comOffsetMutators[2].getValue());
            this.rigidBody.getInertia().setMomentOfInertia(this.momentOfInertiaMutators[0].getValue(), this.momentOfInertiaMutators[1].getValue(), this.momentOfInertiaMutators[2].getValue());
        }
    }
}

