/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.robotDataLogger.CameraType;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.scs2.session.log.BlackMagicScrubber;
import us.ihmc.scs2.session.log.LogDataReader;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.session.log.MagewellScrubber;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.session.log.ZEDSVOScrubber;
import us.ihmc.yoVariables.variable.YoLong;

public class SCS2LogSessionWithVideo
extends LogSession {
    private YoLong yoTimestamp;
    private File logDirectory;
    private LogDataReader logDataReader;
    private LogPropertiesReader logProperties;
    private final List<MagewellScrubber> magewellScrubbers = new ArrayList<MagewellScrubber>();
    private final List<BlackMagicScrubber> blackMagicScrubbers = new ArrayList<BlackMagicScrubber>();
    private final List<ZEDSVOScrubber> zedSVOScrubbers = new ArrayList<ZEDSVOScrubber>();

    public SCS2LogSessionWithVideo(File logDirectory, ProgressConsumer progressConsumer) throws IOException {
        super(logDirectory, progressConsumer);
    }

    public boolean startSessionThread() {
        boolean started = super.startSessionThread();
        if (started) {
            this.logDirectory = this.getLogDirectory();
            this.logDataReader = this.getLogDataReader();
            this.logProperties = this.getLogProperties();
            this.yoTimestamp = this.logDataReader.getTimestamp();
            for (int i = 0; i < this.logProperties.getCameras().size(); ++i) {
                Camera camera = (Camera)this.logProperties.getCameras().get(i);
                LogTools.info((String)"Found camera: %s".formatted(camera.getName()));
                try {
                    if (camera.getTypeAsString().equals(CameraType.CAPTURE_CARD_MAGEWELL.toString())) {
                        MagewellScrubber magewellScrubber = new MagewellScrubber(camera, this.logDirectory, this.logProperties.getVideo().getHasTimebase());
                        this.magewellScrubbers.add(magewellScrubber);
                        continue;
                    }
                    BlackMagicScrubber blackMagicScrubber = new BlackMagicScrubber(camera, this.logDirectory, this.logProperties.getVideo().getHasTimebase());
                    this.blackMagicScrubbers.add(blackMagicScrubber);
                    continue;
                }
                catch (IOException e) {
                    LogTools.error((String)e.getMessage());
                }
            }
            for (File zedSensorDatFile : ZEDSVOScrubber.findZEDSensorDatFiles((File)this.logDirectory)) {
                LogTools.info((String)"Found ZED sensor: %s".formatted(zedSensorDatFile.getName()));
                ZEDSVOScrubber zedSVOScrubber = new ZEDSVOScrubber(zedSensorDatFile);
                this.zedSVOScrubbers.add(zedSVOScrubber);
            }
        }
        return started;
    }

    public boolean stopSessionThread() {
        boolean stopped = super.stopSessionThread();
        if (stopped) {
            this.disposeScrubbers();
        }
        return stopped;
    }

    public void shutdownSession() {
        super.shutdownSession();
        this.disposeScrubbers();
    }

    private void disposeScrubbers() {
        for (MagewellScrubber magewellScrubber : this.magewellScrubbers) {
            magewellScrubber.getMagewellDemuxer().stop();
        }
        for (BlackMagicScrubber blackMagicScrubber : this.blackMagicScrubbers) {
            blackMagicScrubber.getDemuxer().delete();
        }
        for (ZEDSVOScrubber zedSVOScrubber : this.zedSVOScrubbers) {
            zedSVOScrubber.close();
        }
        this.magewellScrubbers.clear();
        this.blackMagicScrubbers.clear();
        this.zedSVOScrubbers.clear();
    }

    public List<MagewellScrubber> getMagewellScrubbers() {
        return this.magewellScrubbers;
    }

    public List<BlackMagicScrubber> getBlackMagicScrubbers() {
        return this.blackMagicScrubbers;
    }

    public List<ZEDSVOScrubber> getZedSVOScrubbers() {
        return this.zedSVOScrubbers;
    }
}

