/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.mecano.multiBodySystem.CrossFourBarJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.scs2.definition.controller.ControllerInput;
import us.ihmc.scs2.definition.controller.ControllerOutput;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFloatingRootJoint;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SCS2KinematicsSimulationOutputWriter
implements JointDesiredOutputWriter {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ControllerInput controllerInput;
    private final ControllerOutput controllerOutput;
    private final boolean writeBeforeEstimatorTick;
    private final List<JointController> jointControllers = new ArrayList<JointController>();
    private final Map<String, JointController> jointControllerMap = new HashMap<String, JointController>();
    private JointDesiredOutputBasics floatingJointDesiredOutput;
    private SimFloatingRootJoint simFloatingRootJoint;
    private RootJointDesiredConfigurationDataReadOnly outputForRootJoint;

    public SCS2KinematicsSimulationOutputWriter(ControllerInput controllerInput, ControllerOutput controllerOutput, boolean writeBeforeEstimatorTick) {
        this.controllerInput = controllerInput;
        this.controllerOutput = controllerOutput;
        this.writeBeforeEstimatorTick = writeBeforeEstimatorTick;
    }

    public void setOutputForRootJoint(RootJointDesiredConfigurationDataReadOnly outputForRootJoint) {
        this.outputForRootJoint = outputForRootJoint;
        this.simFloatingRootJoint = (SimFloatingRootJoint)this.controllerInput.getInput().getRootBody().getChildrenJoints().get(0);
    }

    public void setJointDesiredOutputList(JointDesiredOutputListBasics jointDesiredOutputList) {
        this.jointControllers.clear();
        for (int i = 0; i < jointDesiredOutputList.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly controllerJoint = jointDesiredOutputList.getOneDoFJoint(i);
            JointDesiredOutputBasics jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput(i);
            if (controllerJoint instanceof CrossFourBarJointBasics) {
                JointController jointController;
                CrossFourBarJointBasics controllerFourBarJoint = (CrossFourBarJointBasics)controllerJoint;
                if (this.controllerOutput.getInput().findJoint(controllerFourBarJoint.getName()) != null) {
                    OneDoFJointStateBasics simJointInput = this.controllerOutput.getOneDoFJointOutput(controllerJoint);
                    OneDoFJointReadOnly simJointOutput = (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerJoint.getName());
                    jointController = new OneDoFJointController(simJointOutput, simJointInput, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
                    this.jointControllers.add(jointController);
                    this.jointControllerMap.put(controllerFourBarJoint.getName(), jointController);
                    continue;
                }
                OneDoFJointStateBasics[] simInputs = new OneDoFJointStateBasics[]{this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointA()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointB()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointC()), this.controllerOutput.getOneDoFJointOutput((OneDoFJointReadOnly)controllerFourBarJoint.getJointD())};
                OneDoFJointReadOnly[] simOutputs = new OneDoFJointReadOnly[]{(OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointA().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointB().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointC().getName()), (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerFourBarJoint.getJointD().getName())};
                jointController = new CrossFourBarJointController(controllerFourBarJoint, simOutputs, simInputs, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
                this.jointControllers.add(jointController);
                this.jointControllerMap.put(controllerFourBarJoint.getName(), jointController);
                continue;
            }
            OneDoFJointStateBasics simJointInput = this.controllerOutput.getOneDoFJointOutput(controllerJoint);
            OneDoFJointReadOnly simJointOutput = (OneDoFJointReadOnly)this.controllerInput.getInput().findJoint(controllerJoint.getName());
            OneDoFJointController jointController = new OneDoFJointController(simJointOutput, simJointInput, (JointDesiredOutputReadOnly)jointDesiredOutput, this.registry);
            this.jointControllers.add(jointController);
            this.jointControllerMap.put(simJointOutput.getName(), jointController);
        }
    }

    protected void write() {
        DMatrixRMaj desiredAcceleration = this.outputForRootJoint.getDesiredAcceleration();
        desiredAcceleration.reshape(6, 1, true);
        this.simFloatingRootJoint.setJointAcceleration(0, (DMatrix)desiredAcceleration);
        for (int i = 0; i < this.jointControllers.size(); ++i) {
            this.jointControllers.get(i).doControl();
        }
    }

    public void writeBefore(long timestamp) {
        if (this.writeBeforeEstimatorTick) {
            this.write();
        }
    }

    public void writeAfter() {
        if (!this.writeBeforeEstimatorTick) {
            this.write();
        }
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    private class OneDoFJointController
    implements JointController {
        private final OneDoFJointReadOnly simOutput;
        private final OneDoFJointStateBasics simInput;
        private final JointDesiredOutputReadOnly jointDesiredOutput;

        public OneDoFJointController(OneDoFJointReadOnly simOutput, OneDoFJointStateBasics simInput, JointDesiredOutputReadOnly jointDesiredOutput, YoRegistry registry) {
            this.simOutput = simOutput;
            this.simInput = simInput;
            this.jointDesiredOutput = jointDesiredOutput;
        }

        @Override
        public void doControl() {
            if (this.jointDesiredOutput.hasDesiredAcceleration()) {
                this.simInput.setAcceleration(this.jointDesiredOutput.getDesiredAcceleration());
            }
        }
    }

    private class CrossFourBarJointController
    implements JointController {
        private final CrossFourBarJoint localFourBarJoint;
        private final OneDoFJointReadOnly[] simOutputs;
        private final int[] torqueSourceIndices;
        private final OneDoFJointStateBasics[] simInputs;
        private final JointDesiredOutputReadOnly jointDesiredOutput;

        public CrossFourBarJointController(CrossFourBarJointBasics controllerFourBarJoint, OneDoFJointReadOnly[] simOutputs, OneDoFJointStateBasics[] simInputs, JointDesiredOutputReadOnly jointDesiredOutput, YoRegistry registry) {
            this.simOutputs = simOutputs;
            this.simInputs = simInputs;
            this.jointDesiredOutput = jointDesiredOutput;
            this.localFourBarJoint = CrossFourBarJoint.cloneCrossFourBarJoint((CrossFourBarJointReadOnly)controllerFourBarJoint, (ReferenceFrame)ReferenceFrameTools.constructARootFrame((String)"dummy"), (String)"");
            this.torqueSourceIndices = controllerFourBarJoint.getJointA().isLoopClosure() || controllerFourBarJoint.getJointD().isLoopClosure() ? new int[]{1, 2} : new int[]{0, 3};
        }

        @Override
        public void doControl() {
            this.updateFourBarJoint();
            double tau_actuated = this.localFourBarJoint.computeActuatedJointTau(this.jointDesiredOutput.getDesiredTorque());
            for (OneDoFJointStateBasics simInput : this.simInputs) {
                if (simInput == null) continue;
                simInput.setEffort(0.0);
            }
            for (int torqueSourceIndex : this.torqueSourceIndices) {
                double tau = 0.5 * tau_actuated / this.localFourBarJoint.getFourBarFunction().getLoopJacobian().get(torqueSourceIndex);
                this.simInputs[torqueSourceIndex].setEffort(tau);
            }
        }

        private void updateFourBarJoint() {
            this.localFourBarJoint.setQ(this.simOutputs[this.torqueSourceIndices[0]].getQ() + this.simOutputs[this.torqueSourceIndices[1]].getQ());
            this.localFourBarJoint.setQd(this.simOutputs[this.torqueSourceIndices[0]].getQd() + this.simOutputs[this.torqueSourceIndices[1]].getQd());
            this.localFourBarJoint.updateFrame();
        }
    }

    private static interface JointController {
        public void doControl();
    }
}

