/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.Objects;
import us.ihmc.avatar.AvatarControllerThread;
import us.ihmc.avatar.AvatarEstimatorThread;
import us.ihmc.avatar.AvatarStepGeneratorThread;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.factory.DisposableRobotController;
import us.ihmc.avatar.initialSetup.RobotInitialSetup;
import us.ihmc.avatar.logging.IntraprocessYoVariableLogger;
import us.ihmc.avatar.networkProcessor.kinematicsStreamingToolboxModule.IKStreamingRTPluginFactory;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.corruptors.FullRobotModelCorruptor;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.RotationMatrixTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.YoVariableServer;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.state.interfaces.SixDoFJointStateBasics;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputWriter;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.dataBuffer.MirroredYoVariableRegistry;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SCS2AvatarSimulation {
    private static final double CAMERA_PITCH_FROM_ROBOT = Math.toRadians(-15.0);
    private static final double CAMERA_YAW_FROM_ROBOT = Math.toRadians(15.0);
    private static final double CAMERA_DISTANCE_FROM_ROBOT = 6.0;
    private Robot robot;
    private SimulationConstructionSet2 simulationConstructionSet;
    private HighLevelHumanoidControllerFactory highLevelHumanoidControllerFactory;
    private YoVariableServer yoVariableServer;
    private IntraprocessYoVariableLogger intraprocessYoVariableLogger;
    private DisposableRobotController robotController;
    private HumanoidRobotContextData masterContext;
    private AvatarEstimatorThread estimatorThread;
    private AvatarControllerThread controllerThread;
    private AvatarStepGeneratorThread stepGeneratorThread;
    private IKStreamingRTPluginFactory.IKStreamingRTThread ikStreamingRTThread;
    private JointDesiredOutputWriter outputWriter;
    private SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider;
    private FullHumanoidRobotModel controllerFullRobotModel;
    private RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup;
    private DRCRobotModel robotModel;
    private boolean showGUI;
    private boolean automaticallyStartSimulation;
    private RealtimeROS2Node realtimeROS2Node;
    private boolean systemExitOnDestroy = true;
    private boolean javaFXThreadImplicitExit = true;
    private boolean hasBeenDestroyed = false;

    public void start() {
        this.beforeSessionThreadStart();
        this.simulationConstructionSet.setJavaFXThreadImplicitExit(Boolean.valueOf(this.javaFXThreadImplicitExit));
        this.simulationConstructionSet.setVisualizerEnabled(this.showGUI);
        this.simulationConstructionSet.startSimulationThread();
        this.simulationConstructionSet.addVisualizerShutdownListener(this::destroy);
        if (this.automaticallyStartSimulation) {
            this.simulationConstructionSet.simulate();
        }
        this.afterSessionThreadStart();
    }

    public void beforeSessionThreadStart() {
        if (this.intraprocessYoVariableLogger != null) {
            this.intraprocessYoVariableLogger.start();
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.start();
        }
    }

    public void afterSessionThreadStart() {
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.spin();
        }
        if (this.simulationConstructionSet.isVisualizerEnabled()) {
            this.simulationConstructionSet.waitUntilVisualizerFullyUp();
        }
    }

    public void destroy() {
        if (this.hasBeenDestroyed) {
            return;
        }
        LogTools.info((String)"Destroying simulation");
        this.hasBeenDestroyed = true;
        if (this.robotController != null) {
            this.robotController.dispose();
            this.robotController = null;
        }
        if (this.yoVariableServer != null) {
            this.yoVariableServer.close();
            this.yoVariableServer = null;
        }
        if (this.realtimeROS2Node != null) {
            this.realtimeROS2Node.destroy();
            this.realtimeROS2Node = null;
        }
        if (this.simulationConstructionSet != null) {
            this.simulationConstructionSet.shutdownSession();
            this.simulationConstructionSet = null;
        }
        if (this.systemExitOnDestroy) {
            System.exit(0);
        }
    }

    public void resetRobot() {
        this.resetRobot(true);
    }

    public void resetRobot(boolean simulateAfterReset) {
        this.simulationConstructionSet.pause();
        boolean wasSimulationThreadRunning = this.simulationConstructionSet.isSimulationThreadRunning();
        if (wasSimulationThreadRunning) {
            this.simulationConstructionSet.stopSimulationThread();
        }
        this.simulationConstructionSet.reinitializeSimulation();
        this.simulationConstructionSet.setBufferInPoint();
        if (wasSimulationThreadRunning) {
            this.simulationConstructionSet.startSimulationThread();
            if (simulateAfterReset) {
                this.simulationConstructionSet.simulate();
            }
        }
    }

    public void forceMirrorRegistryUpdate() {
        if (this.simulationConstructionSet.isSimulating()) {
            return;
        }
        YoRegistry registry = this.robotController.getYoRegistry();
        for (int i = 0; i < registry.getChildren().size(); ++i) {
            YoRegistry controllerRegistry = (YoRegistry)registry.getChildren().get(i);
            if (!(controllerRegistry instanceof MirroredYoVariableRegistry)) continue;
            ((MirroredYoVariableRegistry)controllerRegistry).updateChangedValues();
        }
    }

    private void initializeCamera(Orientation3DReadOnly robotOrientation, Tuple3DReadOnly robotPosition) {
        Point3D focusPosition = new Point3D(robotPosition);
        Point3D cameraPosition = new Point3D(10.0, 0.0, 0.0);
        RotationMatrixTools.applyPitchRotation((double)CAMERA_PITCH_FROM_ROBOT, (Tuple3DReadOnly)cameraPosition, (Tuple3DBasics)cameraPosition);
        RotationMatrixTools.applyYawRotation((double)CAMERA_YAW_FROM_ROBOT, (Tuple3DReadOnly)cameraPosition, (Tuple3DBasics)cameraPosition);
        RotationMatrixTools.applyYawRotation((double)robotOrientation.getYaw(), (Tuple3DReadOnly)cameraPosition, (Tuple3DBasics)cameraPosition);
        cameraPosition.scale(6.0 / cameraPosition.distanceFromOrigin());
        cameraPosition.add((Tuple3DReadOnly)focusPosition);
        this.setCamera((Point3DReadOnly)focusPosition, (Point3DReadOnly)cameraPosition);
    }

    private void checkSimulationSessionAlive() {
        if (this.getSimulationConstructionSet().isSessionShutdown()) {
            throw new IllegalStateException("Simulation has been shutdown");
        }
    }

    public void setCameraDefaultRobotView() {
        this.checkSimulationSessionAlive();
        SixDoFJointStateBasics initialRootJointState = (SixDoFJointStateBasics)((JointDefinition)this.getRobotDefinition().getRootJointDefinitions().get(0)).getInitialJointState();
        if (initialRootJointState != null) {
            this.initializeCamera((Orientation3DReadOnly)initialRootJointState.getOrientation(), (Tuple3DReadOnly)initialRootJointState.getPosition());
        }
    }

    public void setCameraZoom(double distanceFromFocus) {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().setCameraZoom(distanceFromFocus);
    }

    public void setCameraFocusPosition(Point3DReadOnly focus) {
        this.checkSimulationSessionAlive();
        this.setCameraFocusPosition(focus.getX(), focus.getY(), focus.getZ());
    }

    public void setCameraFocusPosition(double x, double y, double z) {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().setCameraFocusPosition(x, y, z);
    }

    public void setCameraPosition(Point3DReadOnly position) {
        this.setCameraPosition(position.getX(), position.getY(), position.getZ());
    }

    public void setCameraPosition(double x, double y, double z) {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().setCameraPosition(x, y, z);
    }

    public void setCamera(Point3DReadOnly cameraFocus, Point3DReadOnly cameraPosition) {
        this.setCameraFocusPosition(cameraFocus);
        this.setCameraPosition(cameraPosition);
    }

    public void requestCameraRigidBodyTracking(String rigidBodyName) {
        Objects.requireNonNull(this.robot, "The robot has not been set yet.");
        this.requestCameraRigidBodyTracking(this.robot.getName(), rigidBodyName);
    }

    public void requestCameraRigidBodyTracking(String robotName, String rigidBodyName) {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().requestCameraRigidBodyTracking(robotName, rigidBodyName);
    }

    public boolean hasBeenDestroyed() {
        return this.hasBeenDestroyed;
    }

    public SimulationConstructionSet2 getSimulationConstructionSet() {
        return this.simulationConstructionSet;
    }

    public FullHumanoidRobotModel getControllerFullRobotModel() {
        return this.controllerFullRobotModel;
    }

    public void setSystemExitOnDestroy(boolean systemExitOnDestroy) {
        this.systemExitOnDestroy = systemExitOnDestroy;
    }

    public void setJavaFXThreadImplicitExit(boolean javaFXThreadImplicitExit) {
        this.javaFXThreadImplicitExit = javaFXThreadImplicitExit;
    }

    public void addRobotControllerOnControllerThread(RobotController controller) {
        this.controllerThread.addRobotController(controller);
    }

    public FullRobotModelCorruptor getFullRobotModelCorruptor() {
        return this.controllerThread.getFullRobotModelCorruptor();
    }

    public HighLevelHumanoidControllerFactory getHighLevelHumanoidControllerFactory() {
        return this.highLevelHumanoidControllerFactory;
    }

    public SimulatedDRCRobotTimeProvider getSimulatedRobotTimeProvider() {
        return this.simulatedRobotTimeProvider;
    }

    public void setSimulationConstructionSet(SimulationConstructionSet2 simulationConstructionSet) {
        this.simulationConstructionSet = simulationConstructionSet;
    }

    public void setHighLevelHumanoidControllerFactory(HighLevelHumanoidControllerFactory momentumBasedControllerFactory) {
        this.highLevelHumanoidControllerFactory = momentumBasedControllerFactory;
    }

    public void setYoVariableServer(YoVariableServer yoVariableServer) {
        this.yoVariableServer = yoVariableServer;
    }

    public void setIntraprocessYoVariableLogger(IntraprocessYoVariableLogger intraprocessYoVariableLogger) {
        this.intraprocessYoVariableLogger = intraprocessYoVariableLogger;
    }

    public void setRobotController(DisposableRobotController robotController) {
        this.robotController = robotController;
    }

    public void setMasterContext(HumanoidRobotContextData masterContext) {
        this.masterContext = masterContext;
    }

    public void setEstimatorThread(AvatarEstimatorThread estimatorThread) {
        this.estimatorThread = estimatorThread;
    }

    public AvatarEstimatorThread getEstimatorThread() {
        return this.estimatorThread;
    }

    public void setControllerThread(AvatarControllerThread controllerThread) {
        this.controllerThread = controllerThread;
    }

    public AvatarControllerThread getControllerThread() {
        return this.controllerThread;
    }

    public void setStepGeneratorThread(AvatarStepGeneratorThread stepGeneratorThread) {
        this.stepGeneratorThread = stepGeneratorThread;
    }

    public AvatarStepGeneratorThread getStepGeneratorThread() {
        return this.stepGeneratorThread;
    }

    public void setIKStreamingRTThread(IKStreamingRTPluginFactory.IKStreamingRTThread ikStreamingRTThread) {
        this.ikStreamingRTThread = ikStreamingRTThread;
    }

    public IKStreamingRTPluginFactory.IKStreamingRTThread getIKStreamingRTThread() {
        return this.ikStreamingRTThread;
    }

    public void setOutputWriter(JointDesiredOutputWriter outputWriter) {
        this.outputWriter = outputWriter;
    }

    public JointDesiredOutputWriter getOutputWriter() {
        return this.outputWriter;
    }

    public void setSimulatedRobotTimeProvider(SimulatedDRCRobotTimeProvider simulatedRobotTimeProvider) {
        this.simulatedRobotTimeProvider = simulatedRobotTimeProvider;
    }

    public void setFullHumanoidRobotModel(FullHumanoidRobotModel controllerFullRobotModel) {
        this.controllerFullRobotModel = controllerFullRobotModel;
    }

    public void addRobotControllerOnEstimatorThread(RobotController controller) {
        this.estimatorThread.addRobotController(controller);
    }

    public void setRobot(Robot robot) {
        this.robot = robot;
    }

    public Robot getRobot() {
        return this.robot;
    }

    public RobotDefinition getRobotDefinition() {
        return this.robot.getRobotDefinition();
    }

    public void setRobotInitialSetup(RobotInitialSetup<HumanoidFloatingRootJointRobot> robotInitialSetup) {
        this.robotInitialSetup = robotInitialSetup;
    }

    public RobotInitialSetup<HumanoidFloatingRootJointRobot> getRobotInitialSetup() {
        return this.robotInitialSetup;
    }

    public void setRobotModel(DRCRobotModel robotModel) {
        this.robotModel = robotModel;
    }

    public DRCRobotModel getRobotModel() {
        return this.robotModel;
    }

    public void setShowGUI(boolean showGUI) {
        this.showGUI = showGUI;
    }

    public boolean getShowGUI() {
        return this.showGUI;
    }

    public void cropBuffer() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().cropBuffer();
    }

    public void setInPoint() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().setBufferInPoint();
    }

    public void setOutPoint() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().setBufferOutPoint();
    }

    public void gotoInPoint() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().gotoBufferInPoint();
    }

    public void gotoOutPoint() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().gotoBufferOutPoint();
    }

    public void gotoBufferIndex(int bufferIndex) {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().gotoBufferIndex(bufferIndex);
    }

    public int getOutPoint() {
        this.checkSimulationSessionAlive();
        return this.getSimulationConstructionSet().getBufferOutPoint();
    }

    public int getInPoint() {
        this.checkSimulationSessionAlive();
        return this.getSimulationConstructionSet().getBufferInPoint();
    }

    public void stepBufferIndexForward() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().stepBufferIndexForward();
    }

    public void stepBufferIndexBackward() {
        this.checkSimulationSessionAlive();
        this.getSimulationConstructionSet().stepBufferIndexBackward();
    }

    public void setAutomaticallyStartSimulation(boolean automaticallyStartSimulation) {
        this.automaticallyStartSimulation = automaticallyStartSimulation;
    }

    public void setRealTimeROS2Node(RealtimeROS2Node realtimeROS2Node) {
        this.realtimeROS2Node = realtimeROS2Node;
    }
}

