/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scs2;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimMultiBodySystemBasics;
import us.ihmc.scs2.simulation.screwTools.SingleRobotFirstOrderIntegrator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class KinematicsSimulationPhysicsEngine
implements PhysicsEngine {
    private final ReferenceFrame inertialFrame;
    private final SingleRobotFirstOrderIntegrator integrator = new SingleRobotFirstOrderIntegrator();
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final List<Robot> robotList = new ArrayList<Robot>();
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private boolean hasBeenInitialized = false;

    public KinematicsSimulationPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        this.rootRegistry = rootRegistry;
        this.inertialFrame = inertialFrame;
    }

    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
    }

    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        this.rootRegistry.addChild(robot.getRegistry());
        this.physicsEngineRegistry.addChild(robot.getSecondaryRegistry());
        this.robotList.add(robot);
    }

    public void initialize(Vector3DReadOnly gravity) {
        for (Robot robot : this.robotList) {
            robot.initializeState();
            robot.getControllerManager().initializeControllers();
        }
        this.hasBeenInitialized = true;
    }

    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        if (!this.hasBeenInitialized) {
            this.initialize(gravity);
            return;
        }
        for (Robot robot : this.robotList) {
            robot.updateFrames();
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutputForAllJoints(JointStateType.values());
            this.integrator.integrate(dt, (SimMultiBodySystemBasics)robot);
        }
    }

    public void pause() {
        for (Robot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<Robot> getRobots() {
        return this.robotList;
    }

    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(Robot::getRobotDefinition).collect(Collectors.toList());
    }

    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions() {
        return null;
    }

    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }
}

