/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextTool
extends JPanel {
    private static JPanel menuBar;
    private static JPanel textPanel;
    private static JTextArea textArea;
    private static JMenuBar jMenuBar;
    private JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
    private String currentFile = "Untitled";
    private boolean changed = false;
    private KeyListener k1 = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            TextTool.this.changed = true;
            TextTool.this.Save.setEnabled(true);
            TextTool.this.SaveAs.setEnabled(true);
        }
    };
    Action Open = new AbstractAction("Open", new ImageIcon("open.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.saveOld();
            if (TextTool.this.dialog.showOpenDialog(null) == 0) {
                TextTool.this.readInFile(TextTool.this.dialog.getSelectedFile().getAbsolutePath());
            }
            TextTool.this.SaveAs.setEnabled(true);
        }
    };
    Action Save = new AbstractAction("Save", new ImageIcon("save.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TextTool.this.currentFile.equals("Untitled")) {
                TextTool.this.saveFile(TextTool.this.currentFile);
            } else {
                TextTool.this.saveFileAs();
            }
        }
    };
    Action SaveAs = new AbstractAction("Save as..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.saveFileAs();
        }
    };
    Action Quit = new AbstractAction("Quit"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.saveOld();
            System.exit(0);
        }
    };
    Action find = new AbstractAction("Find Element"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextTool.this.find();
        }
    };

    public TextTool() {
        menuBar = new JPanel(new FlowLayout(0));
        textArea = new JTextArea(18, 109);
        textPanel = new JPanel();
        jMenuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenu find = new JMenu("Find");
        textArea.setFont(new Font("Monospaced", 0, 14));
        JScrollPane scroller = new JScrollPane(textArea);
        scroller.setVerticalScrollBarPolicy(22);
        scroller.setHorizontalScrollBarPolicy(32);
        textPanel.add(scroller);
        file.add(this.Open);
        file.add(this.Save);
        file.add(this.Quit);
        file.add(this.SaveAs);
        file.addSeparator();
        this.Save.setEnabled(false);
        this.SaveAs.setEnabled(false);
        textArea.addKeyListener(this.k1);
        jMenuBar.add(file);
        jMenuBar.add(find);
        menuBar.add(jMenuBar);
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)menuBar, "West");
        this.add(textPanel);
        this.setVisible(true);
    }

    public void openTableData(String path) {
        this.readInFile(path);
    }

    private void saveFileAs() {
        if (this.dialog.showSaveDialog(null) == 0) {
            this.saveFile(this.dialog.getSelectedFile().getAbsolutePath());
        }
    }

    private void saveOld() {
        if (this.changed && JOptionPane.showConfirmDialog(this, "Would you like to save " + this.currentFile + " ?", "Save", 0) == 0) {
            this.saveFile(this.currentFile);
        }
    }

    private void find() {
        System.out.println("Find button has been pressed");
        JOptionPane.showInputDialog(null, "Enter something to search", 1);
    }

    private void readInFile(String fileName) {
        try {
            FileReader r = new FileReader(fileName);
            textArea.read(r, null);
            r.close();
            this.currentFile = fileName;
            this.changed = false;
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Editor can't find the file called " + fileName);
        }
    }

    private void saveFile(String fileName) {
        try {
            FileWriter w = new FileWriter(fileName);
            textArea.write(w);
            w.close();
            this.currentFile = fileName;
            this.changed = false;
            this.Save.setEnabled(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

