/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class TextEditor
extends JFrame {
    private JFrame frame = new JFrame();
    private JPanel panel = new JPanel();
    private JPanel panel2 = new JPanel();
    private JTextArea area2 = new JTextArea(20, 120);
    private JTextArea area = new JTextArea(20, 120);
    private JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
    private String currentFile = "Untitled";
    private boolean changed = false;
    private KeyListener k1 = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            TextEditor.this.changed = true;
            TextEditor.this.Save.setEnabled(true);
            TextEditor.this.SaveAs.setEnabled(true);
        }
    };
    Action Open = new AbstractAction("Open", new ImageIcon("open.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextEditor.this.saveOld();
            if (TextEditor.this.dialog.showOpenDialog(null) == 0) {
                TextEditor.this.readInFile(TextEditor.this.dialog.getSelectedFile().getAbsolutePath());
            }
            TextEditor.this.SaveAs.setEnabled(true);
        }
    };
    Action Save = new AbstractAction("Save", new ImageIcon("save.gif")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TextEditor.this.currentFile.equals("Untitled")) {
                TextEditor.this.saveFile(TextEditor.this.currentFile);
            } else {
                TextEditor.this.saveFileAs();
            }
        }
    };
    Action SaveAs = new AbstractAction("Save as..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextEditor.this.saveFileAs();
        }
    };
    Action Quit = new AbstractAction("Quit"){

        @Override
        public void actionPerformed(ActionEvent e) {
            TextEditor.this.saveOld();
            System.exit(0);
        }
    };
    ActionMap m = this.area.getActionMap();
    Action Cut = this.m.get("cut-to-clipboard");
    Action Copy = this.m.get("copy-to-clipboard");
    Action Paste = this.m.get("paste-from-clipboard");

    public TextEditor() {
        this.frame.getContentPane().add("South", this.panel);
        this.area.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scroll = new JScrollPane(this.area, 22, 32);
        this.add((Component)scroll, "Center");
        JMenuBar JMB = new JMenuBar();
        this.setJMenuBar(JMB);
        JMenu file = new JMenu("File");
        JMenu edit = new JMenu("Edit");
        JMB.add(file);
        JMB.add(edit);
        file.add(this.Open);
        file.add(this.Save);
        file.add(this.Quit);
        file.add(this.SaveAs);
        file.addSeparator();
        for (int i = 0; i < 4; ++i) {
            file.getItem(i).setIcon(null);
        }
        edit.add(this.Cut);
        edit.add(this.Copy);
        edit.add(this.Paste);
        edit.getItem(0).setText("Cut out");
        edit.getItem(1).setText("Copy");
        edit.getItem(2).setText("Paste");
        JToolBar tool = new JToolBar();
        this.add((Component)tool, "North");
        tool.add(this.Open);
        tool.add(this.Save);
        tool.addSeparator();
        JButton cut = tool.add(this.Cut);
        JButton cop = tool.add(this.Copy);
        JButton pas = tool.add(this.Paste);
        cut.setText(null);
        cop.setText(null);
        pas.setText(null);
        this.Save.setEnabled(false);
        this.SaveAs.setEnabled(false);
        this.setDefaultCloseOperation(3);
        this.pack();
        this.area.addKeyListener(this.k1);
        this.setTitle(this.currentFile);
        this.setVisible(true);
    }

    private void saveFileAs() {
        if (this.dialog.showSaveDialog(null) == 0) {
            this.saveFile(this.dialog.getSelectedFile().getAbsolutePath());
        }
    }

    private void saveOld() {
        if (this.changed && JOptionPane.showConfirmDialog(this, "Would you like to save " + this.currentFile + " ?", "Save", 0) == 0) {
            this.saveFile(this.currentFile);
        }
    }

    private void readInFile(String fileName) {
        try {
            FileReader r = new FileReader(fileName);
            this.area.read(r, null);
            r.close();
            this.currentFile = fileName;
            this.setTitle(this.currentFile);
            this.changed = false;
        }
        catch (IOException e) {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this, "Editor can't find the file called " + fileName);
        }
    }

    private void saveFile(String fileName) {
        try {
            FileWriter w = new FileWriter(fileName);
            this.area.write(w);
            w.close();
            this.currentFile = fileName;
            this.setTitle(this.currentFile);
            this.changed = false;
            this.Save.setEnabled(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] arg) {
        new TextEditor();
    }
}

