/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileLoader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSaver;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.transform.RigidBodyTransform;

public abstract class ScriptTransformer {
    private final List<File> filesToTransform = new ArrayList<File>();
    private final HashSet<String> listOfDirectoriesContainingAtLeastOneScript = new HashSet();
    private final List<String> listOfDirectoriesToCreate = new ArrayList<String>();
    private final RigidBodyTransform identity = new RigidBodyTransform();

    public ScriptTransformer(String scriptDirectoryPath) throws IOException, InterruptedException {
        ScriptTransformer.findScripts(scriptDirectoryPath, this.filesToTransform, this.listOfDirectoriesContainingAtLeastOneScript);
        block7: for (File scriptFileToTransform : this.filesToTransform) {
            if (scriptFileToTransform.isDirectory()) {
                System.err.println("File should not be a director!?");
                continue;
            }
            File parentDirectory = scriptFileToTransform.getParentFile();
            if (parentDirectory.isDirectory()) {
                File subDirectoryToMoveOriginals = new File(parentDirectory, "OriginalBackups");
                if (!subDirectoryToMoveOriginals.exists()) {
                    subDirectoryToMoveOriginals.mkdir();
                }
                File scriptFileToTransformBackup = new File(subDirectoryToMoveOriginals, scriptFileToTransform.getName());
                Files.copy(scriptFileToTransform.toPath(), scriptFileToTransformBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            ArrayList<ScriptObject> scriptObjects = new ArrayList<ScriptObject>();
            ArrayList<Object> newScriptObjects = new ArrayList<Object>();
            ScriptFileLoader scriptFileLoader = null;
            String scriptName = scriptFileToTransform.getName();
            try {
                scriptFileLoader = new ScriptFileLoader(scriptFileToTransform);
            }
            catch (StreamException e) {
                PrintTools.error((String)("Empty script: " + scriptName));
                continue;
            }
            while (true) {
                try {
                    while (true) {
                        scriptObjects.add(scriptFileLoader.getScriptObject(this.identity));
                    }
                }
                catch (ConversionException | CannotResolveClassException e) {
                    if (e.getCause() != null) {
                        PrintTools.error((String)("In script: " + scriptName + ". Problem loading packet, cause: " + e.getCause().getMessage()));
                        continue;
                    }
                    PrintTools.error((String)("In script: " + scriptName + ". Problem loading packet, exception: " + e.getClass().getSimpleName() + ", message: " + e.getMessage()));
                    continue;
                }
                catch (StreamException | IOException e) {
                    scriptFileLoader.close();
                    for (ScriptObject scriptObject : scriptObjects) {
                        Object object = scriptObject.getScriptObject();
                        Object object2 = this.transformScriptObject(object);
                        newScriptObjects.add(object2);
                    }
                    File newScript = new File(scriptFileToTransform.getParentFile(), scriptFileToTransform.getName());
                    ScriptFileSaver scriptFileSaver = null;
                    try {
                        scriptFileSaver = new ScriptFileSaver(newScript, true);
                    }
                    catch (IOException e2) {
                        PrintTools.error((String)("During writing: " + e2.getClass().getSimpleName() + " for the file:" + String.valueOf(newScript)));
                        if (e2.getCause() != null) {
                            PrintTools.error((String)e2.getCause().getMessage());
                            continue block7;
                        }
                        PrintTools.error((String)e2.getMessage());
                        continue block7;
                    }
                    for (Object e2 : newScriptObjects) {
                        ScriptObject newScriptObject = new ScriptObject(System.currentTimeMillis(), e2);
                        scriptFileSaver.recordObject(newScriptObject.getTimeStamp(), newScriptObject.getScriptObject());
                    }
                    scriptFileSaver.close();
                    System.out.println("Done transforming script: " + String.valueOf(newScript));
                    continue block7;
                }
                break;
            }
        }
    }

    public abstract Object transformScriptObject(Object var1);

    private static void findScripts(String scriptDirectoryPath, List<File> foundScriptFilesToPack, Set<String> listOfDirectoriesContainingAtLeastOneScript) throws IOException {
        File[] filesInDirectory;
        ArrayList potentialSubDirectories = new ArrayList();
        File directory = new File(scriptDirectoryPath);
        if (!directory.isDirectory()) {
            if (directory.getName().endsWith(".xml")) {
                System.out.println("Found script file: " + directory.getName());
                foundScriptFilesToPack.add(directory);
            }
            return;
        }
        System.out.println(directory.getAbsolutePath() + " is a directory. Exploring contents");
        for (File file : filesInDirectory = directory.listFiles()) {
            String filename = file.getName();
            if (!filename.endsWith(".xml")) continue;
            System.out.println("Found script file: " + filename);
            foundScriptFilesToPack.add(file);
        }
        for (int i = 0; i < potentialSubDirectories.size(); ++i) {
            ScriptTransformer.findScripts((String)potentialSubDirectories.get(i), foundScriptFilesToPack, listOfDirectoriesContainingAtLeastOneScript);
        }
    }

    public Iterable<File> getFilesToTransform() {
        return this.filesToTransform;
    }

    public Iterable<String> getListOfOriginalDirectories() {
        return this.listOfDirectoriesContainingAtLeastOneScript;
    }

    public Iterable<String> getListOfNewDirectories() {
        return this.listOfDirectoriesToCreate;
    }
}

