/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import com.thoughtworks.xstream.io.StreamException;
import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileLoader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSelector;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.humanoidRobotics.communication.packets.walking.EndOfScriptCommand;

public class ScriptTools {
    public static void removeAllUnnecessaryScripObjects(ArrayList<ScriptObject> listToEdit) {
        ScriptTools.removeAllEndOfScripts(listToEdit);
        ScriptTools.removeAllPauses(listToEdit);
        ScriptTools.removeAllZeroStepLists(listToEdit);
    }

    private static void removePausesAndZeroStepLists(ArrayList<ScriptObject> listToEdit) {
        int beforeSize;
        int afterSize;
        do {
            beforeSize = listToEdit.size();
            ScriptTools.removePausesAndZeroStepListsInnnerOpeartion(listToEdit);
        } while ((afterSize = listToEdit.size()) < beforeSize);
    }

    private static void removeAllEndOfScripts(ArrayList<ScriptObject> listToEdit) {
        for (int i = listToEdit.size() - 1; i >= 0; --i) {
            if (!(listToEdit.get(i).getScriptObject() instanceof EndOfScriptCommand)) continue;
            listToEdit.remove(i);
        }
    }

    private static void removeAllFootPosePackets(ArrayList<ScriptObject> listToEdit) {
        for (int i = listToEdit.size() - 1; i >= 0; --i) {
            if (!(listToEdit.get(i).getScriptObject() instanceof FootTrajectoryMessage)) continue;
            listToEdit.remove(i);
        }
    }

    private static void removeAllPauses(ArrayList<ScriptObject> listToEdit) {
        for (int i = listToEdit.size() - 1; i >= 0; --i) {
            if (!(listToEdit.get(i).getScriptObject() instanceof PauseWalkingMessage)) continue;
            listToEdit.remove(i);
        }
    }

    private static void removeAllZeroStepLists(ArrayList<ScriptObject> listToEdit) {
        for (int i = listToEdit.size() - 1; i >= 0; --i) {
            if (!(listToEdit.get(i).getScriptObject() instanceof FootstepDataListMessage) || ((FootstepDataListMessage)listToEdit.get(i).getScriptObject()).getFootstepDataList().size() != 0) continue;
            listToEdit.remove(i);
        }
    }

    private static void removePausesAndZeroStepListsInnnerOpeartion(ArrayList<ScriptObject> listToEdit) {
        boolean previousWasPause = false;
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        for (int i = 0; i < listToEdit.size(); ++i) {
            ScriptObject scriptObject = listToEdit.get(i);
            if (scriptObject.getScriptObject() instanceof PauseWalkingMessage) {
                if (((PauseWalkingMessage)scriptObject.getScriptObject()).getPause()) {
                    if (previousWasPause) {
                        elementsToRemove.add(i);
                    } else {
                        previousWasPause = true;
                    }
                } else {
                    previousWasPause = false;
                }
            } else {
                previousWasPause = false;
            }
            if (!(scriptObject.getScriptObject() instanceof FootstepDataListMessage) || ((FootstepDataListMessage)scriptObject.getScriptObject()).getFootstepDataList().size() != 0) continue;
            elementsToRemove.add(i);
        }
        Collections.reverse(elementsToRemove);
        for (Integer integer : elementsToRemove) {
            listToEdit.remove(integer);
        }
    }

    public static void main(String[] args) {
        File file = ScriptFileSelector.getScriptFileFromUserSelection(".xml");
        System.out.println("Loading file: " + file.getAbsolutePath());
        ScriptFileLoader loader = null;
        try {
            loader = new ScriptFileLoader(file);
        }
        catch (StreamException | IOException e) {
            PrintTools.error((String)e.getMessage());
            System.exit(-1);
        }
        ArrayList<ScriptObject> scriptObjects = loader.readIntoList();
        loader.close();
        System.out.println("Before:");
        System.out.println(ScriptObject.getListInfo(scriptObjects));
        ScriptTools.removeAllUnnecessaryScripObjects(scriptObjects);
        System.out.println("\nAfter:");
        System.out.println(ScriptObject.getListInfo(scriptObjects));
        System.exit(-1);
    }
}

