/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import us.ihmc.avatar.scriptCommandGenerator.ScriptEngineSettings;

public class ScriptFileSelector {
    public static File getScriptFileFromUserSelection(String fileExtension) {
        JFileChooser chooser = ScriptFileSelector.getFileChooser(fileExtension);
        if (chooser != null) {
            File fileName = chooser.getSelectedFile();
            return fileName;
        }
        return null;
    }

    private static JFileChooser getFileChooser(String fileExtension) {
        JFileChooser chooser = new JFileChooser(new File(ScriptEngineSettings.scriptLoadingDirectory));
        chooser.setFileFilter(ScriptFileSelector.getIsoDataPathFilter(fileExtension));
        int returnVal = chooser.showOpenDialog(new JFrame());
        if (returnVal != 0) {
            System.err.println("Can not load selected file: " + chooser.getName());
            return null;
        }
        return chooser;
    }

    private static FileFilter getIsoDataPathFilter(String fileExtension) {
        return new ProperEndingFileOrDirectoryFilter(fileExtension, true);
    }

    public static void main(String[] args) {
        System.out.println(ScriptFileSelector.getScriptFileFromUserSelection(".xml"));
        System.exit(0);
    }

    private static class ProperEndingFileOrDirectoryFilter
    extends FileFilter {
        private final String ending;
        private final boolean includeDirectories;

        public ProperEndingFileOrDirectoryFilter(String ending, boolean includeDirectories) {
            this.ending = ending;
            this.includeDirectories = includeDirectories;
        }

        @Override
        public boolean accept(File file) {
            return file.getAbsolutePath().endsWith(this.ending) || this.includeDirectories && file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*" + this.ending;
        }
    }
}

