/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import us.ihmc.avatar.scriptCommandGenerator.MessageTransformer;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.communication.packets.Packet;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.idl.IDLSequence;
import us.ihmc.pubsub.TopicDataType;

public class ScriptFileSaver {
    private final FileWriter fileWriter;
    private final ObjectOutputStream outputStream;

    public ScriptFileSaver(Path scriptFilePath, boolean overwriteExistingScript) throws IOException {
        this(scriptFilePath.toFile(), overwriteExistingScript);
    }

    public ScriptFileSaver(File file, boolean overwriteExistingScript) throws IOException {
        XStream xStream = new XStream();
        if (file.exists() && !overwriteExistingScript) {
            throw new IOException("File already exists");
        }
        file.createNewFile();
        this.fileWriter = new FileWriter(file.getAbsoluteFile());
        this.outputStream = xStream.createObjectOutputStream((Writer)this.fileWriter);
    }

    public void recordObject(long timestamp, Object object, RigidBodyTransform objectTransform) throws IOException {
        Object objectToWrite;
        try {
            objectToWrite = object.getClass().getConstructor(object.getClass()).newInstance(object);
        }
        catch (Exception e) {
            try {
                objectToWrite = object.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                objectToWrite.getClass().getMethod("set", object.getClass()).invoke(objectToWrite, object);
            }
            catch (Exception e1) {
                String className = object.getClass().getSimpleName();
                PrintTools.error((String)("The class: " + className + " needs either a copy constructor: " + className + "(" + className + "), or a setter: " + className + "set(" + className + ")."));
                return;
            }
        }
        MessageTransformer.transform(objectToWrite, objectTransform);
        this.recordObject(timestamp, objectToWrite);
    }

    public void recordObject(long timestamp, Object object) throws IOException {
        if (object instanceof Packet) {
            object = ScriptFileSaver.createCopyTrimmedToCurrentSize((Packet)object);
        }
        this.outputStream.writeLong(timestamp);
        this.outputStream.writeObject(object);
        this.outputStream.flush();
    }

    public static <T extends Packet<T>> T createCopyTrimmedToCurrentSize(T message) {
        if (message == null) {
            return null;
        }
        Class<?> messageClass = message.getClass();
        try {
            Packet copy = (Packet)messageClass.newInstance();
            copy.set(message);
            for (Field field : messageClass.getDeclaredFields()) {
                Class<?> fieldType = field.getType();
                if (Packet.class.isAssignableFrom(fieldType)) {
                    field.set(copy, ScriptFileSaver.createCopyTrimmedToCurrentSize((Packet)field.get(message)));
                    continue;
                }
                if (!IDLSequence.Object.class.isAssignableFrom(fieldType)) continue;
                field.set(copy, ScriptFileSaver.trimIDLSequenceObject((IDLSequence.Object)field.get(message)));
            }
            return (T)copy;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            return message;
        }
    }

    private static <T> IDLSequence.Object<T> trimIDLSequenceObject(IDLSequence.Object<T> list) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        TopicDataType topicDataType = list.getTopicDataType();
        Class<?> clazz = topicDataType.createData().getClass();
        IDLSequence.Object trimmed = new IDLSequence.Object(list.size(), clazz, topicDataType);
        Field allocatorField = trimmed.getClass().getSuperclass().getDeclaredField("allocator");
        allocatorField.setAccessible(true);
        allocatorField.set(trimmed, null);
        Field sizeField = trimmed.getClass().getSuperclass().getDeclaredField("size");
        sizeField.setAccessible(true);
        sizeField.set(trimmed, list.size());
        Field valuesField = trimmed.getClass().getSuperclass().getDeclaredField("values");
        valuesField.setAccessible(true);
        Object[] array = list.toArray();
        if (Packet.class.isAssignableFrom(clazz)) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = ScriptFileSaver.createCopyTrimmedToCurrentSize((Packet)array[i]);
            }
        }
        valuesField.set(trimmed, array);
        return trimmed;
    }

    public void close() {
        try {
            this.outputStream.close();
            this.fileWriter.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void recordList(ArrayList<ScriptObject> scriptObjects) throws IOException {
        for (ScriptObject scriptObject : scriptObjects) {
            this.recordObject(scriptObject.getTimeStamp(), scriptObject.getScriptObject());
        }
    }
}

