/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import us.ihmc.avatar.scriptCommandGenerator.MessageTransformer;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.transform.RigidBodyTransform;

public class ScriptFileLoader {
    private final BufferedReader reader;
    private ObjectInputStream inputStream;

    public ScriptFileLoader(Path scriptFilePath) throws IOException, StreamException {
        PrintTools.info((String)("Working directory: " + System.getProperty("user.dir")));
        if (!Files.exists(scriptFilePath, new LinkOption[0])) {
            throw new IOException("!Files.exists(path): " + scriptFilePath.toString());
        }
        XStream xStream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                    }
                };
            }
        };
        this.reader = Files.newBufferedReader(scriptFilePath);
        this.inputStream = xStream.createObjectInputStream((Reader)this.reader);
    }

    public ScriptFileLoader(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public ScriptFileLoader(InputStream scriptInputStream) throws IOException {
        XStream xStream = new XStream(){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        return definedIn != Object.class ? super.shouldSerializeMember(definedIn, fieldName) : false;
                    }
                };
            }
        };
        xStream.addPermission(type -> true);
        this.reader = null;
        this.inputStream = xStream.createObjectInputStream(scriptInputStream);
    }

    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.inputStream.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public Object readObject() throws IOException {
        try {
            return this.inputStream.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public long getTimestamp() throws IOException {
        return this.inputStream.readLong();
    }

    public Object getObject(RigidBodyTransform transform) throws IOException {
        try {
            Object object = this.inputStream.readObject();
            MessageTransformer.transform(object, transform);
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ScriptObject getScriptObject(RigidBodyTransform transform) throws IOException {
        long timestamp = this.getTimestamp();
        Object object = this.getObject(transform);
        return new ScriptObject(timestamp, object);
    }

    public ArrayList<ScriptObject> readIntoList() {
        return this.readIntoList(new RigidBodyTransform());
    }

    public ArrayList<ScriptObject> readIntoList(RigidBodyTransform transform) {
        ArrayList<ScriptObject> list = new ArrayList<ScriptObject>();
        try {
            while (true) {
                list.add(this.getScriptObject(transform));
            }
        }
        catch (IOException e) {
            return list;
        }
    }
}

