/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import com.thoughtworks.xstream.io.StreamException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import us.ihmc.avatar.scriptCommandGenerator.ScriptEngineUIInterface;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileLoader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSelector;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;

public class ScriptEngine {
    private final ScriptEngineUIInterface controllerHandler;
    private boolean isRecording = false;
    private ReferenceFrame scriptFrame;
    private RigidBodyTransform playbackTransform = new RigidBodyTransform();
    private File lastScriptFileLoaded = null;

    public ScriptEngine(ScriptEngineUIInterface controllerHandler) {
        this.controllerHandler = controllerHandler;
    }

    public void startRecording(Path scriptDirectory, String baseFileName) {
        this.controllerHandler.startRecordingScript(scriptDirectory, baseFileName, this.scriptFrame);
        this.isRecording = true;
    }

    public void stopRecording() {
        this.isRecording = false;
        this.controllerHandler.stopRecordingScript();
    }

    public void setFramesForRecord(ReferenceFrame currentScriptFrame) {
        this.scriptFrame = currentScriptFrame;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public ArrayList<ScriptObject> getLastLoadedScriptFile() {
        if (this.lastScriptFileLoaded == null) {
            return null;
        }
        return this.getScriptObjectsFromFile(this.lastScriptFileLoaded);
    }

    public ArrayList<ScriptObject> getScriptObjectsFromFile(File file) {
        try {
            ScriptFileLoader loader = new ScriptFileLoader(file);
            ArrayList<ScriptObject> scriptObjects = loader.readIntoList();
            loader.close();
            return scriptObjects;
        }
        catch (StreamException | IOException exception) {
            PrintTools.error((String)"Problem loading file. Try another one. Sorry :(.");
            return null;
        }
    }

    public ArrayList<ScriptObject> getScriptObjectsFromInputStream(InputStream inStream) {
        try {
            ScriptFileLoader loader = new ScriptFileLoader(inStream);
            ArrayList<ScriptObject> scriptObjects = loader.readIntoList();
            loader.close();
            return scriptObjects;
        }
        catch (IOException e) {
            System.err.println("Problem loading file. Try another one. Sorry :(.");
            return null;
        }
    }

    public ArrayList<ScriptObject> getScriptObjects() {
        File file = ScriptFileSelector.getScriptFileFromUserSelection(".xml");
        return this.getScriptObjects(file);
    }

    public ArrayList<ScriptObject> getScriptObjects(File file) {
        if (file != null) {
            this.lastScriptFileLoaded = file;
            return this.getScriptObjectsFromFile(file);
        }
        return null;
    }

    public ArrayList<ScriptObject> getScriptObjects(InputStream inStream) {
        if (inStream != null) {
            return this.getScriptObjectsFromInputStream(inStream);
        }
        return null;
    }

    public String getLastScriptFileLoaded() {
        return this.lastScriptFileLoaded.getName();
    }
}

