/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptEngineSettings;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileLoader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSaver;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSelector;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.avatar.scriptCommandGenerator.TextTool;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.interfaces.EpsilonComparable;

public class ScriptEditorInterface {
    public final JFrame jFrame;
    private final JTable table;
    private final JTable table2;
    private final DefaultTableModel model;
    private final DefaultTableModel model2;
    private JCheckBox table1check = new JCheckBox("table 1");
    private JCheckBox table2check = new JCheckBox("table 2");
    private JPanel outputArea1 = new JPanel();
    private JPanel outputArea2 = new JPanel();
    private JPanel outputXMLFile = new JPanel();
    private JPanel loadInfoArea = new JPanel();
    private final LoadScriptListener loadScriptListener = new LoadScriptListener();
    private final TextTool textTools = new TextTool();
    private final JTextField saveTableDataName;
    private final JTextField setDeltaTime;
    private final JTextField setEpsilon;
    private final JComboBox<String> scriptTypeSelector;
    private final JTextArea loadInfo;
    private final JLabel frameLabel;
    private final JTabbedPane tabbedPane;
    private long initialTimeOffsetNano;
    private final String loadInfoText;
    private final String loadInstructionText;
    private final String loadErrorText;
    private int loadCounter;
    private File scriptFile1;
    private JButton compareScripts;
    private JButton openXML;
    private final ArrayList<ScriptObject> deletedScripts = new ArrayList();
    private final ArrayList<Integer> deletedScriptsPos = new ArrayList();
    private final ArrayList<Long> deletedScriptsTime = new ArrayList();
    private final String[] scriptTypeSelectorString = new String[]{"Chest Orientation", "Foot Load Bearing", "Foot Pose", "Hand F Closed", "Hand Pose", "Hand Load Bearing", "Hand Opened", "Hand T&F Closed", "HeadOrientationPacket", "Pelvis Pose"};
    private ArrayList<ScriptObject> tableData = new ArrayList();
    private ArrayList<ScriptObject> tableData2 = new ArrayList();

    public static void main(String[] args) {
        new ScriptEditorInterface();
    }

    public ScriptEditorInterface() {
        Font font = new Font("Courier", 1, 12);
        this.loadCounter = 0;
        this.jFrame = new JFrame("Script Editor 2013 --- 2.0");
        JPanel buttonPanel = new JPanel();
        JPanel buttonPanelLeft = new JPanel();
        JPanel buttonPanelSave = new JPanel();
        JPanel buttonPanelEdit = new JPanel();
        buttonPanelLeft.setLayout(new BoxLayout(buttonPanelLeft, 1));
        this.saveTableDataName = new JTextField("enter unique name", 60);
        this.setDeltaTime = new JTextField(4);
        this.setEpsilon = new JTextField(4);
        this.setEpsilon.setText("0.05");
        this.loadInfo = new JTextArea(26, 60);
        this.loadInfo.setFont(font);
        this.loadInfo.setLineWrap(true);
        this.loadInfo.setBackground(new Color(214, 228, 225));
        this.loadInfo.setEditable(false);
        this.loadInfo.setBorder(BorderFactory.createMatteBorder(4, 2, 3, 3, new Color(140, 156, 154)));
        this.loadInfoText = " Scripts loaded in sequence: \n\n ";
        this.loadInstructionText = "Instructions: \n\n W = Move Object Up || S = Move Object Down \n\n C = Copy Object || Del = Delete Object \n\n F5 = Refresh Table || Z = Undo Delete row \n\n P = Copy Right to Left [Edit Scripts in Table 1] \n\n \n\n";
        this.loadErrorText = " ";
        this.loadInfo.append(this.loadInstructionText);
        this.loadInfo.append(this.loadInfoText);
        this.loadInfo.append(this.loadErrorText);
        this.loadInfo.setToolTipText("Info on the loaded scripts in sequence");
        this.tabbedPane = new JTabbedPane();
        buttonPanel.setBackground(new Color(214, 228, 225));
        buttonPanel.setBorder(BorderFactory.createMatteBorder(4, 2, 3, 3, new Color(140, 156, 154)));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.outputArea1.setBackground(new Color(140, 156, 154));
        this.outputArea2.setBackground(new Color(140, 156, 154));
        this.outputXMLFile.setBackground(new Color(140, 156, 154));
        this.outputArea1.setToolTipText("Table 1");
        this.outputArea2.setToolTipText("Table 2");
        this.outputXMLFile.setToolTipText("Edit File");
        this.outputXMLFile.setBackground(new Color(140, 156, 154));
        this.outputXMLFile.add(this.textTools);
        this.jFrame.getContentPane().add("South", buttonPanel);
        this.jFrame.getContentPane().add("Center", this.loadInfoArea);
        this.jFrame.getContentPane().add("West", this.outputArea1);
        this.jFrame.getContentPane().add("East", this.outputArea2);
        this.table1check.setToolTipText("Check to load to table 1");
        this.table1check.addActionListener(new checkListener());
        this.table2check.setToolTipText("Check to load to table 2");
        this.table2check.addActionListener(new checkListener());
        JButton scriptLoad = new JButton("Load Script");
        scriptLoad.setToolTipText("Load a Script in the Script Editor. Multiple scripts can be loaded");
        scriptLoad.addActionListener(this.loadScriptListener);
        JButton clearTableData = new JButton("Clear Table");
        clearTableData.setToolTipText("Delete all the scripts in selected table");
        clearTableData.addActionListener(new DeleteTableListener());
        JButton clearTablesData = new JButton("Clear Both Tables");
        clearTablesData.setToolTipText("Delete all the scripts in both tables");
        clearTablesData.addActionListener(new DeleteAllTablesListener());
        JButton deleteSelectedRows = new JButton("Delete Selected");
        deleteSelectedRows.setToolTipText("Delete the selected row in the table (Delete/Backspace)");
        deleteSelectedRows.addActionListener(new DeleteSelectedRows());
        JButton saveTableData = new JButton("Save");
        saveTableData.setToolTipText("Save the current table data in to a script");
        saveTableData.addActionListener(new SaveTableListener());
        this.compareScripts = new JButton("Compare");
        this.compareScripts.setToolTipText("Compare the equivalence of two scripts");
        this.compareScripts.addActionListener(new CompareScripts());
        JButton deleteAllPauses = new JButton("Delete Pauses/ 0Footsteps");
        deleteAllPauses.setToolTipText("Delete all the pauses and 0 Footsteps at once in the whole table data");
        deleteAllPauses.addActionListener(new DeleteAllPauses());
        BasicArrowButton moveRowUp = new BasicArrowButton(1);
        moveRowUp.setBackground(Color.ORANGE);
        moveRowUp.setToolTipText("Move selected Row up (W)");
        moveRowUp.addActionListener(new MoveRowUp());
        BasicArrowButton moveRowDown = new BasicArrowButton(5);
        moveRowDown.setBackground(Color.ORANGE);
        moveRowDown.setToolTipText("Move selected Row down (S)");
        moveRowDown.addActionListener(new MoveRowDown());
        JButton setNewDeltaTimes = new JButton("Set delta time [s]");
        setNewDeltaTimes.setToolTipText("sets the delta time for all the chosen scriptObjects");
        setNewDeltaTimes.addActionListener(new SetNewDeltaTimes());
        JButton refreshTableData = new JButton("Refresh");
        refreshTableData.setToolTipText("refresh the TableData");
        refreshTableData.addActionListener(new RefreshTableData());
        this.openXML = new JButton("Show XML File");
        this.openXML.setToolTipText("Edit scripts right here");
        this.openXML.addActionListener(new OpenXML());
        this.scriptTypeSelector = new JComboBox<String>(this.scriptTypeSelectorString);
        this.frameLabel = new JLabel("No reference frame");
        this.frameLabel.setToolTipText("Shows the current reference frame of the loaded script. Only scripts with the same reference frame can be loaded");
        this.setDeltaTime.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fEvt) {
                JTextField tField = (JTextField)fEvt.getSource();
                tField.selectAll();
            }
        });
        this.saveTableDataName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fEvt) {
                JTextField tField = (JTextField)fEvt.getSource();
                tField.selectAll();
            }
        });
        this.model = new DefaultTableModel(new Object[]{"#", "ScriptObject", "DeltaTime [s]", "Time [s]"}, 0);
        this.table = new JTable(this.model);
        JTableHeader header = this.table.getTableHeader();
        header.setBackground(Color.LIGHT_GRAY);
        this.table.getColumn("ScriptObject").setPreferredWidth(390);
        this.table.getColumn("#").setPreferredWidth(50);
        this.table.getColumn("DeltaTime [s]").setPreferredWidth(115);
        this.table.getColumn("Time [s]").setPreferredWidth(100);
        JScrollPane pane = new JScrollPane(this.table);
        this.model2 = new DefaultTableModel(new Object[]{"#", "ScriptObject", "DeltaTime [s]", "Time [s]"}, 0);
        this.table2 = new JTable(this.model2);
        JTableHeader header2 = this.table2.getTableHeader();
        header2.setBackground(Color.LIGHT_GRAY);
        this.table2.getColumn("ScriptObject").setPreferredWidth(390);
        this.table2.getColumn("#").setPreferredWidth(50);
        this.table2.getColumn("DeltaTime [s]").setPreferredWidth(115);
        this.table2.getColumn("Time [s]").setPreferredWidth(100);
        JScrollPane pane2 = new JScrollPane(this.table2);
        this.table2.setAutoResizeMode(4);
        this.table2.getTableHeader().setReorderingAllowed(false);
        this.outputArea1.add(pane);
        this.outputArea2.add(pane2);
        this.loadInfoArea.add(this.loadInfo);
        buttonPanel.add(this.table1check);
        buttonPanel.add(this.table2check);
        buttonPanelSave.add(scriptLoad);
        buttonPanelSave.add(this.saveTableDataName);
        buttonPanelSave.add(this.frameLabel);
        buttonPanelSave.add(saveTableData);
        buttonPanelSave.add(this.setEpsilon);
        buttonPanelSave.add(this.compareScripts);
        buttonPanelSave.add(this.openXML);
        buttonPanelEdit.add(deleteSelectedRows);
        buttonPanelEdit.add(deleteAllPauses);
        buttonPanelEdit.add(this.scriptTypeSelector);
        buttonPanelEdit.add(this.setDeltaTime);
        buttonPanelEdit.add(setNewDeltaTimes);
        buttonPanelEdit.add(refreshTableData);
        buttonPanelEdit.add(clearTableData);
        buttonPanelEdit.add(clearTablesData);
        buttonPanel.add(this.tabbedPane);
        this.tabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=20 marginheight=1>File</body></html>", buttonPanelSave);
        this.tabbedPane.addTab("<html><body leftmargin=15 topmargin=8 marginwidth=20 marginheight=1>Edit Script</body></html>", buttonPanelEdit);
        buttonPanelLeft.setSize(200, 200);
        buttonPanelLeft.add((Component)moveRowUp, "East");
        buttonPanelLeft.add((Component)moveRowDown, "East");
        pane.setVisible(true);
        this.jFrame.setSize(1390, 534);
        this.jFrame.setResizable(false);
        this.jFrame.setLocationRelativeTo(null);
        this.jFrame.setUndecorated(true);
        this.jFrame.getRootPane().setWindowDecorationStyle(2);
        this.jFrame.setDefaultCloseOperation(3);
        this.jFrame.setVisible(true);
        InputMap inputMap = this.table.getInputMap(0);
        InputMap inputMap2 = this.table2.getInputMap(0);
        InputMap im2 = this.table2.getInputMap();
        InputMap im = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        ActionMap actionMap2 = this.table2.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "DeleteRow");
        inputMap2.put(KeyStroke.getKeyStroke(127, 0), "DeleteRow");
        actionMap.put("DeleteRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIndex = ScriptEditorInterface.this.table.getSelectedRows();
                int counter = 0;
                for (int i = 0; i < rowIndex.length; ++i) {
                    ScriptEditorInterface.this.deleteSelectedRows(rowIndex[i] - counter);
                    ++counter;
                }
                ScriptEditorInterface.this.table.getSelectionModel().setSelectionInterval(rowIndex[0] - 1, rowIndex[0] - 1);
                ScriptEditorInterface.this.table.scrollRectToVisible(new Rectangle(ScriptEditorInterface.this.table.getCellRect(rowIndex[0] + 1, 0, true)));
                if (rowIndex[0] == 0) {
                    ScriptEditorInterface.this.table.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(90, 0), "UndoDeleteRow");
        actionMap.put("UndoDeleteRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.undoDeleteSelectedRows();
            }
        });
        im.put(KeyStroke.getKeyStroke(87, 0), "MoveRowUp");
        actionMap.put("MoveRowUp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.moveRowUp();
            }
        });
        im.put(KeyStroke.getKeyStroke(83, 0), "MoveRowDown");
        actionMap.put("MoveRowDown", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.moveRowDown();
            }
        });
        im.put(KeyStroke.getKeyStroke(67, 0), "CopyRow");
        actionMap.put("CopyRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.copyRow();
            }
        });
        im2.put(KeyStroke.getKeyStroke(80, 0), "CopyRowOver");
        actionMap2.put("CopyRowOver", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.copyRowOver();
            }
        });
        im.put(KeyStroke.getKeyStroke(116, 0), "refreshTableData");
        actionMap.put("refreshTableData", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditorInterface.this.refreshTableData();
            }
        });
    }

    private double checkWhichBox(JCheckBox table1check, JCheckBox table2check) {
        if (table1check.isSelected() && table2check.isSelected()) {
            this.outputArea1.setBackground(new Color(163, 30, 57));
            this.outputArea2.setBackground(new Color(163, 30, 57));
            return 3.0;
        }
        if (table1check.isSelected()) {
            this.outputArea1.setBackground(new Color(163, 30, 57));
            this.outputArea2.setBackground(new Color(140, 156, 154));
            return 1.0;
        }
        if (table2check.isSelected()) {
            this.outputArea2.setBackground(new Color(163, 30, 57));
            this.outputArea1.setBackground(new Color(140, 156, 154));
            return 2.0;
        }
        this.outputArea1.setBackground(new Color(140, 156, 154));
        this.outputArea2.setBackground(new Color(140, 156, 154));
        return 0.0;
    }

    private void setTimeStampsFromDeltaTimes() {
        long currentTimeStampNano = this.initialTimeOffsetNano;
        for (int i = 0; i < this.tableData.size(); ++i) {
            this.tableData.get(i).setTimeStamp(currentTimeStampNano);
            double deltaT = 0.0;
            Object dtToCast = this.table.getValueAt(i, 2);
            if (dtToCast instanceof String) {
                deltaT = Double.parseDouble((String)dtToCast);
            } else if (dtToCast instanceof Double) {
                deltaT = (Double)dtToCast;
            }
            currentTimeStampNano += Conversions.secondsToNanoseconds((double)deltaT);
        }
    }

    public void deleteSelectedRows(int rowIndex) {
        long timeDelta = 0L;
        if (rowIndex == this.table.getRowCount() - 1) {
            return;
        }
        timeDelta = Conversions.secondsToNanoseconds((double)Double.parseDouble(this.model.getValueAt(rowIndex, 2).toString()));
        this.deletedScripts.add(this.tableData.get(rowIndex));
        this.deletedScriptsPos.add(rowIndex);
        this.deletedScriptsTime.add(timeDelta);
        this.tableData.remove(rowIndex);
        this.loadScriptListener.removeRow(rowIndex);
        this.setTimeStamp(rowIndex, timeDelta, false);
        this.loadScriptListener.setData(this.tableData);
        if (this.tableData.size() == 0) {
            this.frameLabel.setText("No reference frame");
        }
    }

    public void moveRowUp() {
        int[] selectedRow = this.table.getSelectedRows();
        if (selectedRow.length > 0 && selectedRow[selectedRow.length - 1] != 0 && selectedRow[selectedRow.length - 1] != this.tableData.size() - 1 && selectedRow.length <= 1) {
            this.model.moveRow(selectedRow[0], selectedRow[selectedRow.length - 1], selectedRow[0] - 1);
            this.table.setRowSelectionInterval(selectedRow[0] - 1, selectedRow[0] - 1);
            this.table.getSelectionModel().setSelectionInterval(selectedRow[0] - 1, selectedRow[0] - 1);
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(selectedRow[0] - 1, 0, true)));
            ScriptObject toMove = this.tableData.get(selectedRow[0]);
            this.tableData.set(selectedRow[0], this.tableData.get(selectedRow[0] - 1));
            this.tableData.set(selectedRow[0] - 1, toMove);
        }
    }

    public void moveRowDown() {
        int[] selectedRow = this.table.getSelectedRows();
        if (this.checkWhichBox(this.table1check, this.table2check) > 1.0) {
            // empty if block
        }
        if (selectedRow.length > 0 && selectedRow[selectedRow.length - 1] < this.tableData.size() - 2 && selectedRow.length <= 1) {
            this.model.moveRow(selectedRow[0], selectedRow[selectedRow.length - 1], selectedRow[0] + 1);
            this.table.setRowSelectionInterval(selectedRow[0] + 1, selectedRow[0] + 1);
            this.table.getSelectionModel().setSelectionInterval(selectedRow[0] + 1, selectedRow[0] + 1);
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(selectedRow[0] + 1, 0, true)));
            ScriptObject toMove = this.tableData.get(selectedRow[0]);
            this.tableData.set(selectedRow[0], this.tableData.get(selectedRow[0] + 1));
            this.tableData.set(selectedRow[0] + 1, toMove);
        }
    }

    public void compareScripts() {
        double epsilon = Double.parseDouble(this.setEpsilon.getText());
        int counter = 0;
        if (this.tableData.size() != this.tableData2.size()) {
            boolean equals = false;
            ++counter;
        } else {
            for (int i = 0; i < this.tableData.size() - 1; ++i) {
                boolean equals;
                Object tableDataObject1 = this.tableData.get(i).getScriptObject();
                Object tableDataObject2 = this.tableData2.get(i).getScriptObject();
                if (tableDataObject1 instanceof EpsilonComparable) {
                    equals = ((EpsilonComparable)tableDataObject1).epsilonEquals(tableDataObject2, epsilon);
                    if (equals) continue;
                    ++counter;
                    System.out.println(i + " " + String.valueOf(tableDataObject1) + " is outside epsilon of:  " + epsilon + "\n");
                    continue;
                }
                equals = tableDataObject1.equals(tableDataObject2);
                if (equals) continue;
                ++counter;
                this.compareScripts.setBackground(Color.RED);
                this.loadInfo.append(i + " " + String.valueOf(tableDataObject1) + " is outside epsilon of:  " + epsilon + "\n");
            }
        }
        if (counter >= 1) {
            this.compareScripts.setBackground(Color.RED);
        } else {
            this.compareScripts.setBackground(Color.GREEN);
        }
    }

    public void copyRow() {
        int[] selectedRow = this.table.getSelectedRows();
        if (selectedRow.length > 0) {
            long timeDelta = Conversions.secondsToNanoseconds((double)Double.parseDouble(this.model.getValueAt(selectedRow[0], 2).toString()));
            ScriptObject selectedRowinTable = this.tableData.get(selectedRow[0]);
            ScriptObject cloneObject = new ScriptObject(selectedRowinTable.getTimeStamp() + timeDelta, selectedRowinTable.getScriptObject());
            this.tableData.add(selectedRow[0] + 1, cloneObject);
            for (int i = selectedRow[0] + 2; i < this.tableData.size(); ++i) {
                long time = this.tableData.get(i).getTimeStamp();
                this.tableData.get(i).setTimeStamp(time + timeDelta);
            }
            this.loadScriptListener.setData(this.tableData);
            this.refreshTableData();
            this.table.getSelectionModel().setSelectionInterval(selectedRow[0] + 1, selectedRow[0] + 1);
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(selectedRow[0] + 1, 0, true)));
        }
    }

    public void copyRowOver() {
        int[] selectedRow = this.table2.getSelectedRows();
        long setTimeForCopy = 0L;
        if (selectedRow.length > 0) {
            if (selectedRow[0] == this.tableData2.size() - 1) {
                return;
            }
            long timeDeltaToCopy = Conversions.secondsToNanoseconds((double)Double.parseDouble(this.model2.getValueAt(selectedRow[0], 2).toString()));
            if (selectedRow[0] == 0) {
                setTimeForCopy = this.tableData2.get(selectedRow[0]).getTimeStamp();
            } else {
                long timeDelta = Conversions.secondsToNanoseconds((double)Double.parseDouble(this.model.getValueAt(selectedRow[0] - 1, 2).toString()));
                setTimeForCopy = this.tableData.get(selectedRow[0] - 1).getTimeStamp() + timeDelta;
            }
            ScriptObject selectedRowinTable = this.tableData2.get(selectedRow[0]);
            ScriptObject cloneObject = new ScriptObject(setTimeForCopy, selectedRowinTable.getScriptObject());
            this.tableData.add(selectedRow[0], cloneObject);
            for (int i = selectedRow[0] + 1; i < this.tableData.size(); ++i) {
                long time = this.tableData.get(i).getTimeStamp();
                this.tableData.get(i).setTimeStamp(time + timeDeltaToCopy);
            }
            this.loadScriptListener.setData(this.tableData);
            this.refreshTableData();
            this.table.getSelectionModel().setSelectionInterval(selectedRow[0] + 1, selectedRow[0] + 1);
            this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(selectedRow[0] + 1, 0, true)));
        }
    }

    public void refreshTableData() {
        this.setTimeStampsFromDeltaTimes();
        this.loadScriptListener.setData(this.tableData);
    }

    public void openXML() {
        if (this.outputArea2.isVisible()) {
            this.jFrame.getContentPane().add(this.outputXMLFile);
            this.outputXMLFile.setVisible(true);
            this.outputArea2.setVisible(false);
            this.loadInfoArea.setVisible(false);
            this.openXML.setText("Hide XML File");
        } else {
            this.jFrame.getContentPane().remove(this.outputXMLFile);
            this.outputArea2.setVisible(true);
            this.loadInfoArea.setVisible(true);
            this.openXML.setText("Show XML File");
        }
    }

    public void deleteAllTables() {
        this.model.setNumRows(0);
        this.model2.setNumRows(0);
        this.tableData.clear();
        this.tableData2.clear();
        this.frameLabel.setText("No reference frame");
        this.loadInfo.setText(this.loadInstructionText);
        this.loadInfo.append(this.loadInfoText);
        this.loadCounter = 0;
        this.deletedScripts.clear();
        this.deletedScriptsPos.clear();
        this.deletedScriptsTime.clear();
    }

    public void deleteAll() {
        DefaultTableModel whichModel = this.model;
        ArrayList<ScriptObject> whichTableData = this.tableData;
        if (this.checkWhichBox(this.table1check, this.table2check) != 3.0 && this.checkWhichBox(this.table1check, this.table2check) != 0.0) {
            if (this.checkWhichBox(this.table1check, this.table2check) == 1.0) {
                // empty if block
            }
            if (this.checkWhichBox(this.table1check, this.table2check) == 2.0) {
                whichModel = this.model2;
                whichTableData = this.tableData2;
            }
            whichModel.setNumRows(0);
            whichTableData.clear();
            this.frameLabel.setText("No reference frame");
            this.loadInfo.setText(this.loadInstructionText);
            this.loadInfo.append(this.loadInfoText);
            this.loadCounter = 0;
        } else if (this.checkWhichBox(this.table1check, this.table2check) != 0.0) {
            this.model.setNumRows(0);
            this.model2.setNumRows(0);
            this.tableData.clear();
            this.tableData2.clear();
            this.frameLabel.setText("No reference frame");
            this.loadInfo.setText(this.loadInstructionText);
            this.loadInfo.append(this.loadInfoText);
            this.loadCounter = 0;
        }
    }

    public void undoDeleteSelectedRows() {
        if (this.deletedScripts.size() == 0) {
            return;
        }
        int lastPos = this.deletedScriptsPos.size() - 1;
        int lastScript = this.deletedScripts.size() - 1;
        int lastTime = this.deletedScriptsTime.size() - 1;
        int[] rowIndex = new int[]{this.deletedScriptsPos.get(lastPos) + 1};
        this.tableData.add(this.deletedScriptsPos.get(lastPos), this.deletedScripts.get(lastScript));
        for (int i = 0; i < rowIndex.length; ++i) {
            this.setTimeStamp(rowIndex[i], this.deletedScriptsTime.get(lastTime), true);
        }
        this.loadScriptListener.setData(this.tableData);
        this.refreshTableData();
        this.table.getSelectionModel().setSelectionInterval(this.deletedScriptsPos.get(lastPos), this.deletedScriptsPos.get(lastPos));
        this.deletedScripts.remove(lastScript);
        this.deletedScriptsPos.remove(lastPos);
        this.deletedScriptsTime.remove(lastTime);
    }

    public void setTimeStamp(int rowIndex, long timeDelta, boolean plus) {
        if (plus) {
            timeDelta *= -1L;
        }
        for (int i = rowIndex; i < this.tableData.size(); ++i) {
            long time = this.tableData.get(i).getTimeStamp();
            this.tableData.get(i).setTimeStamp(time - timeDelta);
        }
    }

    private class LoadScriptListener
    implements ActionListener {
        private ArrayList<ScriptObject> script;
        private File scriptFile;

        private LoadScriptListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 0.0) {
                ScriptEditorInterface.this.loadInfo.append("                  NO TABLE SELECTED!            ");
            }
            if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) > 0.0) {
                ++ScriptEditorInterface.this.loadCounter;
                this.scriptFile = ScriptFileSelector.getScriptFileFromUserSelection(".xml");
                if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 1.0) {
                    ScriptEditorInterface.this.loadInfo.append(ScriptEditorInterface.this.loadCounter + ") Table 1:  " + this.scriptFile.getName() + "\n\n");
                    ScriptEditorInterface.this.scriptFile1 = this.scriptFile;
                }
                if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 2.0) {
                    ScriptEditorInterface.this.loadInfo.append(ScriptEditorInterface.this.loadCounter + ") Table 2:  " + this.scriptFile.getName() + "\n\n");
                }
                if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 3.0) {
                    ScriptEditorInterface.this.loadInfo.append(ScriptEditorInterface.this.loadCounter + ") Table 1 & 2:  " + this.scriptFile.getName() + "\n\n");
                    ScriptEditorInterface.this.scriptFile1 = this.scriptFile;
                }
                try {
                    ScriptFileLoader loader = new ScriptFileLoader(this.scriptFile);
                    this.script = loader.readIntoList();
                    loader.close();
                    this.appendData(this.script);
                    if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 1.0) {
                        if (ScriptEditorInterface.this.tableData.size() > 1) {
                            ScriptEditorInterface.this.tableData.remove(ScriptEditorInterface.this.tableData.size() - 1);
                        }
                        ScriptEditorInterface.this.tableData.addAll(this.script);
                    }
                    if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 2.0) {
                        if (ScriptEditorInterface.this.tableData2.size() > 1) {
                            ScriptEditorInterface.this.tableData2.remove(ScriptEditorInterface.this.tableData2.size() - 1);
                        }
                        ScriptEditorInterface.this.tableData2.addAll(this.script);
                    }
                    if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 3.0) {
                        if (ScriptEditorInterface.this.tableData.size() > 1) {
                            ScriptEditorInterface.this.tableData.remove(ScriptEditorInterface.this.tableData.size() - 1);
                        }
                        ScriptEditorInterface.this.tableData.addAll(this.script);
                        if (ScriptEditorInterface.this.tableData2.size() > 1) {
                            ScriptEditorInterface.this.tableData2.remove(ScriptEditorInterface.this.tableData2.size() - 1);
                        }
                        ScriptEditorInterface.this.tableData2.addAll(this.script);
                    }
                    ScriptEditorInterface.this.table1check.setSelected(false);
                    ScriptEditorInterface.this.outputArea2.setBackground(new Color(140, 156, 154));
                    ScriptEditorInterface.this.table2check.setSelected(false);
                    ScriptEditorInterface.this.outputArea1.setBackground(new Color(140, 156, 154));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ScriptEditorInterface.this.textTools.openTableData(ScriptEditorInterface.this.scriptFile1.getAbsolutePath());
        }

        public void appendData(ArrayList<ScriptObject> tableData) {
            double deltaT;
            double time;
            ScriptObject scriptObject;
            int i;
            DefaultTableModel whichModel = ScriptEditorInterface.this.model;
            if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) != 1.0) {
                if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 2.0) {
                    whichModel = ScriptEditorInterface.this.model2;
                } else if (ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check) == 3.0) {
                    if (ScriptEditorInterface.this.model2.getRowCount() > 0) {
                        ScriptEditorInterface.this.model2.setRowCount(ScriptEditorInterface.this.model2.getRowCount() - 1);
                    }
                    if (ScriptEditorInterface.this.model2.getRowCount() == 0) {
                        ScriptEditorInterface.this.initialTimeOffsetNano = tableData.get(0).getTimeStamp();
                    }
                    int rowOffset = ScriptEditorInterface.this.model2.getRowCount();
                    for (i = 0; i < tableData.size(); ++i) {
                        scriptObject = tableData.get(i);
                        time = Conversions.nanosecondsToSeconds((long)tableData.get(i).getTimeStamp());
                        deltaT = i == tableData.size() - 1 ? 0.0 : Conversions.nanosecondsToSeconds((long)(tableData.get(i + 1).getTimeStamp() - tableData.get(i).getTimeStamp()));
                        ScriptEditorInterface.this.model2.addRow(new Object[]{rowOffset + i + 1, scriptObject.toString(), deltaT, time});
                    }
                }
            }
            if (whichModel.getRowCount() > 0) {
                whichModel.setRowCount(whichModel.getRowCount() - 1);
            }
            if (whichModel.getRowCount() == 0) {
                ScriptEditorInterface.this.initialTimeOffsetNano = tableData.get(0).getTimeStamp();
            }
            int rowOffset1 = whichModel.getRowCount();
            for (i = 0; i < tableData.size(); ++i) {
                scriptObject = tableData.get(i);
                time = Conversions.nanosecondsToSeconds((long)tableData.get(i).getTimeStamp());
                deltaT = i == tableData.size() - 1 ? 0.0 : Conversions.nanosecondsToSeconds((long)(tableData.get(i + 1).getTimeStamp() - tableData.get(i).getTimeStamp()));
                whichModel.addRow(new Object[]{rowOffset1 + i + 1, scriptObject.toString(), deltaT, time});
            }
        }

        public void setData(ArrayList<ScriptObject> tableData) {
            ScriptEditorInterface.this.model.setRowCount(0);
            if (tableData.size() != 0) {
                ScriptEditorInterface.this.initialTimeOffsetNano = tableData.get(0).getTimeStamp();
                this.appendData(tableData);
            }
        }

        public void removeRow(int row) {
            ScriptEditorInterface.this.model.removeRow(row);
        }
    }

    private class checkListener
    implements ActionListener {
        private checkListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.checkWhichBox(ScriptEditorInterface.this.table1check, ScriptEditorInterface.this.table2check);
        }
    }

    private class DeleteTableListener
    implements ActionListener {
        private DeleteTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.deleteAll();
        }
    }

    private class DeleteAllTablesListener
    implements ActionListener {
        private DeleteAllTablesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.deleteAllTables();
        }
    }

    private class DeleteSelectedRows
    implements ActionListener {
        private DeleteSelectedRows() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int[] rowIndex = ScriptEditorInterface.this.table.getSelectedRows();
            int counter = 0;
            for (int i = 0; i < rowIndex.length; ++i) {
                ScriptEditorInterface.this.deleteSelectedRows(rowIndex[i] - counter);
                ++counter;
            }
            ScriptEditorInterface.this.table.getSelectionModel().setSelectionInterval(rowIndex[0] - 1, rowIndex[0] - 1);
            ScriptEditorInterface.this.table.scrollRectToVisible(new Rectangle(ScriptEditorInterface.this.table.getCellRect(rowIndex[0] + 1, 0, true)));
            if (rowIndex[0] == 0) {
                ScriptEditorInterface.this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    private class SaveTableListener
    implements ActionListener {
        private SaveTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.setTimeStampsFromDeltaTimes();
            Path saveFilePath = Paths.get(ScriptEngineSettings.scriptSavingDirectory, ScriptEditorInterface.this.saveTableDataName.getText() + ".xml");
            try {
                ScriptFileSaver scriptFileSaver = new ScriptFileSaver(saveFilePath, false);
                scriptFileSaver.recordList(ScriptEditorInterface.this.tableData);
                scriptFileSaver.close();
                ScriptEditorInterface.this.saveTableDataName.setText("Save succesfull!");
                ScriptEditorInterface.this.loadInfo.setText(ScriptEditorInterface.this.loadInfoText);
                ScriptEditorInterface.this.loadInfo.append("Table 1's Script saved in: \n" + String.valueOf(saveFilePath) + "\n");
                ArrayList<ScriptObject> temp = ScriptEditorInterface.this.tableData;
                ScriptEditorInterface.this.model.setRowCount(0);
                ScriptEditorInterface.this.loadScriptListener.setData(temp);
            }
            catch (IOException e) {
                e.printStackTrace();
                ScriptEditorInterface.this.saveTableDataName.setText("Unable to save!");
            }
        }
    }

    private class CompareScripts
    implements ActionListener {
        private CompareScripts() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.compareScripts();
        }
    }

    private class DeleteAllPauses
    implements ActionListener {
        private DeleteAllPauses() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            for (i = 0; i < ScriptEditorInterface.this.tableData.size(); ++i) {
                if (!ScriptEditorInterface.this.model.getValueAt(i, 1).toString().equals("Paused = true") && !ScriptEditorInterface.this.model.getValueAt(i, 1).toString().equals("0 Footsteps")) continue;
                ScriptEditorInterface.this.model.removeRow(i);
                ScriptEditorInterface.this.tableData.remove(i);
                --i;
            }
            for (i = 0; i < ScriptEditorInterface.this.tableData.size(); ++i) {
                if (!ScriptEditorInterface.this.model2.getValueAt(i, 1).toString().equals("Paused = true") && !ScriptEditorInterface.this.model2.getValueAt(i, 1).toString().equals("0 Footsteps")) continue;
                ScriptEditorInterface.this.model2.removeRow(i);
                ScriptEditorInterface.this.tableData2.remove(i);
                --i;
            }
            ScriptEditorInterface.this.refreshTableData();
        }
    }

    private class MoveRowUp
    implements ActionListener {
        private MoveRowUp() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.moveRowUp();
        }
    }

    private class MoveRowDown
    implements ActionListener {
        private MoveRowDown() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.moveRowDown();
        }
    }

    private class SetNewDeltaTimes
    implements ActionListener {
        private SetNewDeltaTimes() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int selected = ScriptEditorInterface.this.scriptTypeSelector.getSelectedIndex();
            for (int i = 0; i < ScriptEditorInterface.this.tableData.size(); ++i) {
                if (!ScriptEditorInterface.this.tableData.get(i).getScriptObject().toString().contains(ScriptEditorInterface.this.scriptTypeSelectorString[selected])) continue;
                long time = ScriptEditorInterface.this.tableData.get(i).getTimeStamp();
                double deltaTimeDes = Double.parseDouble(ScriptEditorInterface.this.setDeltaTime.getText()) * 1.0E9;
                long deltaTimeDesired = (long)deltaTimeDes;
                ScriptEditorInterface.this.tableData.get(i + 1).setTimeStamp(time + deltaTimeDesired);
                for (int j = i + 2; j < ScriptEditorInterface.this.tableData.size(); ++j) {
                    long deltaTime = Conversions.secondsToNanoseconds((double)Double.parseDouble(ScriptEditorInterface.this.model.getValueAt(j - 1, 2).toString()));
                    ScriptEditorInterface.this.tableData.get(j).setTimeStamp(ScriptEditorInterface.this.tableData.get(j - 1).getTimeStamp() + deltaTime);
                }
                ScriptEditorInterface.this.loadScriptListener.setData(ScriptEditorInterface.this.tableData);
            }
        }
    }

    private class RefreshTableData
    implements ActionListener {
        private RefreshTableData() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.refreshTableData();
        }
    }

    private class OpenXML
    implements ActionListener {
        private OpenXML() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ScriptEditorInterface.this.openXML();
        }
    }
}

