/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.HandTrajectoryMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import controller_msgs.msg.dds.PelvisHeightTrajectoryMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileLoader;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PauseWalkingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;

public class ScriptBasedControllerCommandGenerator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ConcurrentLinkedQueue<ScriptObject> scriptObjects = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Command<?, ?>> controllerCommands;
    private final FullHumanoidRobotModel fullRobotModel;
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver();

    public ScriptBasedControllerCommandGenerator(ConcurrentLinkedQueue<Command<?, ?>> controllerCommands, FullHumanoidRobotModel fullRobotModel) {
        this.controllerCommands = controllerCommands;
        this.fullRobotModel = fullRobotModel;
        this.referenceFrameHashCodeResolver.putAllFullRobotModelReferenceFrames((FullRobotModel)fullRobotModel);
    }

    public void loadScriptFile(Path scriptFilePath, ReferenceFrame referenceFrame) {
        try {
            ScriptFileLoader scriptFileLoader = new ScriptFileLoader(scriptFilePath);
            RigidBodyTransform transformFromReferenceFrameToWorldFrame = referenceFrame.getTransformToDesiredFrame(worldFrame);
            ArrayList<ScriptObject> scriptObjectsList = scriptFileLoader.readIntoList(transformFromReferenceFrameToWorldFrame);
            this.scriptObjects.addAll(scriptObjectsList);
            this.convertFromScriptObjectsToControllerCommands();
        }
        catch (IOException e) {
            System.err.println("Could not load script file " + String.valueOf(scriptFilePath));
        }
    }

    public void loadScriptFile(InputStream scriptInputStream, ReferenceFrame referenceFrame) {
        try {
            ScriptFileLoader scriptFileLoader = new ScriptFileLoader(scriptInputStream);
            RigidBodyTransform transformFromReferenceFrameToWorldFrame = referenceFrame.getTransformToDesiredFrame(worldFrame);
            ArrayList<ScriptObject> scriptObjectsList = scriptFileLoader.readIntoList(transformFromReferenceFrameToWorldFrame);
            this.scriptObjects.addAll(scriptObjectsList);
            this.convertFromScriptObjectsToControllerCommands();
        }
        catch (IOException e) {
            System.err.println("Could not load script file " + String.valueOf(scriptInputStream));
        }
    }

    private void convertFromScriptObjectsToControllerCommands() {
        while (!this.scriptObjects.isEmpty()) {
            FootstepDataListCommand command;
            FootstepDataListMessage message;
            ScriptObject nextObject = this.scriptObjects.poll();
            Object scriptObject = nextObject.getScriptObject();
            if (scriptObject instanceof FootstepDataListMessage) {
                message = (FootstepDataListMessage)scriptObject;
                command = new FootstepDataListCommand();
                command.setFromMessage(message);
                this.controllerCommands.add((Command<?, ?>)command);
                continue;
            }
            if (scriptObject instanceof FootTrajectoryMessage) {
                message = (FootTrajectoryMessage)scriptObject;
                message.getSe3Trajectory().getFrameInformation().setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)worldFrame));
                message.getSe3Trajectory().getFrameInformation().setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)worldFrame));
                command = new FootTrajectoryCommand();
                command.getSE3Trajectory().set(this.referenceFrameHashCodeResolver, message.getSe3Trajectory());
                this.controllerCommands.add((Command<?, ?>)command);
                continue;
            }
            if (scriptObject instanceof HandTrajectoryMessage) {
                MovingReferenceFrame chestFrame = this.fullRobotModel.getChest().getBodyFixedFrame();
                HandTrajectoryMessage message2 = (HandTrajectoryMessage)scriptObject;
                message2.getSe3Trajectory().getFrameInformation().setTrajectoryReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)chestFrame));
                message2.getSe3Trajectory().getFrameInformation().setDataReferenceFrameId(MessageTools.toFrameId((ReferenceFrame)worldFrame));
                HandTrajectoryCommand command2 = new HandTrajectoryCommand();
                command2.getSE3Trajectory().set(this.referenceFrameHashCodeResolver, message2.getSe3Trajectory());
                this.controllerCommands.add((Command<?, ?>)command2);
                continue;
            }
            if (scriptObject instanceof PelvisHeightTrajectoryMessage) {
                message = (PelvisHeightTrajectoryMessage)scriptObject;
                command = new PelvisHeightTrajectoryCommand();
                command.setFromMessage((PelvisHeightTrajectoryMessage)message);
                this.controllerCommands.add((Command<?, ?>)command);
                continue;
            }
            if (scriptObject instanceof PauseWalkingMessage) {
                message = (PauseWalkingMessage)scriptObject;
                command = new PauseWalkingCommand();
                command.setFromMessage((PauseWalkingMessage)message);
                this.controllerCommands.add((Command<?, ?>)command);
                continue;
            }
            System.err.println("ScriptBasedControllerCommandGenerator: Didn't process script object " + String.valueOf(nextObject));
        }
    }
}

