/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.WrenchTrajectoryMessage;
import geometry_msgs.msg.dds.Wrench;
import ihmc_common_msgs.msg.dds.EuclideanTrajectoryMessage;
import ihmc_common_msgs.msg.dds.SE3TrajectoryMessage;
import ihmc_common_msgs.msg.dds.SO3TrajectoryMessage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.commons.lists.PreallocatedList;
import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;

public final class MessageTransformer {
    private static final Map<Class, CustomTransformer> customTransformers = MessageTransformer.createCustomTransformers();

    private MessageTransformer() {
    }

    public static void transform(Object message, RigidBodyTransform rigidBodyTransformToApply) {
        if (message == null || MessageTransformer.isPrimitive(message.getClass())) {
            return;
        }
        if (customTransformers.containsKey(message.getClass())) {
            customTransformers.get(message.getClass()).transform(message, rigidBodyTransformToApply);
        } else if (message instanceof PreallocatedList) {
            PreallocatedList list = (PreallocatedList)message;
            for (int i = 0; i < list.size(); ++i) {
                MessageTransformer.transform(list.get(i), rigidBodyTransformToApply);
            }
        } else if (message instanceof Iterable) {
            for (Object element : (Iterable)message) {
                MessageTransformer.transform(element, rigidBodyTransformToApply);
            }
        } else if (message.getClass().isArray()) {
            for (Object element : (Object[])message) {
                MessageTransformer.transform(element, rigidBodyTransformToApply);
            }
        } else {
            Field[] fields;
            if (message instanceof Transformable) {
                ((Transformable)message).applyTransform((Transform)rigidBodyTransformToApply);
                return;
            }
            if (Enum.class.isAssignableFrom(message.getClass())) {
                return;
            }
            for (Field field : fields = message.getClass().getFields()) {
                try {
                    MessageTransformer.transform(field.get(message), rigidBodyTransformToApply);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    private static Map<Class, CustomTransformer> createCustomTransformers() {
        HashMap<Class, CustomTransformer> customTransformers = new HashMap<Class, CustomTransformer>();
        customTransformers.put(FootstepDataMessage.class, new CustomTransformer<FootstepDataMessage>(){

            @Override
            public void transform(FootstepDataMessage message, RigidBodyTransform rigidBodyTransformToApply) {
                if (message.getLocation() != null) {
                    message.getLocation().applyTransform((Transform)rigidBodyTransformToApply);
                }
                if (message.getOrientation() != null) {
                    message.getOrientation().applyTransform((Transform)rigidBodyTransformToApply);
                }
                if (message.getCustomPositionWaypoints() != null) {
                    for (int i = 0; i < message.getCustomPositionWaypoints().size(); ++i) {
                        ((Point3D)message.getCustomPositionWaypoints().get(i)).applyTransform((Transform)rigidBodyTransformToApply);
                    }
                }
            }
        });
        customTransformers.put(SE3TrajectoryMessage.class, new CustomTransformer<SE3TrajectoryMessage>(){

            @Override
            public void transform(SE3TrajectoryMessage object, RigidBodyTransform rigidBodyTransformToApply) {
                MessageTransformer.transform(object.getTaskspaceTrajectoryPoints(), rigidBodyTransformToApply);
            }
        });
        customTransformers.put(SO3TrajectoryMessage.class, new CustomTransformer<SO3TrajectoryMessage>(){

            @Override
            public void transform(SO3TrajectoryMessage object, RigidBodyTransform rigidBodyTransformToApply) {
                MessageTransformer.transform(object.getTaskspaceTrajectoryPoints(), rigidBodyTransformToApply);
            }
        });
        customTransformers.put(EuclideanTrajectoryMessage.class, new CustomTransformer<EuclideanTrajectoryMessage>(){

            @Override
            public void transform(EuclideanTrajectoryMessage object, RigidBodyTransform rigidBodyTransformToApply) {
                MessageTransformer.transform(object.getTaskspaceTrajectoryPoints(), rigidBodyTransformToApply);
            }
        });
        customTransformers.put(WrenchTrajectoryMessage.class, new CustomTransformer<WrenchTrajectoryMessage>(){

            @Override
            public void transform(WrenchTrajectoryMessage object, RigidBodyTransform rigidBodyTransformToApply) {
                MessageTransformer.transform(object.getWrenchTrajectoryPoints(), rigidBodyTransformToApply);
            }
        });
        customTransformers.put(Wrench.class, new CustomTransformer<Wrench>(){

            @Override
            public void transform(Wrench object, RigidBodyTransform rigidBodyTransformToApply) {
                object.getForce().applyTransform((Transform)rigidBodyTransformToApply);
                object.getTorque().applyTransform((Transform)rigidBodyTransformToApply);
            }
        });
        return customTransformers;
    }

    private static boolean isPrimitive(Class<?> clazz) {
        if (clazz.equals(Boolean.TYPE) || clazz.equals(boolean[].class) || clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(byte[].class) || clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(char[].class) || clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(short[].class) || clazz.equals(Short.class)) {
            return true;
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(int[].class) || clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(long[].class) || clazz.equals(Long.class)) {
            return true;
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(float[].class) || clazz.equals(Float.class)) {
            return true;
        }
        return clazz.equals(Double.TYPE) || clazz.equals(double[].class) || clazz.equals(Double.class);
    }

    private static interface CustomTransformer<T> {
        public void transform(T var1, RigidBodyTransform var2);
    }
}

