/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.scriptCommandGenerator;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import us.ihmc.avatar.scriptCommandGenerator.ScriptFileSaver;
import us.ihmc.avatar.scriptCommandGenerator.ScriptObject;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.walking.EndOfScriptCommand;
import us.ihmc.robotics.robotSide.RobotSide;

public class CreateFootstepScript {
    private static final double desiredSwingTime = 0.6;
    private static final double desiredTransferTime = 0.0;
    private static final double stepLength = 0.3;
    private static final double stepWidth = 0.3;
    private ContactType[] contactSequence = new ContactType[]{ContactType.LINE_SIDE_SIDE, ContactType.LINE_FRONT_BACK};
    private static final double footLength = 0.22;
    private static final double footWidth = 0.11;
    private static final double lineWidth = 0.02;
    private static final double ankleHeight = 0.084;
    private static final Point2D[] contactPointsFull = new Point2D[]{new Point2D(0.11, -0.055), new Point2D(0.11, 0.055), new Point2D(-0.11, 0.055), new Point2D(-0.11, -0.055)};
    private static final Point2D[] contactPointsLineFrontToBack = new Point2D[]{new Point2D(0.11, -0.01), new Point2D(0.11, 0.01), new Point2D(-0.11, 0.01), new Point2D(-0.11, -0.01)};
    private static final Point2D[] contactPointsLineSideToSide = new Point2D[]{new Point2D(0.01, -0.055), new Point2D(0.01, 0.055), new Point2D(-0.01, 0.055), new Point2D(-0.01, -0.055)};
    private static final Point2D[] contactPointsHalfFront = new Point2D[]{new Point2D(0.11, -0.055), new Point2D(0.11, 0.055), new Point2D(0.0, 0.055), new Point2D(0.0, -0.055)};
    private static final Point2D[] contactPointsHalfBack = new Point2D[]{new Point2D(0.0, -0.055), new Point2D(0.0, 0.055), new Point2D(-0.11, 0.055), new Point2D(-0.11, -0.055)};
    private static final EnumMap<ContactType, Point2D[]> contactPointMap = new EnumMap(ContactType.class);

    public CreateFootstepScript(String filePath) throws IOException, InterruptedException {
        File file = new File(filePath);
        if (file.isDirectory()) {
            System.err.println("Expected file - got a directory");
            return;
        }
        File newScript = new File(file.getParentFile(), file.getName());
        ScriptFileSaver scriptFileSaver = null;
        try {
            scriptFileSaver = new ScriptFileSaver(newScript, true);
        }
        catch (IOException e) {
            PrintTools.error((String)("During writing: " + e.getClass().getSimpleName() + " for the file:" + String.valueOf(newScript)));
            if (e.getCause() != null) {
                PrintTools.error((String)e.getCause().getMessage());
            } else {
                PrintTools.error((String)e.getMessage());
            }
            return;
        }
        ArrayList<Object> scriptObjects = new ArrayList<Object>();
        this.assembleScript(scriptObjects);
        for (Object newObject : scriptObjects) {
            ScriptObject newScriptObject = new ScriptObject(System.currentTimeMillis(), newObject);
            scriptFileSaver.recordObject(newScriptObject.getTimeStamp(), newScriptObject.getScriptObject());
        }
        scriptFileSaver.close();
        System.out.println("Created script: " + String.valueOf(newScript));
    }

    private void assembleScript(ArrayList<Object> scriptObjects) {
        scriptObjects.add(HumanoidMessageTools.createPauseWalkingMessage((boolean)true));
        FootstepDataListMessage footsteps = HumanoidMessageTools.createFootstepDataListMessage((double)0.6, (double)0.0);
        this.addFootsteps(footsteps);
        scriptObjects.add(footsteps);
        scriptObjects.add(HumanoidMessageTools.createPauseWalkingMessage((boolean)true));
        scriptObjects.add(new EndOfScriptCommand());
    }

    private void addFootsteps(FootstepDataListMessage footsteps) {
        footsteps.getFootstepDataList().clear();
        int idx = 0;
        for (ContactType contactType : this.contactSequence) {
            ((FootstepDataMessage)footsteps.getFootstepDataList().add()).set(this.createFootstep(contactType, idx++));
        }
        ((FootstepDataMessage)footsteps.getFootstepDataList().add()).set(this.createFootstep(ContactType.FULL, idx++));
        ((FootstepDataMessage)footsteps.getFootstepDataList().add()).set(this.createFootstep(ContactType.FULL, idx++));
    }

    private FootstepDataMessage createFootstep(ContactType contactType, int idx) {
        FootstepDataMessage footstep = new FootstepDataMessage();
        RobotSide robotSide = idx % 2 == 0 ? RobotSide.LEFT : RobotSide.RIGHT;
        double x = Math.floor((double)(idx + 2) / 2.0) * 0.3;
        double y = robotSide == RobotSide.RIGHT ? -0.3 : 0.0;
        Point2D[] contactPoints = contactPointMap.get((Object)contactType);
        footstep.setRobotSide(robotSide.toByte());
        footstep.getLocation().set(new Point3D(x, y, 0.084));
        footstep.getOrientation().set(new Quaternion(0.0, 0.0, 0.0, 1.0));
        HumanoidMessageTools.packPredictedContactPoints((Point2DReadOnly[])contactPoints, (FootstepDataMessage)footstep);
        return footstep;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(Paths.get("..", "Atlas", "scripts", "partialFootholds_sequence4.xml"));
        for (Path path : paths) {
            String pathString = path.toString();
            System.out.println("Creating script: " + pathString);
            new CreateFootstepScript(pathString);
        }
    }

    static {
        contactPointMap.put(ContactType.FULL, contactPointsFull);
        contactPointMap.put(ContactType.LINE_FRONT_BACK, contactPointsLineFrontToBack);
        contactPointMap.put(ContactType.LINE_SIDE_SIDE, contactPointsLineSideToSide);
        contactPointMap.put(ContactType.HALF_FRONT, contactPointsHalfFront);
        contactPointMap.put(ContactType.HALF_BACK, contactPointsHalfBack);
    }

    private static enum ContactType {
        FULL,
        LINE_FRONT_BACK,
        LINE_SIDE_SIDE,
        HALF_FRONT,
        HALF_BACK;

    }
}

