/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sakeGripper;

public enum SakeHandPreset {
    OPEN(105.0, 8.7),
    CLOSE(10.0, 8.7),
    GRIP(0.0, 8.7),
    FULLY_OPEN(210.0, 8.7),
    GRIP_HARD(0.0, 20.3),
    PARALLEL_FINGERS(21.0, 8.7);

    private final double handOpenAngle;
    private final double fingertipGripForceLimit;
    public static final SakeHandPreset[] values;

    private SakeHandPreset(double handOpenAngleDegrees, double fingertipGripForceLimit) {
        this.handOpenAngle = Math.toRadians(handOpenAngleDegrees);
        this.fingertipGripForceLimit = fingertipGripForceLimit;
    }

    public double getHandOpenAngle() {
        return this.handOpenAngle;
    }

    public double getFingertipGripForceLimit() {
        return this.fingertipGripForceLimit;
    }

    public String getPascalCasedName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case OPEN -> "Open";
            case CLOSE -> "Close";
            case GRIP -> "Grip";
            case FULLY_OPEN -> "Fully Open";
            case PARALLEL_FINGERS -> "Parallel Fingers";
            case GRIP_HARD -> "Grip Hard";
        };
    }

    static {
        values = SakeHandPreset.values();
    }
}

