/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sakeGripper;

import controller_msgs.msg.dds.SakeHandDesiredCommandMessage;

public class SakeHandParameters {
    public static final double MAX_DESIRED_HAND_OPEN_ANGLE_DEGREES = 210.0;
    public static final double OPEN_KNUCKLE_JOINT_ANGLE_DEGREES = 105.0;
    public static final double FINGERTIP_GRIP_FORCE_HARDWARE_LIMIT = 29.0;
    public static final double FINGERTIP_GRIP_FORCE_SAFE = 8.7;
    public static final double FINGERTIP_GRIP_FORCE_MODERATE_THRESHOLD = 14.5;
    public static final double FINGERTIP_GRIP_FORCE_HIGH_THRESHOLD = 20.3;
    public static final double DYNAMIXEL_MX_64AR_STALL_TORQUE = 6.0;
    public static final double KNUCKLE_TORQUE_AT_LIMIT = 2.0;
    public static final double NORMAL_TEMPERATURE_CELSIUS = 30.0;
    public static final double WARNING_TEMPERATURE_CELSIUS = 40.0;
    public static final double ERROR_TEMPERATURE_CELSIUS = 50.0;
    public static final double RESET_TEMPERATURE_CELSIUS = 65.0;
    public static final double TEMPERATURE_LIMIT_CELSIUS = 75.0;
    public static final int DYNAMIXEL_FAILURE_TEMPERATURE_CELSIUS = 80;
    public static final double RAW_SAKE_POSITION_TO_RAD = 0.0015339807878856412;
    public static final double RAW_SAKE_VELOCITY_TO_RAD_PER_SEC = 0.011519173063162575;
    public static final double RAW_SAKE_TORQUE_TO_GRIP_FORCE = 0.028347996089931573;
    public static final int RAW_SAKE_HAND_RANGE = 2500;
    public static final int RAW_POSITION_MIN_VALUE = -28672;

    public static double denormalizeHandOpenAngle(double normalizedHandOpenAngle) {
        return normalizedHandOpenAngle * Math.toRadians(210.0);
    }

    public static double normalizeHandOpenAngle(double handOpenAngle) {
        return handOpenAngle / Math.toRadians(210.0);
    }

    public static double denormalizeHandPosition(double normalizedPosition, double positionLowerLimit, double positionUpperLimit) {
        return normalizedPosition * (positionUpperLimit - positionLowerLimit) + positionLowerLimit;
    }

    public static double normalizeHandPosition(double handPosition, double positionLowerLimit, double positionUpperLimit) {
        return (handPosition - positionLowerLimit) / (positionUpperLimit - positionLowerLimit);
    }

    public static double denormalizeFingertipGripForceLimit(double normalizedFingertipGripForceLimit) {
        return normalizedFingertipGripForceLimit * 29.0;
    }

    public static double normalizeFingertipGripForceLimit(double fingertipGripForceLimit) {
        return fingertipGripForceLimit / 29.0;
    }

    public static double denormalizeKnuckleTorque(double knuckleTorque) {
        return knuckleTorque * 2.0;
    }

    public static double normalizeKnuckleTorque(double knuckleTorque) {
        return knuckleTorque / 2.0;
    }

    public static double knuckleJointAngleToHandOpenAngle(double knuckleJointAngle) {
        return SakeHandParameters.denormalizeHandOpenAngle(knuckleJointAngle / Math.toRadians(105.0));
    }

    public static double knuckleJointAnglesToHandOpenAngle(double knuckle1JointAngle, double knuckle2JointAngle) {
        return SakeHandParameters.knuckleJointAngleToHandOpenAngle(knuckle1JointAngle + knuckle2JointAngle) / 2.0;
    }

    public static double handOpenAngleToKnuckleJointAngle(double handOpenAngle) {
        return SakeHandParameters.normalizeHandOpenAngle(handOpenAngle) * Math.toRadians(105.0);
    }

    public static double handOpenAngleToPosition(double handOpenAngle, double positionLowerLimit, double positionUpperLimit) {
        return SakeHandParameters.normalizeHandOpenAngle(handOpenAngle) * (positionUpperLimit - positionLowerLimit) + positionLowerLimit;
    }

    public static double handPositionToOpenAngle(double handPosition, double positionLowerLimit, double positionUpperLimit) {
        return SakeHandParameters.normalizeHandPosition(handPosition, positionLowerLimit, positionUpperLimit) * Math.toRadians(210.0);
    }

    public static double handPositionToKnuckleJointAngle(double handPosition, double positionLowerLimit, double positionUpperLimit) {
        return SakeHandParameters.handOpenAngleToKnuckleJointAngle(SakeHandParameters.handPositionToOpenAngle(handPosition, positionLowerLimit, positionUpperLimit));
    }

    public static int gripForceToRawTorque(double gripForce) {
        return (int)(gripForce / 0.028347996089931573);
    }

    public static double knuckleTorqueToGripForce(double knuckleTorque) {
        return SakeHandParameters.normalizeKnuckleTorque(knuckleTorque) * 29.0;
    }

    public static double gripForceToKnuckleTorque(double gripForce) {
        return SakeHandParameters.normalizeFingertipGripForceLimit(gripForce) * 2.0;
    }

    public static void resetDesiredCommandMessage(SakeHandDesiredCommandMessage sakeHandDesiredCommandMessage) {
        sakeHandDesiredCommandMessage.setGripperDesiredPosition(Double.NaN);
        sakeHandDesiredCommandMessage.setRawGripperTorqueLimit(-1);
        sakeHandDesiredCommandMessage.setRequestCalibration(false);
        sakeHandDesiredCommandMessage.setRequestResetErrors(false);
        sakeHandDesiredCommandMessage.setTorqueOn(true);
        sakeHandDesiredCommandMessage.setEnableAutomaticCooldown(false);
        sakeHandDesiredCommandMessage.setDisableAutomaticCooldown(false);
        sakeHandDesiredCommandMessage.setOverrideCooldown(false);
    }

    public static int convertAngleToRawPosition(double radians) {
        return (int)(radians / 0.0015339807878856412);
    }

    public static double convertRawPositionToRadians(int rawPosition) {
        return (double)rawPosition * 0.0015339807878856412;
    }

    public static double convertRawVelocityToRadiansPerSecond(int rawVelocity) {
        return (double)rawVelocity * 0.011519173063162575;
    }
}

