/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sakeGripper;

import java.util.ArrayList;
import java.util.List;

public enum SakeHandError {
    NONE(0),
    OVERLOAD_ERROR(32),
    CHECKSUM_ERROR(16),
    RANGE_ERROR(8),
    OVER_HEATING_ERROR(4),
    ANGLE_LIMIT_ERROR(2),
    INPUT_VOLTAGE_ERROR(1);

    public final int errorCode;

    private SakeHandError(int errorCode) {
        this.errorCode = errorCode;
    }

    public String toString() {
        return this.name().replace("_", " ");
    }

    public static List<String> getErrorNames(int errorCode) {
        return SakeHandError.getErrorList(errorCode).stream().map(SakeHandError::toString).toList();
    }

    public static List<SakeHandError> getErrorList(int errorCode) {
        ArrayList<SakeHandError> errorList = new ArrayList<SakeHandError>();
        for (SakeHandError error : SakeHandError.values()) {
            if ((errorCode & error.errorCode) == 0) continue;
            errorList.add(error);
        }
        return errorList;
    }
}

