/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.sakeGripper;

import us.ihmc.avatar.sakeGripper.SakeHandError;
import us.ihmc.avatar.sakeGripper.SakeHandParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.SakeHandAPI;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class ROS2SakeHandStatus {
    private volatile boolean isCalibrated = false;
    private volatile boolean needsReset;
    private volatile boolean isCalibrating;
    private volatile boolean isCoolingDown;
    private volatile boolean automaticCooldownEnabled;
    private volatile double positionUpperLimit;
    private volatile double positionLowerLimit;
    private volatile boolean isTorqueOn;
    private volatile double commandedHandOpenAngle = Double.NaN;
    private volatile double commandedFingertipGripForceLimit = Double.NaN;
    private volatile double currentHandOpenAngle = Double.NaN;
    private volatile double currentFingertipGripForce = Double.NaN;
    private volatile double currentTemperature = Double.NaN;
    private volatile double currentVelocity = Double.NaN;
    private volatile int errorCodes = 0;
    private volatile int handRealtimeTick = 0;

    public ROS2SakeHandStatus(ROS2Node ros2Node, String robotName, RobotSide handSide) {
        ROS2Tools.createVolatileCallbackSubscription((ROS2Node)ros2Node, (ROS2Topic)SakeHandAPI.getHandSakeStatusTopic((String)robotName, (RobotSide)handSide), sakeHandStatusMessage -> {
            this.isCalibrated = sakeHandStatusMessage.getIsCalibrated();
            this.needsReset = sakeHandStatusMessage.getNeedsReset();
            this.isCalibrating = sakeHandStatusMessage.getIsCalibrating();
            this.isCoolingDown = sakeHandStatusMessage.getIsCoolingDown();
            this.automaticCooldownEnabled = sakeHandStatusMessage.getAutomaticCooldownEnabled();
            this.positionUpperLimit = sakeHandStatusMessage.getPositionUpperLimit();
            this.positionLowerLimit = sakeHandStatusMessage.getPositionLowerLimit();
            this.isTorqueOn = sakeHandStatusMessage.getTorqueOnStatus();
            this.currentTemperature = sakeHandStatusMessage.getTemperature();
            this.currentHandOpenAngle = SakeHandParameters.handPositionToOpenAngle(sakeHandStatusMessage.getCurrentPosition(), this.positionLowerLimit, this.positionUpperLimit);
            this.commandedHandOpenAngle = SakeHandParameters.handPositionToOpenAngle(sakeHandStatusMessage.getDesiredPositionStatus(), this.positionLowerLimit, this.positionUpperLimit);
            this.commandedHandOpenAngle = MathTools.clamp((double)this.commandedHandOpenAngle, (double)0.0, (double)210.0);
            this.currentFingertipGripForce = (double)sakeHandStatusMessage.getRawCurrentTorque() * 0.028347996089931573;
            this.commandedFingertipGripForceLimit = sakeHandStatusMessage.getRawTorqueLimitStatus() * 0.028347996089931573;
            this.currentVelocity = sakeHandStatusMessage.getCurrentVelocity();
            this.errorCodes = sakeHandStatusMessage.getErrorCodes();
            this.handRealtimeTick = sakeHandStatusMessage.getRealtimeTick();
        });
    }

    public boolean getIsCalibrated() {
        return this.isCalibrated;
    }

    public boolean getNeedsReset() {
        return this.needsReset;
    }

    public boolean getIsCalibrating() {
        return this.isCalibrating;
    }

    public boolean getIsCoolingDown() {
        return this.isCoolingDown;
    }

    public boolean getAutomaticCooldownEnabled() {
        return this.automaticCooldownEnabled;
    }

    public double getPositionUpperLimit() {
        return this.positionUpperLimit;
    }

    public double getPositionLowerLimit() {
        return this.positionLowerLimit;
    }

    public double getCurrentTemperature() {
        return this.currentTemperature;
    }

    public double getCurrentHandOpenAngle() {
        return this.currentHandOpenAngle;
    }

    public double getCommandedHandOpenAngle() {
        return this.commandedHandOpenAngle;
    }

    public double getCurrentFingertipGripForce() {
        return this.currentFingertipGripForce;
    }

    public double getCommandedFingertipGripForceLimit() {
        return this.commandedFingertipGripForceLimit;
    }

    public boolean isTorqueOn() {
        return this.isTorqueOn;
    }

    public double getCurrentVelocity() {
        return this.currentVelocity;
    }

    public int getErrorCodes() {
        return this.errorCodes;
    }

    public String getErrorString() {
        StringBuilder errorString = new StringBuilder();
        for (String errorName : SakeHandError.getErrorNames(this.errorCodes)) {
            errorString.append("[").append(errorName).append("]");
        }
        return errorString.toString();
    }

    public int getHandRealtimeTick() {
        return this.handRealtimeTick;
    }
}

