/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest.profiles;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import std_msgs.msg.dds.Int64;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestMachine;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestProfile;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;

public class IntegersAt1HzNetworkTestProfile
extends ROS2NetworkTestProfile {
    private static final ROS2Topic<Int64> BASE_TOPIC = ROS2Tools.IHMC_ROOT.withModule("ints1hz").withType(Int64.class);
    private static final ROS2Topic<Int64> TO_OCU = BASE_TOPIC.withSuffix("toocu");
    private static final ROS2Topic<Int64> TO_CPU1 = BASE_TOPIC.withSuffix("tocpu1");
    private final MutableInt number = new MutableInt();
    private final ROS2Publisher<Int64> publisher;
    private final YoRegistry yoRegistry = new YoRegistry(this.getMachineName() + this.getClass().getSimpleName());
    private final YoLong messagesSent = new YoLong(this.getMachineName() + "Sent", this.yoRegistry);
    private final YoLong messagesReceived = new YoLong(this.getMachineName() + "Received", this.yoRegistry);
    private PausablePeriodicThread experimentThread;

    public IntegersAt1HzNetworkTestProfile() {
        LogTools.info((String)"Running on {}", (Object)this.getMachineName());
        ROS2Node ros2Node = new ROS2NodeBuilder().build("profile");
        ROS2Topic<Int64> publisherTopic = null;
        ROS2Topic<Int64> subscriberTopic = null;
        if (this.getLocalMachine() == ROS2NetworkTestMachine.CPU1) {
            publisherTopic = TO_OCU;
            subscriberTopic = TO_CPU1;
        } else if (this.getLocalMachine() == ROS2NetworkTestMachine.CPU0) {
            publisherTopic = TO_OCU;
        } else if (this.getLocalMachine() == ROS2NetworkTestMachine.CPU4) {
            publisherTopic = TO_OCU;
        } else {
            publisherTopic = TO_CPU1;
            subscriberTopic = TO_OCU;
        }
        this.publisher = ros2Node.createPublisher(publisherTopic);
        if (subscriberTopic != null) {
            ros2Node.createSubscription2(subscriberTopic, message -> this.messagesReceived.add(1L));
        }
    }

    @Override
    public List<ROS2NetworkTestMachine> getMachines() {
        ArrayList<ROS2NetworkTestMachine> machines = new ArrayList<ROS2NetworkTestMachine>();
        machines.add(ROS2NetworkTestMachine.OCU);
        machines.add(ROS2NetworkTestMachine.CPU0);
        machines.add(ROS2NetworkTestMachine.CPU1);
        machines.add(ROS2NetworkTestMachine.CPU4);
        return machines;
    }

    @Override
    public void runExperiment() {
        this.experimentThread = new PausablePeriodicThread(this.getClass().getSimpleName(), 1.0, () -> {
            Int64 message = new Int64();
            message.setData((long)this.number.getAndIncrement());
            LogTools.info((String)"Publishing {}", (Object)this.number.getValue());
            this.messagesSent.add(1L);
            this.publisher.publish((Object)message);
        });
        this.experimentThread.start();
        ThreadTools.sleepSeconds((double)10.0);
    }

    @Override
    public List<String[]> getGraphsToSetup() {
        ArrayList<String[]> graphsToSetup = new ArrayList<String[]>();
        graphsToSetup.add(new String[]{"cpu0Sent", "cpu1Sent", "cpu4Sent", "ocuReceived"});
        graphsToSetup.add(new String[]{"ocuSent", "cpu1Received"});
        return graphsToSetup;
    }

    @Override
    public void destroy() {
        if (this.experimentThread != null) {
            this.experimentThread.destroy();
        }
    }

    @Override
    public YoRegistry getYoRegistry() {
        return this.yoRegistry;
    }
}

