/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest.profiles;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import std_msgs.msg.dds.Int64;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestMachine;
import us.ihmc.avatar.ros2.networkTest.ROS2NetworkTestProfile;
import us.ihmc.commons.UnitConversions;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.tools.thread.PausablePeriodicThread;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoLong;

public class IntegersAt100HzNetworkTestProfile
extends ROS2NetworkTestProfile {
    private static final ROS2Topic<Int64> BASE_TOPIC = ROS2Tools.IHMC_ROOT.withModule("ints100hz").withType(Int64.class).withQoS(ROS2QosProfile.BEST_EFFORT());
    private static final ROS2Topic<Int64> TO_OCU = BASE_TOPIC.withSuffix("toocu");
    public static final double PUBLISH_FREQUENCY = 100.0;
    public static final double EXPERIMENT_DURATION = 100.0;
    private final MutableInt number = new MutableInt();
    private final YoRegistry yoRegistry = new YoRegistry(this.getMachineName() + this.getClass().getSimpleName());
    private final YoLong messagesSent = new YoLong(this.getMachineName() + "Sent", this.yoRegistry);
    private final YoLong messagesReceived = new YoLong(this.getMachineName() + "Received", this.yoRegistry);
    private long lastReceived = -1L;
    private YoLong totalSent;
    private YoLong messagesReceivedOutOfOrder;
    private YoLong lastReceivedNumber;
    private PausablePeriodicThread publishThread;
    private final ROS2Node ros2Node;

    public IntegersAt100HzNetworkTestProfile() {
        LogTools.info((String)"Running on {}", (Object)this.getMachineName());
        this.ros2Node = new ROS2NodeBuilder().build(this.getMachineName() + "ints100hz");
        if (this.getLocalMachine() == ROS2NetworkTestMachine.OCU) {
            this.totalSent = new YoLong("totalSent", this.yoRegistry);
            this.messagesReceivedOutOfOrder = new YoLong("ocuReceivedOutOfOrder", this.yoRegistry);
            this.lastReceivedNumber = new YoLong("lastReceivedNumber", this.yoRegistry);
        }
    }

    @Override
    public void updateDerivativeVariables(YoRegistry syncedRegistry) {
        YoLong cpu0Sent = (YoLong)syncedRegistry.findVariable("cpu0Sent");
        YoLong cpu1Sent = (YoLong)syncedRegistry.findVariable("cpu1Sent");
        YoLong cpu4Sent = (YoLong)syncedRegistry.findVariable("cpu4Sent");
        this.totalSent.set(cpu0Sent.getValue() + cpu1Sent.getValue() + cpu4Sent.getValue());
        this.lastReceivedNumber.set(this.lastReceived);
    }

    @Override
    public List<ROS2NetworkTestMachine> getMachines() {
        ArrayList<ROS2NetworkTestMachine> machines = new ArrayList<ROS2NetworkTestMachine>();
        machines.add(ROS2NetworkTestMachine.OCU);
        machines.add(ROS2NetworkTestMachine.CPU0);
        machines.add(ROS2NetworkTestMachine.CPU1);
        machines.add(ROS2NetworkTestMachine.CPU4);
        return machines;
    }

    @Override
    public void runExperiment() {
        if (this.getLocalMachine() == ROS2NetworkTestMachine.OCU) {
            this.ros2Node.createSubscription2(TO_OCU, message -> {
                long messageNumber = message.getData();
                if (messageNumber - 1L != this.lastReceived) {
                    this.messagesReceivedOutOfOrder.add(1L);
                }
                this.lastReceived = messageNumber;
                this.messagesReceived.add(1L);
            });
        } else {
            int numberOfRemoteMachines = this.getRemoteMachines().size();
            double publishPeriod = UnitConversions.hertzToSeconds((double)100.0);
            if (this.getLocalMachine() == ROS2NetworkTestMachine.CPU1) {
                ThreadTools.sleepSeconds((double)(publishPeriod / (double)numberOfRemoteMachines));
                this.number.add(1);
            } else if (this.getLocalMachine() == ROS2NetworkTestMachine.CPU4) {
                this.number.add(2);
                ThreadTools.sleepSeconds((double)(2.0 * publishPeriod / (double)numberOfRemoteMachines));
            }
            ROS2Publisher publisher = this.ros2Node.createPublisher(TO_OCU);
            this.publishThread = new PausablePeriodicThread(this.getClass().getSimpleName(), publishPeriod, () -> {
                if ((double)this.messagesSent.getValue() < 10000.0) {
                    Int64 message = new Int64();
                    message.setData((long)this.number.getAndAdd(numberOfRemoteMachines));
                    this.messagesSent.add(1L);
                    publisher.publish((Object)message);
                }
            });
            this.publishThread.start();
        }
        ThreadTools.sleepSeconds((double)100.0);
        if (this.getLocalMachine() != ROS2NetworkTestMachine.OCU) {
            this.publishThread.stop();
        }
    }

    @Override
    public List<String[]> getGraphsToSetup() {
        ArrayList<String[]> graphsToSetup = new ArrayList<String[]>();
        graphsToSetup.add(new String[]{"cpu0Sent", "cpu1Sent", "cpu4Sent"});
        graphsToSetup.add(new String[]{"totalSent", "ocuReceived", "lastReceivedNumber"});
        graphsToSetup.add(new String[]{"ocuReceivedOutOfOrder"});
        return graphsToSetup;
    }

    @Override
    public void destroy() {
        if (this.publishThread != null) {
            this.publishThread.destroy();
        }
    }

    @Override
    public YoRegistry getYoRegistry() {
        return this.yoRegistry;
    }
}

