/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2.networkTest;

import java.net.InetAddress;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;

public enum ROS2NetworkTestMachine {
    OCU("atlas-ocu", "atlas-ocu", "172.16.66.62", "robotlab", "unused"),
    CPU0("cpu0", "CPU0", "172.16.66.100", "shadylady", "/usr/local/bin/mission_control/bin"),
    CPU1("cpu1", "cpu1", "172.16.66.101", "shadylady", "/usr/local/bin/mission_control/bin"),
    CPU4("cpu4", "cpu4", "172.16.66.104", "shadylady", "/usr/local/bin/mission_control/bin");

    public static final String LOCAL_HOSTNAME;
    private final String sshHostname;
    private final String localHostname;
    private final String ipAddress;
    private final String username;
    private final String deployDirectory;

    public static ROS2NetworkTestMachine getLocalMachine() {
        for (ROS2NetworkTestMachine machine : ROS2NetworkTestMachine.values()) {
            if (!machine.getLocalHostname().equals(LOCAL_HOSTNAME)) continue;
            return machine;
        }
        throw new RuntimeException("Must be run from registered machine. Detected hostname: " + LOCAL_HOSTNAME);
    }

    private ROS2NetworkTestMachine(String sshHostname, String localHostname, String ipAddress, String username, String deployDirectory) {
        this.sshHostname = sshHostname;
        this.localHostname = localHostname;
        this.ipAddress = ipAddress;
        this.username = username;
        this.deployDirectory = deployDirectory;
    }

    public String getSSHHostname() {
        return this.sshHostname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDeployDirectory() {
        return this.deployDirectory;
    }

    public String getLocalHostname() {
        return this.localHostname;
    }

    public String getIPAddress() {
        return this.ipAddress;
    }

    public String getMachineName() {
        return this.name().toLowerCase();
    }

    static {
        LOCAL_HOSTNAME = (String)ExceptionTools.handle(() -> InetAddress.getLocalHost().getHostName(), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
    }
}

