/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros2;

import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.WalkingStatusMessage;
import java.util.function.Consumer;
import java.util.function.Function;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.ros2.ROS2ControllerPublisherMap;
import us.ihmc.commons.thread.Notification;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.communication.ros2.ROS2ControllerPublishSubscribeAPI;
import us.ihmc.communication.ros2.ROS2Helper;
import us.ihmc.ros2.ROS2Input;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class ROS2ControllerHelper
extends ROS2Helper
implements ROS2ControllerPublishSubscribeAPI {
    protected final ROS2ControllerPublisherMap ros2ControllerPublisherMap;
    private final String simpleRobotName;

    public ROS2ControllerHelper(ROS2Node ros2Node, DRCRobotModel robotModel) {
        this(ros2Node, robotModel.getSimpleRobotName());
    }

    public ROS2ControllerHelper(ROS2Node ros2Node, String simpleRobotName) {
        super(ros2Node);
        this.simpleRobotName = simpleRobotName;
        this.ros2ControllerPublisherMap = new ROS2ControllerPublisherMap(simpleRobotName, this.ros2PublisherMap);
    }

    public <T> void subscribeViaCallback(Function<String, ROS2Topic<T>> topicFunction, Consumer<T> callback) {
        this.subscribeViaCallback(topicFunction.apply(this.simpleRobotName), callback);
    }

    public <T> void subscribeViaVolatileCallback(Function<String, ROS2Topic<T>> topicFunction, Consumer<T> callback) {
        this.subscribeViaVolatileCallback(topicFunction.apply(this.simpleRobotName), callback);
    }

    public void publishToController(Object message) {
        this.ros2ControllerPublisherMap.publish(message);
    }

    public <T> void publish(Function<String, ROS2Topic<T>> topic, T message) {
        this.publish(topic.apply(this.simpleRobotName), message);
    }

    public <T> ROS2Input<T> subscribeToController(Class<T> messageClass) {
        return this.subscribe(HumanoidControllerAPI.getTopic(messageClass, (String)this.simpleRobotName));
    }

    public ROS2Input<RobotConfigurationData> subscribeToRobotConfigurationData() {
        return this.subscribe(StateEstimatorAPI.getRobotConfigurationDataTopic((String)this.getRobotName()));
    }

    public <T> void subscribeToControllerViaCallback(Class<T> messageClass, Consumer<T> callback) {
        this.subscribeViaCallback(HumanoidControllerAPI.getTopic(messageClass, (String)this.simpleRobotName), callback);
    }

    public <T> void subscribeToControllerViaVolatileCallback(Class<T> messageClass, Consumer<T> callback) {
        this.subscribeViaVolatileCallback(HumanoidControllerAPI.getTopic(messageClass, (String)this.simpleRobotName), callback);
    }

    public Notification subscribeToWalkingCompletedViaNotification() {
        Notification notification = new Notification();
        this.subscribeToControllerViaCallback(WalkingStatusMessage.class, walkingStatusMessage -> {
            if (walkingStatusMessage.getWalkingStatus() == 1) {
                notification.set();
            }
        });
        return notification;
    }

    public String getRobotName() {
        return this.simpleRobotName;
    }
}

