/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros.messages;

import java.nio.DoubleBuffer;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple4D.Quaternion;

public class PoseMessage {
    private final double[] position = new double[3];
    private final double[] orientation = new double[4];

    public void packPosition(Vector3D position) {
        position.setX(this.position[0]);
        position.setY(this.position[1]);
        position.setZ(this.position[2]);
    }

    public void packOrientation(Quaternion orientation) {
        orientation.set(this.orientation);
    }

    public void setFromBuffer(DoubleBuffer buffer) {
        buffer.rewind();
        buffer.get(this.position);
        buffer.get(this.orientation);
    }

    public void copyToBuffer(DoubleBuffer buffer) {
        buffer.rewind();
        buffer.put(this.position);
        buffer.put(this.orientation);
    }

    public void setPosition(double[] position) {
        if (position.length < 3) {
            throw new RuntimeException("Bad position vector");
        }
        this.position[0] = position[0];
        this.position[1] = position[1];
        this.position[2] = position[2];
    }

    public double getPosX() {
        return this.position[0];
    }

    public double getPosY() {
        return this.position[1];
    }

    public double getPosZ() {
        return this.position[2];
    }

    public double getOrientationW() {
        return this.orientation[0];
    }

    public double getOrientationX() {
        return this.orientation[1];
    }

    public double getOrientationY() {
        return this.orientation[2];
    }

    public double getOrientationZ() {
        return this.orientation[3];
    }

    public void setOrientation(double[] orientation) {
        if (this.position.length < 4) {
            throw new RuntimeException("Bad position vector");
        }
        this.orientation[0] = orientation[0];
        this.orientation[1] = orientation[1];
        this.orientation[2] = orientation[2];
        this.orientation[3] = orientation[3];
    }

    public void setPosX(double x) {
        this.position[0] = x;
    }

    public void setPosY(double y) {
        this.position[1] = y;
    }

    public void setPosZ(double z) {
        this.position[2] = z;
    }

    public void setOrientationW(double w) {
        this.orientation[0] = w;
    }

    public void setOrientationX(double x) {
        this.orientation[1] = x;
    }

    public void setOrientationY(double y) {
        this.orientation[2] = y;
    }

    public void setOrientationZ(double z) {
        this.orientation[3] = z;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[PoseMessage] PosX: " + this.position[0]);
        builder.append("[PoseMessage] PosY: " + this.position[1]);
        builder.append("[PoseMessage] PosZ: " + this.position[2]);
        builder.append("[PoseMessage] QuatW: " + this.orientation[0]);
        builder.append("[PoseMessage] QuatX: " + this.orientation[1]);
        builder.append("[PoseMessage] QuatY: " + this.orientation[2]);
        builder.append("[PoseMessage] QuatZ: " + this.orientation[3]);
        return builder.toString();
    }
}

