/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import java.net.URI;
import java.net.URISyntaxException;
import org.ros.message.MessageListener;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.DefaultNodeMainExecutor;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;
import org.ros.node.topic.Subscriber;
import sensor_msgs.CompressedImage;
import us.ihmc.tools.inputDevices.keyboard.linux.RepeatingReleasedEventsFixer;
import us.ihmc.utilities.ros.RosTools;

public class RosCameraBenchmarker
extends AbstractNodeMain {
    private Subscriber<CompressedImage> cameraSubscriber;
    private String topicName;
    private long initialTime;
    private double framesReceived = 0.0;

    public RosCameraBenchmarker(String topicName) {
        new RepeatingReleasedEventsFixer().install();
        this.topicName = topicName;
    }

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)("darpaRoboticsChallenge/RosCameraBenchmarker" + this.topicName));
    }

    public void onStart(ConnectedNode connectedNode) {
        this.setupSubscriber(connectedNode);
        this.setupCameraSubscriberListener();
    }

    private void setupCameraSubscriberListener() {
        this.cameraSubscriber.addMessageListener((MessageListener)new MessageListener<CompressedImage>(){

            public void onNewMessage(CompressedImage message) {
                if (RosCameraBenchmarker.this.framesReceived == 0.0) {
                    RosCameraBenchmarker.this.initialTime = System.currentTimeMillis();
                } else {
                    System.out.println("FPS: " + RosCameraBenchmarker.this.framesReceived * 1000.0 / (double)(System.currentTimeMillis() - RosCameraBenchmarker.this.initialTime));
                }
                RosCameraBenchmarker.this.framesReceived += 1.0;
            }
        });
    }

    private void setupSubscriber(ConnectedNode connectedNode) {
        this.cameraSubscriber = connectedNode.newSubscriber(this.topicName, "sensor_msgs/CompressedImage");
    }

    public static void main(String[] args) throws URISyntaxException {
        String MASTER = "http://localhost:11311";
        String TOPIC_NAME = "/camera/image_raw/compressed";
        URI master = new URI(MASTER);
        try {
            RosCameraBenchmarker externalCamera = new RosCameraBenchmarker(TOPIC_NAME);
            NodeConfiguration nodeConfiguration = RosTools.createNodeConfiguration((URI)master);
            NodeMainExecutor nodeMainExecutor = DefaultNodeMainExecutor.newDefault();
            nodeMainExecutor.execute((NodeMain)externalCamera, nodeConfiguration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

