/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.avatar.ros.BrakePedalStateListener;
import us.ihmc.avatar.ros.ClockListener;
import us.ihmc.avatar.ros.GasPedalStateListener;
import us.ihmc.avatar.ros.HandBrakeStateListener;
import us.ihmc.avatar.ros.SteeringWheelStateListener;
import us.ihmc.avatar.ros.VehiclePoseListener;
import us.ihmc.avatar.ros.messages.ClockMessage;
import us.ihmc.avatar.ros.messages.Float64Message;
import us.ihmc.avatar.ros.messages.Int8Message;
import us.ihmc.avatar.ros.messages.PoseMessage;
import us.ihmc.utilities.ros.RosTools;

public class ROSVehicleTeleopCheatNativeLibraryCommunicator {
    private static ROSVehicleTeleopCheatNativeLibraryCommunicator instance = null;
    private static String rosMasterURI;
    private static boolean hasNativeLibrary;
    private final DoubleBuffer vehiclePoseBuffer;
    private final LongBuffer clockBuffer;
    private final PoseMessage vehiclePose = new PoseMessage();
    private final ClockMessage clock = new ClockMessage();
    private final Float64Message steeringWheelState = new Float64Message();
    private final Float64Message handBrakeState = new Float64Message();
    private final Float64Message gasPedalState = new Float64Message();
    private final Float64Message brakePedalState = new Float64Message();
    private final DoubleBuffer atlasTeleportPoseCommandBuffer;
    private final PoseMessage atlasTeleportPoseCommand = new PoseMessage();
    private final Int8Message directionCommand = new Int8Message();
    private final Float64Message steeringWheelCommand = new Float64Message();
    private final Float64Message handBrakeCommand = new Float64Message();
    private final Float64Message gasPedalCommand = new Float64Message();
    private final Float64Message brakePedalCommand = new Float64Message();
    private final ArrayList<ClockListener> clockListeners = new ArrayList();
    private final ArrayList<VehiclePoseListener> vehiclePoseListeners = new ArrayList();
    private final ArrayList<HandBrakeStateListener> handBrakeStateListeners = new ArrayList();
    private final ArrayList<SteeringWheelStateListener> steeringWheelStateListeners = new ArrayList();
    private final ArrayList<GasPedalStateListener> gasPedalStateListeners = new ArrayList();
    private final ArrayList<BrakePedalStateListener> brakePedalStateListeners = new ArrayList();

    public static boolean hasNativeLibrary() {
        return hasNativeLibrary;
    }

    public void addClockListener(ClockListener listener) {
        this.clockListeners.add(listener);
    }

    public void addVehiclePoseListener(VehiclePoseListener listener) {
        this.vehiclePoseListeners.add(listener);
    }

    public void addSteeringWheelStateListener(SteeringWheelStateListener listener) {
        this.steeringWheelStateListeners.add(listener);
    }

    public void addHandBrakeStateListener(HandBrakeStateListener listener) {
        this.handBrakeStateListeners.add(listener);
    }

    public void addGasPedalStateListener(GasPedalStateListener listener) {
        this.gasPedalStateListeners.add(listener);
    }

    public void addBrakePedalStateListener(BrakePedalStateListener listener) {
        this.brakePedalStateListeners.add(listener);
    }

    private ROSVehicleTeleopCheatNativeLibraryCommunicator(String rosMasterURI) {
        InetAddress myIP = RosTools.getMyIP((String)rosMasterURI);
        if (!this.register(rosMasterURI, myIP.getHostAddress())) {
            throw new RuntimeException("Cannot load native library");
        }
        this.vehiclePoseBuffer = ROSVehicleTeleopCheatNativeLibraryCommunicator.setupDoubleBuffer(this.getVehiclePoseBuffer());
        this.clockBuffer = ROSVehicleTeleopCheatNativeLibraryCommunicator.setupLongBuffer(this.getClockBuffer());
        this.atlasTeleportPoseCommandBuffer = ROSVehicleTeleopCheatNativeLibraryCommunicator.setupDoubleBuffer(this.getAtlasTeleportPoseBuffer());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ROSVehicleTeleopCheatNativeLibraryCommunicator.this.shutdown();
            }
        });
    }

    public static ROSVehicleTeleopCheatNativeLibraryCommunicator getInstance(String rosMasterURI) {
        if (instance == null) {
            instance = new ROSVehicleTeleopCheatNativeLibraryCommunicator(rosMasterURI);
        } else if (!rosMasterURI.equals(ROSVehicleTeleopCheatNativeLibraryCommunicator.rosMasterURI)) {
            throw new RuntimeException("Cannot get an instance of ROSVehicleTeleopCheatNativeLibraryCommunicator for " + rosMasterURI + ", already connected to " + ROSVehicleTeleopCheatNativeLibraryCommunicator.rosMasterURI);
        }
        return instance;
    }

    public void connect() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ROSVehicleTeleopCheatNativeLibraryCommunicator.this.spin();
            }
        }).start();
    }

    private static DoubleBuffer setupDoubleBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asDoubleBuffer();
    }

    private static LongBuffer setupLongBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        return buffer.asLongBuffer();
    }

    private static ByteBuffer setupByteBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.nativeOrder());
        return buffer;
    }

    public void sendDirectionCommand(long timestamp, int delay, Int8Message directionCommand) {
        this.sendDirectionCommand((byte)directionCommand.getValue(), timestamp, delay);
    }

    public void sendSteeringWheelCommand(long timestamp, int delay, Float64Message steeringWheelCommand) {
        this.sendSteeringWheelCommand(steeringWheelCommand.getValue(), timestamp, delay);
    }

    public void sendHandBrakeCommand(long timestamp, int delay, Float64Message handBrakeCommand) {
        this.sendHandBrakeCommand(handBrakeCommand.getValue(), timestamp, delay);
    }

    public void sendGasPedalCommand(long timestamp, int delay, Float64Message gasPedalCommand) {
        this.sendGasPedalCommand(gasPedalCommand.getValue(), timestamp, delay);
    }

    public void sendBrakePedalCommand(long timestamp, int delay, Float64Message brakePedalCommand) {
        this.sendBrakePedalCommand(brakePedalCommand.getValue(), timestamp, delay);
    }

    public void sendAtlasTeleportIntoVehicleCommand(long timestamp, int delay, PoseMessage atlasTeleportPoseCommand) {
        atlasTeleportPoseCommand.copyToBuffer(this.atlasTeleportPoseCommandBuffer);
        this.sendAtlasTeleportIntoVehicleCommand(timestamp, delay);
    }

    public void sendAtlasTeleportOutOfVehicleCommand(long timestamp, int delay, PoseMessage atlasTeleportPoseCommand) {
        atlasTeleportPoseCommand.copyToBuffer(this.atlasTeleportPoseCommandBuffer);
        this.sendAtlasTeleportOutOfVehicleCommand(timestamp, delay);
    }

    public void enableOutput() {
        this.enableOutputNative();
    }

    private void receivedClockMessage() {
        this.clock.setFromBuffer(this.clockBuffer);
        for (int i = 0; i < this.clockListeners.size(); ++i) {
            this.clockListeners.get(i).receivedClockMessage(this.clock);
        }
    }

    private void receivedVehiclePose() {
        this.vehiclePose.setFromBuffer(this.vehiclePoseBuffer);
        for (int i = 0; i < this.vehiclePoseListeners.size(); ++i) {
            this.vehiclePoseListeners.get(i).receivedVehiclePose(this.vehiclePose);
        }
    }

    private void receivedHandBrakeState() {
        this.handBrakeState.setValue(this.getHandBrakeState());
        for (int i = 0; i < this.handBrakeStateListeners.size(); ++i) {
            this.handBrakeStateListeners.get(i).receivedHandBrakeState(this.handBrakeState);
        }
    }

    private void receivedSteeringWheelState() {
        this.steeringWheelState.setValue(this.getSteeringWheelState());
        for (int i = 0; i < this.steeringWheelStateListeners.size(); ++i) {
            this.steeringWheelStateListeners.get(i).receivedSteeringWheelState(this.steeringWheelState);
        }
    }

    private void receivedGasPedalState() {
        this.gasPedalState.setValue(this.getGasPedalState());
        for (int i = 0; i < this.gasPedalStateListeners.size(); ++i) {
            this.gasPedalStateListeners.get(i).receivedGasPedalState(this.gasPedalState);
        }
    }

    private void receivedBrakePedalState() {
        this.brakePedalState.setValue(this.getBrakePedalState());
        for (int i = 0; i < this.brakePedalStateListeners.size(); ++i) {
            this.brakePedalStateListeners.get(i).receivedBrakePedalState(this.brakePedalState);
        }
    }

    private native boolean register(String var1, String var2);

    private native void spin();

    public native double getSteeringWheelState();

    public native double getHandBrakeState();

    public native double getGasPedalState();

    public native double getBrakePedalState();

    private native ByteBuffer getVehiclePoseBuffer();

    private native ByteBuffer getAtlasTeleportPoseBuffer();

    private native ByteBuffer getClockBuffer();

    private native void sendDirectionCommand(byte var1, long var2, int var4);

    private native void sendSteeringWheelCommand(double var1, long var3, int var5);

    private native void sendHandBrakeCommand(double var1, long var3, int var5);

    private native void sendGasPedalCommand(double var1, long var3, int var5);

    private native void sendBrakePedalCommand(double var1, long var3, int var5);

    private native void sendAtlasTeleportIntoVehicleCommand(long var1, int var3);

    private native void sendAtlasTeleportOutOfVehicleCommand(long var1, int var3);

    private native void enableOutputNative();

    private native void shutdown();

    static {
        try {
            System.loadLibrary("ROSVehicleTeleopCheatNativeLibraryCommunicator");
            hasNativeLibrary = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Cannot load native ROS library for the vehicle teleop. Falling back to ROSJava, expect poor performance.");
            if (SystemUtils.IS_OS_LINUX) {
                System.err.println("Running on a Linux system; Library should be loadable.");
                e.printStackTrace();
            }
            hasNativeLibrary = false;
        }
    }
}

