/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ros.internal.message.Message;
import us.ihmc.avatar.DRCStartingLocation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessorParameters;
import us.ihmc.avatar.networkProcessor.time.SimulationRosClockPPSTimestampOffsetProvider;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RobotROSClockCalculatorFromPPSOffset;
import us.ihmc.avatar.rosAPI.ThePeoplesGloriousNetworkProcessor;
import us.ihmc.avatar.simulationStarter.DRCSimulationStarter;
import us.ihmc.communication.net.LocalObjectCommunicator;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public abstract class ROSAPISimulator {
    private static final String DEFAULT_TF_PREFIX = null;
    private static final String DEFAULT_PREFIX = "/ihmc_ros";
    private static final boolean REDIRECT_UI_PACKETS_TO_ROS = false;
    protected final DRCRobotModel robotModel;
    protected static final String DEFAULT_STRING = "DEFAULT";

    protected abstract CommonAvatarEnvironmentInterface createEnvironment();

    protected abstract List<Map.Entry<String, RosTopicSubscriberInterface<? extends Message>>> createCustomSubscribers(String var1, PacketCommunicator var2);

    protected abstract List<Map.Entry<String, RosTopicPublisher<? extends Message>>> createCustomPublishers(String var1, PacketCommunicator var2);

    public ROSAPISimulator(DRCRobotModel robotModel, DRCStartingLocation startingLocation, String nameSpace, String tfPrefix, boolean runAutomaticDiagnosticRoutine, boolean disableViz) throws IOException {
        this(robotModel, startingLocation, nameSpace, tfPrefix, runAutomaticDiagnosticRoutine, disableViz, Collections.emptySet());
    }

    public ROSAPISimulator(DRCRobotModel robotModel, DRCStartingLocation startingLocation, String nameSpace, String tfPrefix, boolean runAutomaticDiagnosticRoutine, boolean disableViz, Collection<Class> additionalPacketTypes) throws IOException {
        this.robotModel = robotModel;
        DRCSimulationStarter simulationStarter = new DRCSimulationStarter(robotModel, this.createEnvironment());
        simulationStarter.setRunMultiThreaded(true);
        HumanoidNetworkProcessorParameters networkProcessorParameters = new HumanoidNetworkProcessorParameters();
        PacketCommunicator rosAPI_communicator = PacketCommunicator.createIntraprocessPacketCommunicator((NetworkPorts)NetworkPorts.ROS_API_COMMUNICATOR, (NetClassList)new IHMCCommunicationKryoNetClassList());
        if (runAutomaticDiagnosticRoutine) {
            networkProcessorParameters.setUseAutomaticDiagnostic(true, true, 5.0);
        }
        if (disableViz) {
            DRCGuiInitialSetup guiSetup = new DRCGuiInitialSetup(false, false, false);
            simulationStarter.setGuiInitialSetup(guiSetup);
        }
        simulationStarter.setStartingLocation(startingLocation);
        simulationStarter.setInitializeEstimatorToActual(true);
        simulationStarter.startSimulation(networkProcessorParameters, true);
        LocalObjectCommunicator sensorCommunicator = simulationStarter.getSimulatedSensorsPacketCommunicator();
        RobotROSClockCalculatorFromPPSOffset rosClockCalculator = new RobotROSClockCalculatorFromPPSOffset(new SimulationRosClockPPSTimestampOffsetProvider());
        new ThePeoplesGloriousNetworkProcessor(networkProcessorParameters.getRosURI(), rosAPI_communicator, (ObjectCommunicator)sensorCommunicator, (RobotROSClockCalculator)rosClockCalculator, robotModel, nameSpace, tfPrefix, additionalPacketTypes, this.createCustomSubscribers(nameSpace, rosAPI_communicator), this.createCustomPublishers(nameSpace, rosAPI_communicator), new String[0]);
    }

    protected static Options parseArguments(String[] args) throws JSAPException, IOException {
        JSAP jsap = new JSAP();
        FlaggedOption rosNameSpace = new FlaggedOption("namespace").setLongFlag("namespace").setShortFlag('\u0000').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        rosNameSpace.setDefault(DEFAULT_PREFIX);
        FlaggedOption tfPrefix = new FlaggedOption("tfPrefix").setLongFlag("tfPrefix").setShortFlag('\u0000').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        tfPrefix.setDefault(DEFAULT_TF_PREFIX);
        FlaggedOption model = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        model.setDefault(DEFAULT_STRING);
        FlaggedOption location = new FlaggedOption("startingLocation").setLongFlag("location").setShortFlag('s').setRequired(false).setStringParser((StringParser)JSAP.STRING_PARSER);
        location.setDefault(DEFAULT_STRING);
        Switch visualizeSCSSwitch = new Switch("disable-visualize").setShortFlag('d').setLongFlag("disable-visualize");
        visualizeSCSSwitch.setHelp("Disable rendering/visualization of Simulation Construction Set");
        Switch requestAutomaticDiagnostic = new Switch("requestAutomaticDiagnostic").setLongFlag("requestAutomaticDiagnostic").setShortFlag('\u0000');
        requestAutomaticDiagnostic.setHelp("enable automatic diagnostic routine");
        jsap.registerParameter((Parameter)model);
        jsap.registerParameter((Parameter)location);
        jsap.registerParameter((Parameter)rosNameSpace);
        jsap.registerParameter((Parameter)tfPrefix);
        jsap.registerParameter((Parameter)requestAutomaticDiagnostic);
        jsap.registerParameter((Parameter)visualizeSCSSwitch);
        JSAPResult config = jsap.parse(args);
        Options options = new Options();
        options.robotModel = config.getString(model.getID());
        options.disableViz = config.getBoolean(visualizeSCSSwitch.getID());
        options.startingLocation = config.getString(location.getID());
        options.tfPrefix = config.getString(tfPrefix.getID());
        options.nameSpace = config.getString(rosNameSpace.getID());
        options.runAutomaticDiagnosticRoutine = config.getBoolean(requestAutomaticDiagnostic.getID());
        return options;
    }

    protected static class Options {
        public String robotModel;
        public String startingLocation;
        public String nameSpace;
        public String tfPrefix;
        public boolean runAutomaticDiagnosticRoutine;
        public boolean disableViz;

        protected Options() {
        }
    }
}

