/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.ros;

import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import java.util.concurrent.TimeUnit;
import us.ihmc.avatar.ros.RosHighLevelStatePublisher;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.util.PeriodicNonRealtimeThreadScheduler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class PeriodicRosHighLevelStatePublisher
implements PacketConsumer<HighLevelStateChangeStatusMessage>,
Runnable {
    private final RosHighLevelStatePublisher statePublisher = new RosHighLevelStatePublisher(false);
    private final RosMainNode rosMainNode;
    private HighLevelControllerName currentState = HighLevelControllerName.DO_NOTHING_BEHAVIOR;
    private final PeriodicNonRealtimeThreadScheduler scheduler = new PeriodicNonRealtimeThreadScheduler(this.getClass().getName());

    public PeriodicRosHighLevelStatePublisher(RosMainNode rosMainNode, String rosNameSpace) {
        this.rosMainNode = rosMainNode;
        this.initialize(rosNameSpace);
    }

    private void initialize(String rosNameSpace) {
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/high_level_state", (RosTopicPublisher)this.statePublisher);
        this.scheduler.schedule((Runnable)this, 1L, TimeUnit.MILLISECONDS);
    }

    public void receivedPacket(HighLevelStateChangeStatusMessage packet) {
        if (packet.getEndHighLevelControllerName() != this.currentState.toByte()) {
            this.currentState = HighLevelControllerName.fromByte((byte)packet.getEndHighLevelControllerName());
        }
    }

    @Override
    public void run() {
        if (Thread.interrupted()) {
            this.scheduler.shutdown();
        } else if (this.rosMainNode.isStarted()) {
            this.statePublisher.publish(this.currentState);
        }
    }
}

