/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap.visualizer;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.ModifiableMeshDataHolder;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.geometry.SpiralBasedAlgorithm;
import us.ihmc.robotics.linearAlgebra.PrincipalComponentAnalysis3D;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class ReachabilitySphereMapVisualizers {
    public static void visualizeSphereVoxelShape() {
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Dummy"));
        scs.startOnAThread();
        Point3D sphereOrigin = new Point3D(0.0, 0.0, 1.0);
        scs.setCameraFix(sphereOrigin.getX(), sphereOrigin.getY(), sphereOrigin.getZ());
        double voxelSize = 0.1;
        int numberOfRays = 20;
        int numberOfRotationsAroundRay = 10;
        SphereVoxelShape sphereVoxelShape = new SphereVoxelShape(voxelSize, numberOfRays, numberOfRotationsAroundRay, SphereVoxelShape.SphereVoxelType.graspAroundSphere);
        for (int i = 0; i < sphereVoxelShape.getNumberOfRays(); ++i) {
            for (int j = 0; j < sphereVoxelShape.getNumberOfRotationsAroundRay(); ++j) {
                FramePose3D pose = new FramePose3D();
                sphereVoxelShape.getPose((FramePose3DBasics)pose, i, j);
                Graphics3DObject staticLinkGraphics = new Graphics3DObject();
                staticLinkGraphics.translate((Tuple3DReadOnly)sphereOrigin);
                staticLinkGraphics.translate((Tuple3DReadOnly)pose.getPosition());
                staticLinkGraphics.rotate((Orientation3DReadOnly)pose.getOrientation());
                staticLinkGraphics.addCoordinateSystem(0.05);
                scs.addStaticLinkGraphics(staticLinkGraphics);
            }
        }
    }

    public static void visualizePointsOnSphereUsingSpiralBasedAlgorithm() {
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Dummy"));
        scs.startOnAThread();
        Point3D sphereOrigin = new Point3D(0.0, 0.0, 1.0);
        double sphereRadius = 0.1;
        int numberOfPointsToGenerate = 200;
        Point3D[] pointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)sphereOrigin, (double)sphereRadius, (int)numberOfPointsToGenerate);
        Graphics3DObject staticLinkGraphics = new Graphics3DObject();
        staticLinkGraphics.translate((Tuple3DReadOnly)sphereOrigin);
        AppearanceDefinition red = YoAppearance.Red();
        red.setTransparency(0.7);
        staticLinkGraphics.addSphere(sphereRadius, red);
        scs.addStaticLinkGraphics(staticLinkGraphics);
        for (int i = 0; i < numberOfPointsToGenerate; ++i) {
            staticLinkGraphics = new Graphics3DObject();
            staticLinkGraphics.translate((Tuple3DReadOnly)pointsOnSphere[i]);
            staticLinkGraphics.addSphere(0.005);
            scs.addStaticLinkGraphics(staticLinkGraphics);
        }
    }

    public static void visualizeSVDWithPerfectLine() {
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Dummy"));
        scs.startOnAThread();
        Point3D origin = new Point3D(0.0, 0.0, 1.0);
        Vector3D direction = new Vector3D(0.5, 0.2, 0.7);
        ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
        int numberOfPoints = 300;
        for (int i = 0; i < numberOfPoints; ++i) {
            double alpha = (double)i / (double)numberOfPoints;
            Point3D point = new Point3D();
            point.set((Tuple3DReadOnly)direction);
            point.scale(alpha);
            point.add((Tuple3DReadOnly)origin);
            listOfPoints.add(point);
            Graphics3DObject pointViz = new Graphics3DObject();
            pointViz.translate((Tuple3DReadOnly)point);
            pointViz.addSphere(0.01);
            scs.addStaticLinkGraphics(pointViz);
        }
        RotationMatrix rotationMatrix3d = new RotationMatrix();
        Point3D average = new Point3D();
        Vector3D principalValues = new Vector3D();
        PrincipalComponentAnalysis3D principalComponentAnalysis3D = new PrincipalComponentAnalysis3D();
        principalComponentAnalysis3D.setPointCloud(listOfPoints);
        principalComponentAnalysis3D.compute();
        principalComponentAnalysis3D.getPrincipalFrameRotationMatrix(rotationMatrix3d);
        principalComponentAnalysis3D.getVariance(principalValues);
        principalComponentAnalysis3D.getMean(average);
        Graphics3DObject pcaFrame = new Graphics3DObject();
        pcaFrame.translate((Tuple3DReadOnly)average);
        pcaFrame.rotate((Orientation3DReadOnly)rotationMatrix3d);
        pcaFrame.addCoordinateSystem(0.5);
        scs.addStaticLinkGraphics(pcaFrame);
    }

    public static void visualizeSVDWithGaussianPointCloud() {
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Dummy"));
        scs.startOnAThread();
        Random random = new Random(34L);
        Point3D origin = new Point3D(0.0, 0.0, 1.0);
        ArrayList<Point3D> listOfPoints = new ArrayList<Point3D>();
        int numberOfPoints = 10000;
        double radiusX = 0.1;
        double radiusY = 0.3;
        double radiusZ = 0.01;
        RigidBodyTransform transform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
        ModifiableMeshDataHolder modifiableMeshDataHolder = new ModifiableMeshDataHolder();
        for (int i = 0; i < numberOfPoints; ++i) {
            Point3D point = new Point3D();
            point.setX(radiusX * random.nextGaussian());
            point.setY(radiusY * random.nextGaussian());
            point.setZ(radiusZ * random.nextGaussian());
            point.add((Tuple3DReadOnly)origin);
            transform.transform((Point3DBasics)point);
            listOfPoints.add(point);
            MeshDataHolder tetrahedron = MeshDataGenerator.Tetrahedron((double)0.01);
            ReachabilitySphereMapVisualizers.translateMeshVertices(tetrahedron, (Tuple3DReadOnly)point);
            modifiableMeshDataHolder.add(tetrahedron, true);
        }
        Graphics3DObject pointViz = new Graphics3DObject();
        pointViz.addMeshData(modifiableMeshDataHolder.createMeshDataHolder(), YoAppearance.Black());
        scs.addStaticLinkGraphics(pointViz);
        RotationMatrix rotationMatrix3d = new RotationMatrix();
        Point3D average = new Point3D();
        Vector3D principalValues = new Vector3D();
        PrincipalComponentAnalysis3D principalComponentAnalysis3D = new PrincipalComponentAnalysis3D();
        principalComponentAnalysis3D.setPointCloud(listOfPoints);
        principalComponentAnalysis3D.compute();
        principalComponentAnalysis3D.getPrincipalFrameRotationMatrix(rotationMatrix3d);
        principalComponentAnalysis3D.getStandardDeviation(principalValues);
        principalComponentAnalysis3D.getMean(average);
        System.out.println("PrincipalValues: " + String.valueOf(principalValues));
        Graphics3DObject pcaFrame = new Graphics3DObject();
        pcaFrame.translate((Tuple3DReadOnly)average);
        pcaFrame.rotate((Orientation3DReadOnly)rotationMatrix3d);
        pcaFrame.addCoordinateSystem(0.5);
        scs.addStaticLinkGraphics(pcaFrame);
    }

    private static void translateMeshVertices(MeshDataHolder meshToModify, Tuple3DReadOnly offset) {
        Point3D32 offset3f = new Point3D32(offset);
        for (Point3D32 vertex : meshToModify.getVertices()) {
            vertex.add((Tuple3DReadOnly)offset3f);
        }
    }

    public static void testSVDWithSphereVoxel() {
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("Dummy"));
        scs.startOnAThread();
        Point3D sphereOrigin = new Point3D(0.0, 0.0, 1.0);
        Graphics3DObject originViz = new Graphics3DObject();
        originViz.translate((Tuple3DReadOnly)sphereOrigin);
        originViz.addSphere(0.01, YoAppearance.AluminumMaterial());
        scs.addStaticLinkGraphics(originViz);
        double sphereRadius = 0.3;
        int numberOfPointsToGenerate = 1000;
        Point3D[] allPointsOnSphere = SpiralBasedAlgorithm.generatePointsOnSphere((Point3DReadOnly)sphereOrigin, (double)sphereRadius, (int)numberOfPointsToGenerate);
        ArrayList<Point3D> selectedPoints = new ArrayList<Point3D>();
        for (Point3D point : allPointsOnSphere) {
            if (!(point.getX() >= 0.2)) continue;
            selectedPoints.add(point);
        }
        for (Point3D point : selectedPoints) {
            Graphics3DObject pointViz = new Graphics3DObject();
            pointViz.translate((Tuple3DReadOnly)point);
            pointViz.addSphere(0.01);
            scs.addStaticLinkGraphics(pointViz);
        }
        RotationMatrix rotationMatrix = new RotationMatrix();
        Point3D average = new Point3D();
        Vector3D principalValues = new Vector3D();
        PrincipalComponentAnalysis3D principalComponentAnalysis3D = new PrincipalComponentAnalysis3D();
        principalComponentAnalysis3D.setPointCloud(selectedPoints);
        principalComponentAnalysis3D.compute();
        principalComponentAnalysis3D.getPrincipalFrameRotationMatrix(rotationMatrix);
        principalComponentAnalysis3D.getStandardDeviation(principalValues);
        principalComponentAnalysis3D.getMean(average);
        Vector3D sphereOriginToAverage = new Vector3D();
        sphereOriginToAverage.sub((Tuple3DReadOnly)average, (Tuple3DReadOnly)sphereOrigin);
        Vector3D thirdAxis = new Vector3D();
        rotationMatrix.getColumn(2, (Tuple3DBasics)thirdAxis);
        if (sphereOriginToAverage.dot((Tuple3DReadOnly)thirdAxis) < 0.0) {
            RotationMatrix invertThirdAxis = new RotationMatrix();
            invertThirdAxis.setToRollOrientation(Math.PI);
            rotationMatrix.multiply((RotationMatrixReadOnly)invertThirdAxis);
        }
        RigidBodyTransform coneTransform = new RigidBodyTransform();
        coneTransform.getRotation().set((RotationMatrixReadOnly)rotationMatrix);
        coneTransform.getTranslation().set(sphereOrigin.getX(), sphereOrigin.getY(), sphereOrigin.getZ());
        double smallestDotProduct = Double.POSITIVE_INFINITY;
        rotationMatrix.getColumn(2, (Tuple3DBasics)thirdAxis);
        Vector3D testedRay = new Vector3D();
        Vector3D mostOpenedRay = new Vector3D();
        for (Point3D point : selectedPoints) {
            testedRay.sub((Tuple3DReadOnly)point, (Tuple3DReadOnly)sphereOrigin);
            double absDotProduct = Math.abs(testedRay.dot((Tuple3DReadOnly)thirdAxis));
            if (!(absDotProduct < smallestDotProduct)) continue;
            smallestDotProduct = absDotProduct;
            mostOpenedRay.set(testedRay);
        }
        Graphics3DObject coneFrameViz = new Graphics3DObject();
        coneFrameViz.transform((RigidBodyTransformReadOnly)coneTransform);
        coneFrameViz.addCoordinateSystem(0.5);
        scs.addStaticLinkGraphics(coneFrameViz);
        double coneBaseRadius = Math.sqrt(principalValues.getX() * principalValues.getX() + principalValues.getY() * principalValues.getY());
        double coneHeight = mostOpenedRay.dot((Tuple3DReadOnly)thirdAxis);
        Graphics3DObject coneGraphic = new Graphics3DObject();
        coneGraphic.transform((RigidBodyTransformReadOnly)coneTransform);
        coneGraphic.translate(0.0, 0.0, coneHeight);
        coneGraphic.rotate(Math.PI, Axis3D.Y);
        coneGraphic.addCone(coneHeight, coneBaseRadius, YoAppearance.DarkGreen());
        scs.addStaticLinkGraphics(coneGraphic);
    }

    public static void main(String[] args) {
        ReachabilitySphereMapVisualizers.visualizeSVDWithGaussianPointCloud();
    }
}

