/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapMatlabExporter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapSpreadsheetExporter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapTools;
import us.ihmc.avatar.reachabilityMap.ReachabilitySphereMapCalculator;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.SimulationSessionControls;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class ReachabilitySphereMapSimulationHelper {
    private final ReachabilityMapRobotInformation robotInformation;
    private final ReachabilitySphereMapCalculator calculator;
    private final SimulationSession session;
    private final Map<VisualizationType, ObservableList<VisualDefinition>> voxelVisualization = new EnumMap<VisualizationType, ObservableList<VisualDefinition>>(VisualizationType.class);
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final AtomicReference<VisualizationType> previousVisualizationType = new AtomicReference<VisualizationType>(VisualizationType.RayReach);
    private final YoEnum<VisualizationType> currentVisualizationType = new YoEnum("currentVisualizationType", this.registry, VisualizationType.class);
    private SessionVisualizerControls guiControls;

    public ReachabilitySphereMapSimulationHelper(ReachabilityMapRobotInformation robotInformation) {
        this.robotInformation = robotInformation;
        RobotDefinition robotDefinition = robotInformation.getRobotDefinition();
        robotDefinition.ignoreAllJoints();
        this.session = new SimulationSession("Reachability Analysis - " + robotDefinition.getName());
        this.session.initializeBufferSize(16000);
        this.session.getRootRegistry().addChild(this.registry);
        Robot robot = this.session.addRobot(robotDefinition);
        this.calculator = new ReachabilitySphereMapCalculator(robotInformation, robot.getControllerOutput(), 20);
        this.calculator.setVoxel3DGrid(Voxel3DGrid.newVoxel3DGrid(25, 0.05, 50, 1));
        this.calculator.setRobotCollisionModel(robotDefinition);
        robot.addController((Controller)this.calculator);
        this.previousVisualizationType.set(VisualizationType.RayReach);
        this.currentVisualizationType.set((Enum)VisualizationType.RayReach);
    }

    public void enableJointTorqueAnalysis(boolean considerJointTorqueLimits) {
        this.calculator.enableJointTorqueAnalysis(considerJointTorqueLimits);
    }

    public void setEvaluateRReachability(boolean enable) {
        this.calculator.setEvaluateRReachability(enable);
    }

    public void setEvaluateR2Reachability(boolean enable) {
        this.calculator.setEvaluateR2Reachability(enable);
    }

    public void setGridPose(RigidBodyTransformReadOnly pose) {
        this.calculator.getGridFramePose().set(pose);
    }

    public void setGridPosition(double x, double y, double z) {
        this.calculator.getGridFramePose().set(x, y, z, 0.0, 0.0, 0.0);
    }

    public void setGridParameters(int gridSizeInNumberOfVoxels, double voxelSize, int numberOfRays, int numberOfRotationsAroundRay) {
        Voxel3DGrid voxel3DGrid = Voxel3DGrid.newVoxel3DGrid(gridSizeInNumberOfVoxels, voxelSize, numberOfRays, numberOfRotationsAroundRay);
        this.calculator.setVoxel3DGrid(voxel3DGrid);
    }

    public boolean start() {
        this.session.addYoGraphicDefinition(this.calculator.getYoGraphicVisuals());
        this.guiControls = SessionVisualizer.startSessionVisualizer((Session)this.session);
        this.guiControls.waitUntilVisualizerFullyUp();
        this.session.stopSessionThread();
        this.guiControls.setCameraFocusPosition(this.calculator.getGridFramePose().getX(), this.calculator.getGridFramePose().getY(), this.calculator.getGridFramePose().getZ());
        this.guiControls.setCameraOrientation(Math.toRadians(15.0), Math.toRadians(170.0));
        this.setupVisualization();
        SimulationSessionControls simControls = this.session.getSimulationSessionControls();
        BooleanSupplier[] booleanSupplierArray = new BooleanSupplier[1];
        booleanSupplierArray[0] = this.calculator::isDone;
        simControls.addExternalTerminalCondition(booleanSupplierArray);
        simControls.simulateNow();
        this.session.startSessionThread();
        return this.calculator.isDone();
    }

    private void setupVisualization() {
        this.guiControls.addStaticVisuals(ReachabilityMapTools.createReachibilityColorScaleVisuals());
        this.guiControls.addStaticVisuals(ReachabilityMapTools.createBoundingBoxVisuals(this.calculator.getVoxel3DGrid()));
        for (final VisualizationType visualizationType : VisualizationType.values()) {
            ObservableList visualList = FXCollections.observableArrayList();
            visualList.addListener((ListChangeListener)new ListChangeListener<VisualDefinition>(){

                public void onChanged(ListChangeListener.Change<? extends VisualDefinition> change) {
                    if (ReachabilitySphereMapSimulationHelper.this.currentVisualizationType.getValue() != visualizationType) {
                        return;
                    }
                    while (change.next()) {
                        if (change.wasAdded()) {
                            ReachabilitySphereMapSimulationHelper.this.guiControls.addStaticVisuals((Collection)change.getAddedSubList());
                        }
                        if (!change.wasRemoved()) continue;
                        ReachabilitySphereMapSimulationHelper.this.guiControls.removeStaticVisuals((Collection)change.getAddedSubList());
                    }
                }
            });
            this.voxelVisualization.put(visualizationType, (ObservableList<VisualDefinition>)visualList);
        }
        this.calculator.setVoxelUnreachableListener(voxel -> this.voxelVisualization.get((Object)VisualizationType.Unreachable).add((Object)ReachabilityMapTools.createMetricVisual(voxel, 0.1, -1.0)));
        this.calculator.setVoxelCompletedListener(voxel -> {
            this.voxelVisualization.get((Object)VisualizationType.PositionReach).add((Object)ReachabilityMapTools.createPositionReachabilityVisual(voxel, 0.2, true));
            if (voxel.getR() > 0.001) {
                this.voxelVisualization.get((Object)VisualizationType.RayReach).add((Object)ReachabilityMapTools.createMetricVisual(voxel, 0.25, voxel.getR()));
                this.voxelVisualization.get((Object)VisualizationType.PoseReach).add((Object)ReachabilityMapTools.createMetricVisual(voxel, 0.25, voxel.getR2()));
            } else {
                this.voxelVisualization.get((Object)VisualizationType.Unreachable).add((Object)ReachabilityMapTools.createMetricVisual(voxel, 0.1, -1.0));
            }
        });
        this.currentVisualizationType.addListener(v -> {
            this.guiControls.removeStaticVisuals((Collection)this.voxelVisualization.get((Object)this.previousVisualizationType.get()));
            this.guiControls.addStaticVisuals((Collection)this.voxelVisualization.get(this.currentVisualizationType.getValue()));
            this.previousVisualizationType.set((VisualizationType)this.currentVisualizationType.getValue());
        });
    }

    public void exportDataToMatlabFile(Class<?> classForFilePath) throws IOException {
        ReachabilityMapMatlabExporter exporter = new ReachabilityMapMatlabExporter();
        exporter.write(classForFilePath, this.robotInformation, this.calculator.getVoxel3DGrid());
    }

    public void exportDataToSpreadsheetFile(Class<?> classForFilePath) throws IOException {
        ReachabilityMapSpreadsheetExporter exporter = new ReachabilityMapSpreadsheetExporter();
        exporter.write(classForFilePath, this.robotInformation, this.calculator.getVoxel3DGrid());
    }

    public ReachabilitySphereMapCalculator getCalculator() {
        return this.calculator;
    }

    public Voxel3DGrid getVoxel3DGrid() {
        return this.calculator.getVoxel3DGrid();
    }

    public static enum VisualizationType {
        PositionReach,
        RayReach,
        PoseReach,
        WristManipulability,
        Unreachable,
        Nothing;

    }
}

