/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.EigenDecomposition_F64;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapFileReader;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapMatlabImporter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapSpreadsheetImporter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapTools;
import us.ihmc.avatar.reachabilityMap.ReachabilitySphereMapSimulationHelper;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.GravityCoriolisExternalWrenchMatrixCalculator;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.visual.ColorDefinitions;
import us.ihmc.scs2.definition.visual.MaterialDefinition;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.visual.TextureDefinition;
import us.ihmc.scs2.definition.visual.TriangleMesh3DBuilder;
import us.ihmc.scs2.definition.visual.VisualDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicDefinitionFactory;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizer;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerControls;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.simulation.SimulationSession;
import us.ihmc.scs2.simulation.SimulationSessionControls;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class ReachabilityMapVisualizer {
    private static final double bufferGrowthFactor = 1.1;
    private final ReachabilityMapRobotInformation robotInformation;
    private Voxel3DGrid reachabilityMap;
    private boolean visualizePositionReach = true;
    private boolean visualizeRayReach = true;
    private boolean visualizePoseReach = true;
    private Predicate<Voxel3DGrid.Voxel3DData> positionFilter = null;
    private RayPredicate rayFilter = null;
    private PosePredicate poseFilter = null;
    private final YoRegistry registry = new YoRegistry(ReachabilityMapTools.class.getSimpleName());
    private final YoEnum<ReachabilitySphereMapSimulationHelper.VisualizationType> currentEvaluation = new YoEnum("currentEvaluation", this.registry, ReachabilitySphereMapSimulationHelper.VisualizationType.class);
    private final YoFramePose3D currentEvaluationPose = new YoFramePose3D("currentEvaluationPose", SimulationSession.DEFAULT_INERTIAL_FRAME, this.registry);
    private final YoDouble R = new YoDouble("R", this.registry);
    private final YoDouble R2 = new YoDouble("R2", this.registry);
    private final YoDouble singularity = new YoDouble("singularity", this.registry);
    private final YoInteger numberOfRays = new YoInteger("numberOfRays", this.registry);
    private final YoInteger numberOfPoses = new YoInteger("numberOfPoses", this.registry);
    private final YoInteger numberOfReachableRays = new YoInteger("numberOfReachableRays", this.registry);
    private final YoInteger numberOfReachableRotationsAroundRay = new YoInteger("numberOfReachableRotationsAroundRay", this.registry);
    private final YoInteger numberOfReachablePoses = new YoInteger("numberOfReachablePoses", this.registry);
    private SimRigidBodyBasics robotBase;
    private SimRigidBodyBasics robotEndEffector;
    private OneDoFJointBasics[] robotArmJoints;
    private SessionVisualizerControls guiControls;
    private VisualizationControlsStageController controller;
    private GravityCoriolisExternalWrenchMatrixCalculator jointTorquesCalculator;
    private final EigenDecomposition_F64<DMatrixRMaj> eig = DecompositionFactory_DDRM.eig((boolean)false);
    private GeometricJacobianCalculator jacobianCalculator;
    private OneDoFJointBasics[] jointsCopy;
    private ReferenceFrame controlFrameCopy;
    private RigidBodyBasics endEffectorCopy;

    public ReachabilityMapVisualizer(ReachabilityMapRobotInformation robotInformation) {
        this.robotInformation = robotInformation;
    }

    public void setVisualizePositionReach(boolean visualizePositionReach) {
        this.visualizePositionReach = visualizePositionReach;
    }

    public void setVisualizeRayReach(boolean visualizeRayReach) {
        this.visualizeRayReach = visualizeRayReach;
    }

    public void setVisualizePoseReach(boolean visualizePoseReach) {
        this.visualizePoseReach = visualizePoseReach;
    }

    public void setPositionReachVoxelFilter(Predicate<Voxel3DGrid.Voxel3DData> positionReachVoxelFilter) {
        this.positionFilter = positionReachVoxelFilter;
    }

    public void setRayFilter(RayPredicate rayFilter) {
        this.rayFilter = rayFilter;
    }

    public void setPoseFilter(PosePredicate poseFilter) {
        this.poseFilter = poseFilter;
    }

    public boolean loadReachabilityMapFromLatestFile(Class<?> classForFilePath) {
        ReachabilityMapMatlabImporter matlabImporter = new ReachabilityMapMatlabImporter();
        File file = matlabImporter.findLatestFile(classForFilePath, this.robotInformation);
        if (file != null) {
            return this.loadReachabilityMapFromFile(matlabImporter, file);
        }
        ReachabilityMapSpreadsheetImporter spreadSheetImporter = new ReachabilityMapSpreadsheetImporter();
        file = spreadSheetImporter.findLatestFile(classForFilePath, this.robotInformation);
        if (file == null) {
            LogTools.error((String)"Failed to load latest file.");
            return false;
        }
        return this.loadReachabilityMapFromFile(spreadSheetImporter, file);
    }

    public boolean loadReachabilityMapFromFile() {
        ReachabilityMapMatlabImporter importer = new ReachabilityMapMatlabImporter();
        File file = importer.openSelectionFileDialog();
        if (file == null) {
            return false;
        }
        return this.loadReachabilityMapFromFile(importer, file);
    }

    public boolean loadReachabilityMapFromFile(ReachabilityMapFileReader importer, File file) {
        long startTime = System.nanoTime();
        System.out.println("Loading reachability map");
        this.reachabilityMap = importer.read(file, this.robotInformation);
        if (this.reachabilityMap == null) {
            return false;
        }
        System.out.println("Done loading reachability map. Took: " + Conversions.nanosecondsToSeconds((long)(System.nanoTime() - startTime)) + " seconds.");
        return true;
    }

    public void setReachabilityMap(Voxel3DGrid reachabilityMap) {
        this.reachabilityMap = reachabilityMap;
    }

    public void visualize() {
        RobotDefinition robotDefinition = this.robotInformation.getRobotDefinition();
        robotDefinition.ignoreAllJoints();
        SimulationSession session = new SimulationSession(robotDefinition.getName() + " Reachability Map Visualizer");
        SimulationSessionControls sessionControls = session.getSimulationSessionControls();
        session.getRootRegistry().addChild(this.registry);
        Robot robot = session.addRobot(robotDefinition);
        this.robotBase = robot.getRigidBody(this.robotInformation.getBaseName());
        this.robotEndEffector = robot.getRigidBody(this.robotInformation.getEndEffectorName());
        this.robotArmJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)this.robotBase, (RigidBodyBasics)this.robotEndEffector);
        SimRigidBodyBasics endEffector = robot.getRigidBody(this.robotInformation.getEndEffectorName());
        Pose3DReadOnly controlFramePose = this.robotInformation.getControlFramePoseInParentJoint();
        RigidBodyTransform frameTransform = new RigidBodyTransform((Orientation3DReadOnly)controlFramePose.getOrientation(), (Tuple3DReadOnly)controlFramePose.getPosition());
        MovingReferenceFrame parentFrame = endEffector.getParentJoint().getFrameAfterJoint();
        ReferenceFrame controlFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"controlFrame", (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)frameTransform);
        this.guiControls = SessionVisualizer.startSessionVisualizer((Session)session);
        this.guiControls.waitUntilVisualizerFullyUp();
        session.stopSessionThread();
        this.guiControls.addStaticVisuals(ReachabilityMapTools.createReachibilityColorScaleVisuals());
        this.guiControls.addYoGraphic((YoGraphicDefinition)YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)"currentEvaluationPose", (YoFramePose3D)this.currentEvaluationPose, (double)0.15, (PaintDefinition)ColorDefinitions.HotPink()));
        this.guiControls.addYoGraphic((YoGraphicDefinition)YoGraphicDefinitionFactory.newYoGraphicCoordinateSystem3D((String)"controlFrame", (FramePose3DReadOnly)new FramePose3D(controlFrame), (double)0.05, (PaintDefinition)ColorDefinitions.parse((String)"#A1887F")));
        this.createVisualizationControls();
        LogTools.info((String)"Done generating visuals");
        if (this.visualizePositionReach) {
            LogTools.info((String)"Start exploring position reach");
            this.visualizePositionReach(session, controlFrame);
            LogTools.info((String)"Done exploring position reach");
        }
        if (this.visualizeRayReach) {
            LogTools.info((String)"Start exploring ray reach");
            this.visualizeRayReach(session);
            LogTools.info((String)"Done exploring ray reach");
        }
        if (this.visualizePoseReach) {
            LogTools.info((String)"Start exploring ray reach");
            this.visualizePoseReach(session);
            LogTools.info((String)"Done exploring ray reach");
        }
        LogTools.info((String)"Cropping buffer");
        sessionControls.cropBuffer();
        LogTools.info((String)"Restarting session's thread");
        session.startSessionThread();
        LogTools.info((String)"Done");
    }

    public SessionVisualizerControls getGuiControls() {
        return this.guiControls;
    }

    private void createVisualizationControls() {
        URL resource = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/ReachabilityMapVisualizationControlsStage.fxml");
        FXMLLoader fxmlLoader = new FXMLLoader(resource);
        this.controller = new VisualizationControlsStageController();
        fxmlLoader.setController((Object)this.controller);
        CountDownLatch latch = new CountDownLatch(1);
        Platform.runLater(() -> {
            try {
                this.guiControls.addCustomGUIPane("Reachability map", (Pane)fxmlLoader.load());
                this.controller.initialize();
                latch.countDown();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void visualizePositionReach(SimulationSession session, ReferenceFrame controlFrame) {
        this.currentEvaluation.set((Enum)ReachabilitySphereMapSimulationHelper.VisualizationType.PositionReach);
        for (int voxelIndex = 0; voxelIndex < this.reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.VoxelExtraData positionExtraData;
            Voxel3DGrid.Voxel3DData voxel = this.reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || this.positionFilter != null && !this.positionFilter.test(voxel) || (positionExtraData = voxel.getPositionExtraData()) == null) continue;
            this.singularity.set(this.computeFullJacobianSingularityMetric(voxel.getPositionExtraData()));
            ReachabilityMapVisualizer.writeVoxelJointData(positionExtraData, this.robotArmJoints);
            this.currentEvaluationPose.getPosition().set((Tuple3DReadOnly)positionExtraData.getDesiredPosition());
            this.currentEvaluationPose.getOrientation().setFromReferenceFrame(controlFrame);
            this.simulationStep(session);
        }
    }

    public void visualizeRayReach(SimulationSession session) {
        SphereVoxelShape sphereVoxelShape = this.reachabilityMap.getSphereVoxelShape();
        this.currentEvaluation.set((Enum)ReachabilitySphereMapSimulationHelper.VisualizationType.RayReach);
        ArrayList<Voxel3DGrid.VoxelExtraData> filteredRayExtraDataList = new ArrayList<Voxel3DGrid.VoxelExtraData>();
        for (int voxelIndex = 0; voxelIndex < this.reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.VoxelExtraData positionExtraData;
            Voxel3DGrid.Voxel3DData voxel = this.reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || this.positionFilter != null && !this.positionFilter.test(voxel) || (positionExtraData = voxel.getPositionExtraData()) == null) continue;
            filteredRayExtraDataList.clear();
            this.numberOfRays.set(0);
            this.numberOfReachableRays.set(0);
            for (int rayIndex = 0; rayIndex < sphereVoxelShape.getNumberOfRays(); ++rayIndex) {
                if (this.rayFilter != null && this.rayFilter.test(sphereVoxelShape, rayIndex)) continue;
                this.numberOfRays.increment();
                Voxel3DGrid.VoxelExtraData rayExtraData = voxel.getRayExtraData(rayIndex);
                if (rayExtraData == null) continue;
                filteredRayExtraDataList.add(rayExtraData);
                this.numberOfReachableRays.increment();
            }
            this.R.set(this.numberOfReachableRays.getValueAsDouble() / this.numberOfRays.getValueAsDouble());
            for (Voxel3DGrid.VoxelExtraData rayExtraData : filteredRayExtraDataList) {
                this.singularity.set(this.computeFullJacobianSingularityMetric(rayExtraData));
                ReachabilityMapVisualizer.writeVoxelJointData(rayExtraData, this.robotArmJoints);
                this.currentEvaluationPose.getPosition().set((Tuple3DReadOnly)rayExtraData.getDesiredPosition());
                this.currentEvaluationPose.getOrientation().set((QuaternionReadOnly)rayExtraData.getDesiredOrientation());
                this.simulationStep(session);
            }
        }
    }

    public void visualizePoseReach(SimulationSession session) {
        SphereVoxelShape sphereVoxelShape = this.reachabilityMap.getSphereVoxelShape();
        this.currentEvaluation.set((Enum)ReachabilitySphereMapSimulationHelper.VisualizationType.PoseReach);
        for (int voxelIndex = 0; voxelIndex < this.reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            ArrayList<Voxel3DGrid.VoxelExtraData> filteredPoseExtraDataList;
            int rayIndex;
            Voxel3DGrid.VoxelExtraData positionExtraData;
            Voxel3DGrid.Voxel3DData voxel = this.reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || (positionExtraData = voxel.getPositionExtraData()) == null) continue;
            ArrayList<ArrayList<Voxel3DGrid.VoxelExtraData>> filteredPoseExtraData2DList = new ArrayList<ArrayList<Voxel3DGrid.VoxelExtraData>>();
            TIntArrayList reachableRotationsList = new TIntArrayList();
            this.numberOfRays.set(0);
            this.numberOfPoses.set(0);
            for (rayIndex = 0; rayIndex < sphereVoxelShape.getNumberOfRays(); ++rayIndex) {
                if (this.rayFilter != null && this.rayFilter.test(sphereVoxelShape, rayIndex)) continue;
                filteredPoseExtraDataList = null;
                boolean hasIncrementedNumberOfRays = false;
                boolean hasIncrementedNumberOfReachableRays = false;
                int numberOfReachableRotations = 0;
                for (int rotationIndex = 0; rotationIndex < sphereVoxelShape.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                    if (this.poseFilter != null && !this.poseFilter.test(sphereVoxelShape, rayIndex, rotationIndex)) continue;
                    if (!hasIncrementedNumberOfRays) {
                        this.numberOfRays.increment();
                        hasIncrementedNumberOfRays = true;
                    }
                    this.numberOfPoses.increment();
                    Voxel3DGrid.VoxelExtraData poseExtraData = voxel.getPoseExtraData(rayIndex, rotationIndex);
                    if (poseExtraData == null) continue;
                    if (filteredPoseExtraDataList == null) {
                        filteredPoseExtraDataList = new ArrayList<Voxel3DGrid.VoxelExtraData>();
                    }
                    filteredPoseExtraDataList.add(poseExtraData);
                    ++numberOfReachableRotations;
                    if (!hasIncrementedNumberOfReachableRays) {
                        this.numberOfReachableRays.increment();
                        hasIncrementedNumberOfReachableRays = true;
                    }
                    this.numberOfReachablePoses.increment();
                }
                if (filteredPoseExtraDataList == null) continue;
                filteredPoseExtraData2DList.add(filteredPoseExtraDataList);
                reachableRotationsList.add(numberOfReachableRotations);
            }
            this.R2.set(this.numberOfReachablePoses.getValueAsDouble() / this.numberOfReachablePoses.getValueAsDouble());
            for (rayIndex = 0; rayIndex < filteredPoseExtraData2DList.size(); ++rayIndex) {
                filteredPoseExtraDataList = (ArrayList<Voxel3DGrid.VoxelExtraData>)filteredPoseExtraData2DList.get(rayIndex);
                this.numberOfReachableRotationsAroundRay.set(reachableRotationsList.get(rayIndex));
                for (Voxel3DGrid.VoxelExtraData poseExtraData : filteredPoseExtraDataList) {
                    this.singularity.set(this.computeFullJacobianSingularityMetric(poseExtraData));
                    ReachabilityMapVisualizer.writeVoxelJointData(poseExtraData, this.robotArmJoints);
                    this.currentEvaluationPose.getPosition().set((Tuple3DReadOnly)poseExtraData.getDesiredPosition());
                    this.currentEvaluationPose.getOrientation().set((QuaternionReadOnly)poseExtraData.getDesiredOrientation());
                    this.simulationStep(session);
                }
            }
        }
    }

    private void simulationStep(SimulationSession session) {
        YoBufferPropertiesReadOnly bufferProperties = session.getBufferProperties();
        session.getSimulationSessionControls().simulateNow(1L);
        if (bufferProperties.getActiveBufferLength() >= bufferProperties.getSize() - 1) {
            session.submitBufferSizeRequestAndWait(Integer.valueOf((int)(1.1 * (double)bufferProperties.getSize())));
        }
    }

    public static void writeVoxelJointData(Voxel3DGrid.VoxelExtraData voxelExtraData, OneDoFJointBasics[] robotArmJoints) {
        DMatrixRMaj jointPositions = ReachabilityMapVisualizer.toVectorMatrix(voxelExtraData.getJointPositions());
        DMatrixRMaj jointTorques = ReachabilityMapVisualizer.toVectorMatrix(voxelExtraData.getJointTorques());
        int positionIndex = 0;
        int torqueIndex = 0;
        for (OneDoFJointBasics joint : robotArmJoints) {
            positionIndex = joint.setJointConfiguration(positionIndex, (DMatrix)jointPositions);
            torqueIndex = joint.setJointTau(torqueIndex, (DMatrix)jointTorques);
            joint.updateFrame();
        }
    }

    public static DMatrixRMaj toVectorMatrix(float[] array) {
        DMatrixRMaj vector = new DMatrixRMaj(array.length, 1);
        for (int i = 0; i < array.length; ++i) {
            vector.set(i, (double)array[i]);
        }
        return vector;
    }

    public static RayPredicate newHemisphereFilter(final Vector3DReadOnly filteringRayDirection) {
        final Vector3D ray = new Vector3D();
        return new RayPredicate(){

            @Override
            public boolean test(SphereVoxelShape sphereVoxelShape, int rayIndex) {
                sphereVoxelShape.getRay(ray, rayIndex);
                return ray.dot((Tuple3DReadOnly)filteringRayDirection) < 0.0;
            }
        };
    }

    public double evaluateRayVoxelExtraData(Voxel3DGrid.Voxel3DData voxel, ToDoubleFunction<Voxel3DGrid.VoxelExtraData> jointPositionFunction) {
        double s = 0.0;
        for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
            if (!voxel.isRayReachable(rayIndex) || !this.isWithinLimits(voxel.getRayExtraData(rayIndex))) continue;
            s += jointPositionFunction.applyAsDouble(voxel.getRayExtraData(rayIndex));
        }
        return s / (double)voxel.getNumberOfReachableRays();
    }

    public double evaluatePoseVoxelExtraData(Voxel3DGrid.Voxel3DData voxel, ToDoubleFunction<Voxel3DGrid.VoxelExtraData> jointPositionFunction) {
        double s = 0.0;
        for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
            for (int rotationIndex = 0; rotationIndex < voxel.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                if (!voxel.isPoseReachable(rayIndex, rotationIndex) || !this.isWithinLimits(voxel.getPoseExtraData(rayIndex, rotationIndex))) continue;
                s += jointPositionFunction.applyAsDouble(voxel.getPoseExtraData(rayIndex, rotationIndex));
            }
        }
        return s / (double)voxel.getNumberOfReachablePoses();
    }

    public double computeRoMMetric(Voxel3DGrid.VoxelExtraData extraData) {
        if (extraData == null || !this.isWithinLimits(extraData)) {
            return 0.0;
        }
        this.ensureJointsCopyExist();
        double l = 0.0;
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            double min = this.jointsCopy[i].getJointLimitLower();
            double max = this.jointsCopy[i].getJointLimitUpper();
            double midRange = 0.5 * (min + max);
            double rom = max - min;
            double q = MathTools.clamp((double)extraData.getJointPositions()[i], (double)min, (double)max);
            double ratio = (q - midRange) / rom;
            l += ratio * ratio;
        }
        return 1.0 - 4.0 / (double)this.jointsCopy.length * l;
    }

    public double computeTauCapabilityMetric(Voxel3DGrid.VoxelExtraData extraData, double payloadInKg) {
        if (extraData == null || !this.isWithinLimits(extraData)) {
            return 0.0;
        }
        if (payloadInKg == 0.0 && extraData.getJointTorques() != null) {
            return this.computeTauCapabilityMetric(extraData.getJointTorques());
        }
        this.ensureJointsCopyExist();
        double gravity = -9.81;
        if (this.jointTorquesCalculator == null) {
            this.jointTorquesCalculator = new GravityCoriolisExternalWrenchMatrixCalculator((RigidBodyReadOnly)MultiBodySystemTools.getRootBody((RigidBodyBasics)this.jointsCopy[0].getPredecessor()));
            this.jointTorquesCalculator.setGravitionalAcceleration(gravity);
        }
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            this.jointsCopy[i].setQ((double)extraData.getJointPositions()[i]);
            this.jointsCopy[i].updateFrame();
        }
        Wrench payloadWrench = new Wrench((ReferenceFrame)this.endEffectorCopy.getBodyFixedFrame(), this.controlFrameCopy);
        payloadWrench.getLinearPart().setMatchingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)new Vector3D(0.0, 0.0, gravity * payloadInKg));
        this.jointTorquesCalculator.getExternalWrench((RigidBodyReadOnly)this.endEffectorCopy).setMatchingFrame((WrenchReadOnly)payloadWrench);
        this.jointTorquesCalculator.compute();
        float[] jointTorques = new float[this.jointsCopy.length];
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            OneDoFJointBasics joint = this.jointsCopy[i];
            double tau = this.jointTorquesCalculator.getComputedJointTau((JointReadOnly)joint).get(0);
            if (!MathTools.intervalContains((double)tau, (double)joint.getEffortLimitLower(), (double)joint.getEffortLimitUpper())) {
                return 0.0;
            }
            jointTorques[i] = (float)tau;
        }
        return this.computeTauCapabilityMetric(jointTorques);
    }

    public double computeTauCapabilityMetric(float[] jointTorques) {
        this.ensureJointsCopyExist();
        double l = 0.0;
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            double min = this.jointsCopy[i].getEffortLimitLower();
            double max = this.jointsCopy[i].getEffortLimitUpper();
            double midRange = 0.5 * (min + max);
            double rom = max - min;
            double tau = MathTools.clamp((double)jointTorques[i], (double)min, (double)max);
            double ratio = (tau - midRange) / rom;
            l += ratio * ratio;
        }
        return 1.0 - 4.0 / (double)this.jointsCopy.length * l;
    }

    public double computeFullJacobianSingularityMetric(Voxel3DGrid.VoxelExtraData extraData) {
        if (extraData == null || !this.isWithinLimits(extraData)) {
            return 0.0;
        }
        DMatrixRMaj jacobian = this.computeJacobian(extraData.getJointPositions());
        DMatrixRMaj outer = new DMatrixRMaj(6, 6);
        CommonOps_DDRM.multOuter((DMatrix1Row)jacobian, (DMatrix1Row)outer);
        if (!this.eig.decompose((Matrix)outer)) {
            return 0.0;
        }
        double min = this.eig.getEigenvalue(0).getReal();
        double max = this.eig.getEigenvalue(0).getReal();
        for (int i = 1; i < this.eig.getNumberOfEigenvalues(); ++i) {
            min = Math.min(min, this.eig.getEigenvalue(i).getReal());
            max = Math.max(max, this.eig.getEigenvalue(i).getReal());
        }
        return min / max;
    }

    public double computeLinearJacobianSingularityMetric(Voxel3DGrid.VoxelExtraData extraData) {
        if (extraData == null || !this.isWithinLimits(extraData)) {
            return 0.0;
        }
        DMatrixRMaj jacobian = this.computeJacobian(extraData.getJointPositions());
        DMatrixRMaj linearPart = new DMatrixRMaj(3, jacobian.numCols);
        CommonOps_DDRM.extract((DMatrix)jacobian, (int)3, (int)6, (int)0, (int)jacobian.numCols, (DMatrix)linearPart, (int)0, (int)0);
        DMatrixRMaj outer = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multOuter((DMatrix1Row)linearPart, (DMatrix1Row)outer);
        if (!this.eig.decompose((Matrix)outer)) {
            return 0.0;
        }
        double min = this.eig.getEigenvalue(0).getReal();
        double max = this.eig.getEigenvalue(0).getReal();
        for (int i = 1; i < this.eig.getNumberOfEigenvalues(); ++i) {
            min = Math.min(min, this.eig.getEigenvalue(i).getReal());
            max = Math.max(max, this.eig.getEigenvalue(i).getReal());
        }
        return min / max;
    }

    public double computeAngularJacobianSingularityMetric(Voxel3DGrid.VoxelExtraData extraData) {
        if (extraData == null || !this.isWithinLimits(extraData)) {
            return 0.0;
        }
        DMatrixRMaj jacobian = this.computeJacobian(extraData.getJointPositions());
        DMatrixRMaj angularPart = new DMatrixRMaj(3, jacobian.numCols);
        CommonOps_DDRM.extract((DMatrix)jacobian, (int)0, (int)3, (int)0, (int)jacobian.numCols, (DMatrix)angularPart, (int)0, (int)0);
        DMatrixRMaj outer = new DMatrixRMaj(3, 3);
        CommonOps_DDRM.multOuter((DMatrix1Row)angularPart, (DMatrix1Row)outer);
        if (!this.eig.decompose((Matrix)outer)) {
            return 0.0;
        }
        double min = this.eig.getEigenvalue(0).getReal();
        double max = this.eig.getEigenvalue(0).getReal();
        for (int i = 1; i < this.eig.getNumberOfEigenvalues(); ++i) {
            min = Math.min(min, this.eig.getEigenvalue(i).getReal());
            max = Math.max(max, this.eig.getEigenvalue(i).getReal());
        }
        return min / max;
    }

    private DMatrixRMaj computeJacobian(float[] jointPositions) {
        this.ensureJointsCopyExist();
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            this.jointsCopy[i].setQ((double)jointPositions[i]);
            this.jointsCopy[i].updateFrame();
        }
        if (this.jacobianCalculator == null) {
            this.jacobianCalculator = new GeometricJacobianCalculator();
        }
        this.jacobianCalculator.setKinematicChain((JointReadOnly[])this.jointsCopy);
        this.jacobianCalculator.setJacobianFrame(this.controlFrameCopy);
        return this.jacobianCalculator.getJacobianMatrix();
    }

    public boolean isWithinLimits(Voxel3DGrid.VoxelExtraData extraData) {
        this.ensureJointsCopyExist();
        for (int i = 0; i < this.jointsCopy.length; ++i) {
            OneDoFJointBasics joint;
            double q = extraData.getJointPositions()[i];
            if (MathTools.intervalContains((double)q, (double)((joint = this.jointsCopy[i]).getJointLimitLower() - 1.0E-7), (double)(joint.getJointLimitUpper() + 1.0E-7))) continue;
            return false;
        }
        return true;
    }

    public void ensureJointsCopyExist() {
        if (this.jointsCopy == null) {
            RigidBodyBasics rootBodyCopy = this.robotInformation.getRobotDefinition().newInstance(ReferenceFrame.getWorldFrame());
            RigidBodyBasics baseCopy = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBodyCopy, (String)this.robotInformation.getBaseName());
            this.endEffectorCopy = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBodyCopy, (String)this.robotInformation.getEndEffectorName());
            this.jointsCopy = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)baseCopy, (RigidBodyBasics)this.endEffectorCopy);
            this.controlFrameCopy = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"controlFrameCopy", (ReferenceFrame)this.endEffectorCopy.getParentJoint().getFrameAfterJoint(), (RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)this.robotInformation.getControlFramePoseInParentJoint().getOrientation(), (Tuple3DReadOnly)this.robotInformation.getControlFramePoseInParentJoint().getPosition()));
        }
    }

    public static interface RayPredicate {
        public boolean test(SphereVoxelShape var1, int var2);
    }

    public static interface PosePredicate {
        public boolean test(SphereVoxelShape var1, int var2, int var3);
    }

    private class VisualizationControlsStageController {
        private static final String Reach = "Reach";
        private static final String NeighborhoodDexterity6 = "Neighborhood Dexterity 6";
        private static final String NeighborhoodDexterity18 = "Neighborhood Dexterity 18";
        private static final String NeighborhoodDexterity26 = "Neighborhood Dexterity 26";
        private static final String FullSingularity = "Full Singularity";
        private static final String LinearSingularity = "Linear Singularity";
        private static final String AngularSingularity = "Angular Singularity";
        private static final String RangeOfMotion = "Range of Motion";
        private static final String TauCapability = "Tau Capability";
        private static final String PositionTarget = "Position";
        private static final String RayTarget = "Ray";
        private static final String PoseTarget = "Pose";
        @FXML
        private VBox mainPane;
        @FXML
        private VBox extraControlsContainer;
        @FXML
        private ComboBox<String> visualizationTypeComboBox;
        @FXML
        private ComboBox<String> visualizationTargetComboBox;
        @FXML
        private ToggleButton normalizeDataToggleButton;
        @FXML
        private ToggleButton heatmapToggleButton;
        @FXML
        private Spinner<Double> xMinSpinner;
        @FXML
        private Spinner<Double> xMaxSpinner;
        @FXML
        private Spinner<Double> yMinSpinner;
        @FXML
        private Spinner<Double> yMaxSpinner;
        @FXML
        private Spinner<Double> zMinSpinner;
        @FXML
        private Spinner<Double> zMaxSpinner;
        @FXML
        private Spinner<Double> scaleSpinner;
        @FXML
        private Spinner<Double> payloadSpinner;
        @FXML
        private Label jointLabel0;
        @FXML
        private Label jointLabel1;
        @FXML
        private Label jointLabel2;
        @FXML
        private Label jointLabel3;
        @FXML
        private Label jointLabel4;
        @FXML
        private Label jointLabel5;
        @FXML
        private Label jointLabel6;
        @FXML
        private TextField jointQMinText0;
        @FXML
        private TextField jointQMinText1;
        @FXML
        private TextField jointQMinText2;
        @FXML
        private TextField jointQMinText3;
        @FXML
        private TextField jointQMinText4;
        @FXML
        private TextField jointQMinText5;
        @FXML
        private TextField jointQMinText6;
        @FXML
        private TextField jointQMaxText0;
        @FXML
        private TextField jointQMaxText1;
        @FXML
        private TextField jointQMaxText2;
        @FXML
        private TextField jointQMaxText3;
        @FXML
        private TextField jointQMaxText4;
        @FXML
        private TextField jointQMaxText5;
        @FXML
        private TextField jointQMaxText6;
        @FXML
        private TextField jointTauMaxText0;
        @FXML
        private TextField jointTauMaxText1;
        @FXML
        private TextField jointTauMaxText2;
        @FXML
        private TextField jointTauMaxText3;
        @FXML
        private TextField jointTauMaxText4;
        @FXML
        private TextField jointTauMaxText5;
        @FXML
        private TextField jointTauMaxText6;
        private List<VisualDefinition> previousVisuals;
        private List<VisualDefinition> previousReachabilityMapBBXVisuals;

        private VisualizationControlsStageController() {
        }

        public void initialize() {
            this.visualizationTypeComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{Reach, NeighborhoodDexterity6, NeighborhoodDexterity18, NeighborhoodDexterity26, FullSingularity, LinearSingularity, AngularSingularity, RangeOfMotion, TauCapability}));
            this.visualizationTypeComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> this.payloadSpinner.setDisable(!TauCapability.equals(newValue)));
            this.visualizationTargetComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{PositionTarget, RayTarget, PoseTarget}));
            this.visualizationTargetComboBox.getSelectionModel().select((Object)RayTarget);
            FramePoint3D minPoint = ReachabilityMapVisualizer.this.reachabilityMap.getMinPoint();
            FramePoint3D maxPoint = ReachabilityMapVisualizer.this.reachabilityMap.getMaxPoint();
            this.xMinSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getX(), maxPoint.getX(), minPoint.getX(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.xMaxSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getX(), maxPoint.getX(), maxPoint.getX(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.yMinSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getY(), maxPoint.getY(), minPoint.getY(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.yMaxSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getY(), maxPoint.getY(), maxPoint.getY(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.zMinSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getZ(), maxPoint.getZ(), minPoint.getZ(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.zMaxSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(minPoint.getZ(), maxPoint.getZ(), maxPoint.getZ(), ReachabilityMapVisualizer.this.reachabilityMap.getVoxelSize()));
            this.scaleSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.05, 1.0, 0.2, 0.05));
            this.payloadSpinner.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 150.0, 0.0, 0.25));
            Label[] jointLabels = new Label[]{this.jointLabel0, this.jointLabel1, this.jointLabel2, this.jointLabel3, this.jointLabel4, this.jointLabel5, this.jointLabel6};
            TextField[] jointQMinTexts = new TextField[]{this.jointQMinText0, this.jointQMinText1, this.jointQMinText2, this.jointQMinText3, this.jointQMinText4, this.jointQMinText5, this.jointQMinText6};
            TextField[] jointQMaxTexts = new TextField[]{this.jointQMaxText0, this.jointQMaxText1, this.jointQMaxText2, this.jointQMaxText3, this.jointQMaxText4, this.jointQMaxText5, this.jointQMaxText6};
            TextField[] jointTauMaxTexts = new TextField[]{this.jointTauMaxText0, this.jointTauMaxText1, this.jointTauMaxText2, this.jointTauMaxText3, this.jointTauMaxText4, this.jointTauMaxText5, this.jointTauMaxText6};
            ReachabilityMapVisualizer.this.ensureJointsCopyExist();
            for (int i = 0; i < Math.min(7, ReachabilityMapVisualizer.this.jointsCopy.length); ++i) {
                OneDoFJointBasics joint = ReachabilityMapVisualizer.this.jointsCopy[i];
                jointLabels[i].setText(joint.getName());
                TextFormatter qminFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
                TextFormatter qmaxFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
                TextFormatter taumaxFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
                jointQMinTexts[i].setTextFormatter(qminFormatter);
                jointQMaxTexts[i].setTextFormatter(qmaxFormatter);
                jointTauMaxTexts[i].setTextFormatter(taumaxFormatter);
                qminFormatter.setValue((Object)joint.getJointLimitLower());
                qmaxFormatter.setValue((Object)joint.getJointLimitUpper());
                taumaxFormatter.setValue((Object)joint.getEffortLimitUpper());
                qminFormatter.valueProperty().addListener((o, oldValue, newValue) -> joint.setJointLimitLower(newValue.doubleValue()));
                qmaxFormatter.valueProperty().addListener((o, oldValue, newValue) -> joint.setJointLimitUpper(newValue.doubleValue()));
                taumaxFormatter.valueProperty().addListener((o, oldValue, newValue) -> joint.setEffortLimit(newValue.doubleValue()));
            }
        }

        @FXML
        private void refreshVisualization() {
            String selectedType = (String)this.visualizationTypeComboBox.getSelectionModel().getSelectedItem();
            String selectedTarget = (String)this.visualizationTargetComboBox.getSelectionModel().getSelectedItem();
            boolean normalize = this.normalizeDataToggleButton.isSelected();
            BoundingBox3D bbx = new BoundingBox3D(((Double)this.xMinSpinner.getValue()).doubleValue(), ((Double)this.yMinSpinner.getValue()).doubleValue(), ((Double)this.zMinSpinner.getValue()).doubleValue(), ((Double)this.xMaxSpinner.getValue()).doubleValue(), ((Double)this.yMaxSpinner.getValue()).doubleValue(), ((Double)this.zMaxSpinner.getValue()).doubleValue());
            List<VisualDefinition> visuals = null;
            if (selectedType != null) {
                if (!this.heatmapToggleButton.isSelected()) {
                    if (selectedType.equals(Reach)) {
                        visuals = this.generateReachVisuals(selectedTarget, normalize, bbx);
                    } else if (selectedType.equals(NeighborhoodDexterity6)) {
                        visuals = this.generateMetricVisual(normalize, bbx, Voxel3DGrid.Voxel3DData::computeD06);
                    } else if (selectedType.equals(NeighborhoodDexterity18)) {
                        visuals = this.generateMetricVisual(normalize, bbx, Voxel3DGrid.Voxel3DData::computeD018);
                    } else if (selectedType.equals(NeighborhoodDexterity26)) {
                        visuals = this.generateMetricVisual(normalize, bbx, Voxel3DGrid.Voxel3DData::computeD026);
                    } else if (selectedType.equals(FullSingularity)) {
                        visuals = this.generateMetricVisual(selectedTarget, normalize, bbx, ReachabilityMapVisualizer.this::computeFullJacobianSingularityMetric);
                    } else if (selectedType.equals(LinearSingularity)) {
                        visuals = this.generateMetricVisual(selectedTarget, normalize, bbx, ReachabilityMapVisualizer.this::computeLinearJacobianSingularityMetric);
                    } else if (selectedType.equals(AngularSingularity)) {
                        visuals = this.generateMetricVisual(selectedTarget, normalize, bbx, ReachabilityMapVisualizer.this::computeAngularJacobianSingularityMetric);
                    } else if (selectedType.equals(RangeOfMotion)) {
                        visuals = this.generateMetricVisual(selectedTarget, normalize, bbx, ReachabilityMapVisualizer.this::computeRoMMetric);
                    } else if (selectedType.equals(TauCapability)) {
                        visuals = this.generateMetricVisual(selectedTarget, normalize, bbx, extraData -> ReachabilityMapVisualizer.this.computeTauCapabilityMetric((Voxel3DGrid.VoxelExtraData)extraData, (Double)this.payloadSpinner.getValue()));
                    }
                } else {
                    RayIndexBasedVoxelQualityMetric qualityMetric = null;
                    if (selectedType.equals(Reach)) {
                        qualityMetric = this.getReachHeatMapMetric(selectedTarget);
                    } else if (selectedType.equals(FullSingularity)) {
                        qualityMetric = this.getVoxelExtraDataBasedMetric(selectedTarget, ReachabilityMapVisualizer.this::computeFullJacobianSingularityMetric);
                    } else if (selectedType.equals(LinearSingularity)) {
                        qualityMetric = this.getVoxelExtraDataBasedMetric(selectedTarget, ReachabilityMapVisualizer.this::computeLinearJacobianSingularityMetric);
                    } else if (selectedType.equals(AngularSingularity)) {
                        qualityMetric = this.getVoxelExtraDataBasedMetric(selectedTarget, ReachabilityMapVisualizer.this::computeAngularJacobianSingularityMetric);
                    } else if (selectedType.equals(RangeOfMotion)) {
                        qualityMetric = this.getVoxelExtraDataBasedMetric(selectedTarget, ReachabilityMapVisualizer.this::computeRoMMetric);
                    } else if (selectedType.equals(TauCapability)) {
                        qualityMetric = this.getVoxelExtraDataBasedMetric(selectedTarget, extraData -> ReachabilityMapVisualizer.this.computeTauCapabilityMetric((Voxel3DGrid.VoxelExtraData)extraData, (Double)this.payloadSpinner.getValue()));
                    }
                    visuals = this.generateMetricRayBasedHeatMapVisuals(normalize, qualityMetric, bbx);
                }
            }
            if (this.previousVisuals != null) {
                ReachabilityMapVisualizer.this.guiControls.removeStaticVisuals(this.previousVisuals);
            }
            ReachabilityMapVisualizer.this.guiControls.addStaticVisuals(visuals);
            if (this.previousReachabilityMapBBXVisuals != null) {
                ReachabilityMapVisualizer.this.guiControls.removeStaticVisuals(this.previousReachabilityMapBBXVisuals);
            }
            List<VisualDefinition> reachabilityMapBBXVisuals = this.generateMapBBX(bbx);
            ReachabilityMapVisualizer.this.guiControls.addStaticVisuals(reachabilityMapBBXVisuals);
            this.previousReachabilityMapBBXVisuals = reachabilityMapBBXVisuals;
            this.previousVisuals = visuals;
        }

        private List<VisualDefinition> generateMapBBX(BoundingBox3D bbx) {
            PoseReferenceFrame referenceFrame = ReachabilityMapVisualizer.this.reachabilityMap.getReferenceFrame();
            return ReachabilityMapTools.createBoundingBoxVisuals((FramePoint3DReadOnly)new FramePoint3D((ReferenceFrame)referenceFrame, (Tuple3DReadOnly)bbx.getMinPoint()), (FramePoint3DReadOnly)new FramePoint3D((ReferenceFrame)referenceFrame, (Tuple3DReadOnly)bbx.getMaxPoint()));
        }

        public List<VisualDefinition> generateReachVisuals(String target, boolean normalizeMetric, BoundingBox3D bbx) {
            switch (target) {
                case "Position": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> 1.0);
                }
                case "Ray": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> {
                        int n = 0;
                        for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
                            if (!voxel.isRayReachable(rayIndex) || !ReachabilityMapVisualizer.this.isWithinLimits(voxel.getRayExtraData(rayIndex))) continue;
                            ++n;
                        }
                        return (double)n / (double)voxel.getNumberOfRays();
                    });
                }
                case "Pose": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> {
                        int n = 0;
                        for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
                            for (int rotationIndex = 0; rotationIndex < voxel.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                                if (!voxel.isPoseReachable(rayIndex, rotationIndex) || !ReachabilityMapVisualizer.this.isWithinLimits(voxel.getPoseExtraData(rayIndex, rotationIndex))) continue;
                                ++n;
                            }
                        }
                        return (double)n / (double)voxel.getNumberOfRays() / (double)voxel.getNumberOfRotationsAroundRay();
                    });
                }
            }
            return null;
        }

        private List<VisualDefinition> generateMetricVisual(String target, boolean normalizeMetric, BoundingBox3D bbx, ToDoubleFunction<Voxel3DGrid.VoxelExtraData> metricFunction) {
            switch (target) {
                case "Position": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> metricFunction.applyAsDouble(voxel.getPositionExtraData()));
                }
                case "Ray": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> ReachabilityMapVisualizer.this.evaluateRayVoxelExtraData((Voxel3DGrid.Voxel3DData)voxel, metricFunction));
                }
                case "Pose": {
                    return this.generateMetricVisual(normalizeMetric, bbx, voxel -> ReachabilityMapVisualizer.this.evaluatePoseVoxelExtraData((Voxel3DGrid.Voxel3DData)voxel, metricFunction));
                }
            }
            return null;
        }

        private List<VisualDefinition> generateMetricVisual(boolean normalizeMetric, BoundingBox3D bbx, ToDoubleFunction<Voxel3DGrid.Voxel3DData> metricFunction) {
            ArrayList<VisualDefinition> visuals = new ArrayList<VisualDefinition>();
            TDoubleArrayList metricValues = new TDoubleArrayList();
            ArrayList<Voxel3DGrid.Voxel3DData> evaluatedVoxels = new ArrayList<Voxel3DGrid.Voxel3DData>();
            for (int voxelIndex = 0; voxelIndex < ReachabilityMapVisualizer.this.reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
                double metricValue;
                Voxel3DGrid.Voxel3DData voxel = ReachabilityMapVisualizer.this.reachabilityMap.getVoxel(voxelIndex);
                if (voxel == null || !bbx.isInsideInclusive((Point3DReadOnly)voxel.getPosition()) || !((metricValue = metricFunction.applyAsDouble(voxel)) > 0.001)) continue;
                metricValues.add(metricValue);
                evaluatedVoxels.add(voxel);
            }
            double min = metricValues.min();
            double max = metricValues.max();
            double range = max - min;
            for (int i = 0; i < evaluatedVoxels.size(); ++i) {
                double value = normalizeMetric ? (metricValues.get(i) - min) / range : metricValues.get(i);
                visuals.add(ReachabilityMapTools.createMetricVisual((Voxel3DGrid.Voxel3DData)evaluatedVoxels.get(i), (Double)this.scaleSpinner.getValue(), value));
            }
            return visuals;
        }

        public RayIndexBasedVoxelQualityMetric getReachHeatMapMetric(String target) {
            if (RayTarget.equals(target)) {
                return (voxel, rayIndex) -> voxel.isRayReachable(rayIndex) ? 1.0 : 0.0;
            }
            if (PoseTarget.equals(target)) {
                return (voxel, rayIndex) -> {
                    double r = voxel.getNumberOfReachableRotationsAroundRay(rayIndex);
                    double R = voxel.getNumberOfRotationsAroundRay();
                    return r / R;
                };
            }
            return null;
        }

        public RayIndexBasedVoxelQualityMetric getVoxelExtraDataBasedMetric(String target, ToDoubleFunction<Voxel3DGrid.VoxelExtraData> function) {
            switch (target) {
                case "Ray": {
                    return (voxel, rayIndex) -> function.applyAsDouble(voxel.getRayExtraData(rayIndex));
                }
                case "Pose": {
                    return (voxel, rayIndex) -> {
                        double s = 0.0;
                        for (int rotationIndex = 0; rotationIndex < voxel.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                            s += function.applyAsDouble(voxel.getPoseExtraData(rayIndex, rotationIndex));
                        }
                        return s /= (double)voxel.getNumberOfRotationsAroundRay();
                    };
                }
            }
            return null;
        }

        public List<VisualDefinition> generateMetricRayBasedHeatMapVisuals(boolean normalizeMetric, RayIndexBasedVoxelQualityMetric metric, BoundingBox3D bbx) {
            if (metric == null) {
                return null;
            }
            TriangleMesh3DBuilder vizMeshBuilder = new TriangleMesh3DBuilder();
            Point2D unreachableTexture = new Point2D(0.0, 0.5);
            Point2D reachableTexture = new Point2D(1.0, 0.5);
            ArrayList<double[]> savedValues = new ArrayList<double[]>();
            ArrayList<Voxel3DGrid.Voxel3DData> savedVoxels = new ArrayList<Voxel3DGrid.Voxel3DData>();
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (int voxelIndex = 0; voxelIndex < ReachabilityMapVisualizer.this.reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
                Voxel3DGrid.Voxel3DData voxel = ReachabilityMapVisualizer.this.reachabilityMap.getVoxel(voxelIndex);
                if (voxel == null) continue;
                boolean insideBBX = bbx.isInsideInclusive((Point3DReadOnly)voxel.getPosition());
                double[] voxelValues = new double[voxel.getNumberOfRays()];
                double voxelMin = Double.POSITIVE_INFINITY;
                double voxelMax = Double.NEGATIVE_INFINITY;
                for (int rayIndex2 = 0; rayIndex2 < voxel.getNumberOfRays(); ++rayIndex2) {
                    double value;
                    voxelValues[rayIndex2] = value = metric.evaluate(voxel, rayIndex2);
                    voxelMin = Math.min(voxelMin, value);
                    voxelMax = Math.max(voxelMax, value);
                }
                if (!(voxelMax > 0.001)) continue;
                min = Math.min(min, voxelMin);
                max = Math.max(max, voxelMax);
                if (!insideBBX) continue;
                savedVoxels.add(voxel);
                savedValues.add(voxelValues);
            }
            double offset = min;
            double range = max - min;
            for (int i = 0; i < savedVoxels.size(); ++i) {
                Voxel3DGrid.Voxel3DData voxel = (Voxel3DGrid.Voxel3DData)savedVoxels.get(i);
                double[] voxelValues = (double[])savedValues.get(i);
                ReachabilityMapTools.createVoxelRayHeatmap(voxel, (Double)this.scaleSpinner.getValue(), rayIndex -> normalizeMetric ? (voxelValues[rayIndex] - offset) / range : voxelValues[rayIndex], (Point2DReadOnly)reachableTexture, (Point2DReadOnly)unreachableTexture, vizMeshBuilder);
            }
            TextureDefinition diffuseMap = ReachabilityMapTools.generateReachabilityGradient(0.0, 0.7);
            return Collections.singletonList(new VisualDefinition((GeometryDefinition)vizMeshBuilder.generateTriangleMesh3D(), new MaterialDefinition(diffuseMap)));
        }
    }

    private static interface RayIndexBasedVoxelQualityMetric {
        public double evaluate(Voxel3DGrid.Voxel3DData var1, int var2);
    }
}

