/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import controller_msgs.msg.dds.RobotConfigurationData;
import ihmc_common_msgs.msg.dds.SelectionMatrix3DMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import toolbox_msgs.msg.dds.KinematicsToolboxOutputStatus;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxController;
import us.ihmc.avatar.networkProcessor.kinematicsToolboxModule.KinematicsToolboxModule;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameShape3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionTools;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class ReachabilityMapSolver {
    private static final int DEFAULT_MAX_NUMBER_OF_ITERATIONS = 100;
    private static final double DEFAULT_QUALITY_THRESHOLD = 0.001;
    private static final double DEFAULT_STABILITY_THRESHOLD = 2.0E-5;
    private static final double DEFAULT_MIN_PROGRESSION = 5.0E-4;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterations", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoDouble solutionQualityThreshold = new YoDouble("solutionQualityThreshold", this.registry);
    private final YoDouble solutionStabilityThreshold = new YoDouble("solutionStabilityThreshold", this.registry);
    private final YoDouble solutionMinimumProgression = new YoDouble("solutionProgressionThreshold", this.registry);
    private final int numberOfTrials = 10;
    private final Random random = new Random(645216L);
    private final KinematicsToolboxController kinematicsToolboxController;
    private final CommandInputManager commandInputManager = new CommandInputManager(KinematicsToolboxModule.supportedCommands());
    private final StatusMessageOutputManager statusOutputManager = new StatusMessageOutputManager(KinematicsToolboxModule.supportedStatus());
    private final RigidBodyBasics endEffector;
    private final OneDoFJointBasics[] robotArmJoints;
    private final FramePose3D controlFramePoseInEndEffector = new FramePose3D();
    private final SelectionMatrix3D rayAngularSelection = new SelectionMatrix3D(null, false, true, true);
    private final RobotConfigurationData defaultArmConfiguration;
    private final String cloneSuffix;
    private Predicate<OneDoFJointReadOnly[]> solutionValidityChecker = null;

    public ReachabilityMapSolver(String cloneSuffix, OneDoFJointBasics[] robotArmJoints, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.cloneSuffix = cloneSuffix;
        this.robotArmJoints = robotArmJoints;
        this.endEffector = robotArmJoints[robotArmJoints.length - 1].getSuccessor();
        this.kinematicsToolboxController = new KinematicsToolboxController(this.commandInputManager, this.statusOutputManager, null, robotArmJoints, Collections.singleton(this.endEffector), 0.001, yoGraphicsListRegistry, this.registry);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new KinematicsToolboxCommandConverter(MultiBodySystemTools.getRootBody((RigidBodyBasics)this.endEffector)));
        this.defaultArmConfiguration = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])robotArmJoints, (ForceSensorDefinition[])new ForceSensorDefinition[0], (IMUDefinition[])new IMUDefinition[0]);
        RobotConfigurationDataFactory.packJointState((RobotConfigurationData)this.defaultArmConfiguration, (OneDoFJointReadOnly[])robotArmJoints);
        this.kinematicsToolboxController.setDesiredRobotStateUpdater(KinematicsToolboxController.IKRobotStateUpdater.wrap(this.defaultArmConfiguration));
        this.maximumNumberOfIterations.set(100);
        this.solutionQualityThreshold.set(0.001);
        this.solutionStabilityThreshold.set(2.0E-5);
        this.solutionMinimumProgression.set(5.0E-4);
        parentRegistry.addChild(this.registry);
    }

    public void setCollisionModel(RobotDefinition robotDefinition) {
        Set solverRigidBodies = Arrays.stream(this.robotArmJoints).map(JointBasics::getSuccessor).collect(Collectors.toSet());
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)this.endEffector);
        for (RigidBodyDefinition rigidBodyDef : robotDefinition.getAllRigidBodies()) {
            if (rigidBodyDef.getCollisionShapeDefinitions() == null) continue;
            RigidBodyBasics rigidBody = MultiBodySystemTools.findRigidBody((RigidBodyBasics)rootBody, (String)(rigidBodyDef.getName() + this.cloneSuffix));
            boolean staticCollidable = !solverRigidBodies.contains(rigidBody);
            MovingReferenceFrame shapeFrame = rigidBody.isRootBody() ? rigidBody.getBodyFixedFrame() : rigidBody.getParentJoint().getFrameAfterJoint();
            for (CollisionShapeDefinition collisionDef : rigidBodyDef.getCollisionShapeDefinitions()) {
                FrameShape3DReadOnly shape = CollisionTools.toFrameShape3D((RigidBodyTransformReadOnly)collisionDef.getOriginPose(), (ReferenceFrame)shapeFrame, (GeometryDefinition)collisionDef.getGeometryDefinition());
                long collisionMask = collisionDef.getCollisionMask();
                long collisionGroup = collisionDef.getCollisionGroup();
                if (staticCollidable) {
                    this.kinematicsToolboxController.registerStaticCollidable(new Collidable(null, collisionMask, collisionGroup, shape));
                    continue;
                }
                this.kinematicsToolboxController.registerRobotCollidable(new Collidable(rigidBody, collisionMask, collisionGroup, shape));
            }
        }
    }

    public void setControlFramePoseInParentJoint(Pose3DReadOnly controlFramePose) {
        this.controlFramePoseInEndEffector.setIncludingFrame((ReferenceFrame)this.endEffector.getParentJoint().getFrameAfterJoint(), controlFramePose);
        this.controlFramePoseInEndEffector.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void setControlFramePoseInParentJoint(RigidBodyTransformReadOnly controlFramePose) {
        this.controlFramePoseInEndEffector.setIncludingFrame((ReferenceFrame)this.endEffector.getParentJoint().getFrameAfterJoint(), controlFramePose);
        this.controlFramePoseInEndEffector.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void setRayAxis(Axis3D rayAxis) {
        this.setRaySolveAngularSelection(rayAxis != Axis3D.X, rayAxis != Axis3D.Y, rayAxis != Axis3D.Z);
    }

    public void setRaySolveAngularSelection(boolean selectX, boolean selectY, boolean selectZ) {
        this.rayAngularSelection.setAxisSelection(selectX, selectY, selectZ);
    }

    public void enableJointTorqueAnalysis(boolean considerJointTorqueLimits) {
        this.kinematicsToolboxController.getActiveOptimizationSettings().setComputeJointTorques(InverseKinematicsOptimizationSettingsCommand.ActivationState.ENABLED);
        this.kinematicsToolboxController.getActiveOptimizationSettings().setJointTorqueWeight(0.01);
        if (considerJointTorqueLimits) {
            this.addSolutionValidityChecker(joints -> {
                for (OneDoFJointReadOnly joint : joints) {
                    if (joint.getTau() > joint.getEffortLimitUpper()) {
                        return false;
                    }
                    if (!(joint.getTau() < joint.getEffortLimitLower())) continue;
                    return false;
                }
                return true;
            });
        }
    }

    public void addSolutionValidityChecker(Predicate<OneDoFJointReadOnly[]> checker) {
        this.solutionValidityChecker = this.solutionValidityChecker == null ? checker : this.solutionValidityChecker.and(checker);
    }

    public boolean solveForRay(FramePose3DReadOnly pose) {
        return this.solveFor(pose, true);
    }

    public boolean solveForPose(FramePose3DReadOnly pose) {
        return this.solveFor(pose, false);
    }

    private boolean solveFor(FramePose3DReadOnly pose, boolean solverForRay) {
        pose.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        this.kinematicsToolboxController.requestInitialize();
        KinematicsToolboxRigidBodyMessage message = new KinematicsToolboxRigidBodyMessage();
        message.setEndEffectorHashCode(this.endEffector.hashCode());
        pose.get((Tuple3DBasics)message.getDesiredPositionInWorld(), (Orientation3DBasics)message.getDesiredOrientationInWorld());
        message.getAngularWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)this.controlFramePoseInEndEffector.getPosition());
        message.getControlFrameOrientationInEndEffector().set((QuaternionReadOnly)this.controlFramePoseInEndEffector.getOrientation());
        if (solverForRay) {
            MessageTools.packSelectionMatrix3DMessage((SelectionMatrix3D)this.rayAngularSelection, (SelectionMatrix3DMessage)message.getAngularSelectionMatrix());
        } else {
            MessageTools.packSelectionMatrix3DMessage((boolean)true, (SelectionMatrix3DMessage)message.getAngularSelectionMatrix());
        }
        this.commandInputManager.submitMessage((Settable)message);
        return this.solveAndRetry(this.maximumNumberOfIterations.getIntegerValue());
    }

    public boolean solveFor(FramePoint3DReadOnly position) {
        this.kinematicsToolboxController.requestInitialize();
        FramePoint3D desiredPosition = new FramePoint3D((FrameTuple3DReadOnly)position);
        desiredPosition.changeFrame(ReferenceFrame.getWorldFrame());
        KinematicsToolboxRigidBodyMessage message = MessageTools.createKinematicsToolboxRigidBodyMessage((RigidBodyReadOnly)this.endEffector, (Point3DReadOnly)desiredPosition);
        message.getLinearWeightMatrix().set(MessageTools.createWeightMatrix3DMessage((double)1.0));
        message.getControlFramePositionInEndEffector().set((Tuple3DReadOnly)this.controlFramePoseInEndEffector.getPosition());
        message.getControlFrameOrientationInEndEffector().set((QuaternionReadOnly)this.controlFramePoseInEndEffector.getOrientation());
        this.commandInputManager.submitMessage((Settable)message);
        return this.solveAndRetry(50);
    }

    private boolean solveAndRetry(int maximumNumberOfIterations) {
        this.numberOfIterations.set(0);
        boolean success = false;
        while (!success && this.numberOfIterations.getValue() < 10) {
            MultiBodySystemRandomTools.nextStateWithinJointLimits((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (OneDoFJointBasics[])this.robotArmJoints);
            success = this.solveOnce(maximumNumberOfIterations);
            this.numberOfIterations.increment();
        }
        return success;
    }

    private boolean solveOnce(int maximumNumberOfIterations) {
        boolean isSolutionGood = false;
        boolean isSolverStuck = false;
        double solutionQuality = Double.NaN;
        double solutionQualityLast = Double.NaN;
        double solutionQualityBeforeLast = Double.NaN;
        for (int iteration = 0; !isSolutionGood && iteration < maximumNumberOfIterations; ++iteration) {
            this.kinematicsToolboxController.update();
            KinematicsToolboxOutputStatus solution = this.kinematicsToolboxController.getSolution();
            solutionQuality = solution.getSolutionQuality();
            if (!Double.isNaN(solutionQualityLast)) {
                double deltaSolutionQualityLast = Math.abs(solutionQuality - solutionQualityLast);
                double deltaSolutionQualityBeforeLast = Math.abs(solutionQuality - solutionQualityBeforeLast);
                boolean isSolutionStable = deltaSolutionQualityLast < this.solutionStabilityThreshold.getDoubleValue();
                boolean isSolutionQualityHigh = solutionQuality < this.solutionQualityThreshold.getDoubleValue();
                boolean bl = isSolutionGood = isSolutionStable && isSolutionQualityHigh;
                if (!isSolutionQualityHigh) {
                    boolean stuckLast = deltaSolutionQualityLast / solutionQuality < this.solutionMinimumProgression.getDoubleValue();
                    boolean stuckBeforeLast = deltaSolutionQualityBeforeLast / solutionQuality < this.solutionMinimumProgression.getDoubleValue();
                    isSolverStuck = stuckLast || stuckBeforeLast;
                } else {
                    isSolverStuck = false;
                }
            }
            solutionQualityBeforeLast = solutionQualityLast;
            solutionQualityLast = solutionQuality;
            if (!isSolverStuck) continue;
            break;
        }
        if (isSolutionGood && this.solutionValidityChecker != null) {
            isSolutionGood = this.solutionValidityChecker.test((OneDoFJointReadOnly[])this.kinematicsToolboxController.getDesiredOneDoFJoints());
        }
        if (isSolutionGood) {
            for (int i = 0; i < this.robotArmJoints.length; ++i) {
                this.robotArmJoints[i].setQ(this.kinematicsToolboxController.getDesiredOneDoFJoints()[i].getQ());
                this.robotArmJoints[i].setTau(this.kinematicsToolboxController.getDesiredOneDoFJoints()[i].getTau());
            }
        }
        return isSolutionGood;
    }

    public OneDoFJointBasics[] getRobotArmJoints() {
        return this.robotArmJoints;
    }

    public FramePose3D getControlFramePoseInEndEffector() {
        return this.controlFramePoseInEndEffector;
    }
}

