/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;

public class ReachabilityMapRobotInformation {
    private final RobotDefinition robotDefinition;
    private final String baseName;
    private final String endEffectorName;
    private Pose3DReadOnly controlFramePoseInParentJoint;
    private Axis3D orthogonalToPalm = Axis3D.X;

    public ReachabilityMapRobotInformation(RobotDefinition robotDefinition, String baseName, String endEffectorName) {
        this.robotDefinition = robotDefinition;
        this.baseName = baseName;
        this.endEffectorName = endEffectorName;
    }

    public Axis3D getOrthogonalToPalm() {
        return this.orthogonalToPalm;
    }

    public void setOrthogonalToPalm(Axis3D orthogonalToPalm) {
        this.orthogonalToPalm = orthogonalToPalm;
    }

    public Pose3DReadOnly getControlFramePoseInParentJoint() {
        return this.controlFramePoseInParentJoint;
    }

    public void setControlFramePoseInParentJoint(RigidBodyTransformReadOnly controlFramePoseInParentJoint) {
        this.setControlFramePoseInParentJoint((Pose3DReadOnly)new Pose3D(controlFramePoseInParentJoint));
    }

    public void setControlFramePoseInParentJoint(Pose3DReadOnly controlFramePoseInParentJoint) {
        this.controlFramePoseInParentJoint = controlFramePoseInParentJoint;
    }

    public RobotDefinition getRobotDefinition() {
        return this.robotDefinition;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getEndEffectorName() {
        return this.endEffectorName;
    }

    public List<OneDoFJointDefinition> getEvaluatedJoints() {
        return ReachabilityMapRobotInformation.createOneDoFJointPath(this.robotDefinition, this.baseName, this.endEffectorName);
    }

    public static List<OneDoFJointDefinition> createOneDoFJointPath(RobotDefinition robotDefinition, String startRigidBodyName, String endRigidBodyName) {
        JointDefinition parentJoint;
        RigidBodyDefinition end;
        ArrayList<OneDoFJointDefinition> joints = new ArrayList<OneDoFJointDefinition>();
        RigidBodyDefinition start = robotDefinition.getRigidBodyDefinition(startRigidBodyName);
        RigidBodyDefinition current = end = robotDefinition.getRigidBodyDefinition(endRigidBodyName);
        while (current != start && (parentJoint = current.getParentJoint()) != null) {
            if (parentJoint instanceof OneDoFJointDefinition) {
                joints.add((OneDoFJointDefinition)parentJoint);
            }
            current = parentJoint.getPredecessor();
        }
        if (current == start) {
            Collections.reverse(joints);
            return joints;
        }
        joints.clear();
        current = start;
        while (current != end && (parentJoint = current.getParentJoint()) != null) {
            if (parentJoint instanceof OneDoFJointDefinition) {
                joints.add((OneDoFJointDefinition)parentJoint);
            }
            current = parentJoint.getPredecessor();
        }
        if (current == end) {
            return joints;
        }
        return null;
    }
}

