/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Sinks;
import us.hebi.matlab.mat.types.Struct;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapFileWriter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.avatar.reachabilityMap.voxelPrimitiveShapes.SphereVoxelShape;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;

public class ReachabilityMapMatlabExporter
implements ReachabilityMapFileWriter {
    @Override
    public void write(File file, ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        Mat5File matFile = Mat5.newMatFile();
        matFile.addArray("Description", (Array)ReachabilityMapMatlabExporter.createDescriptionStruct(robotInformation, reachabilityMap));
        matFile.addArray("PositionReachData", (Array)ReachabilityMapMatlabExporter.createPositionReachDataStruct(robotInformation, reachabilityMap));
        matFile.addArray("RayReachData", (Array)ReachabilityMapMatlabExporter.createRayReachDataStruct(robotInformation, reachabilityMap));
        matFile.addArray("PoseReachData", (Array)ReachabilityMapMatlabExporter.createPoseReachDataStruct(robotInformation, reachabilityMap));
        try {
            matFile.writeTo(Sinks.newStreamingFile((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Struct createDescriptionStruct(ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        Struct descriptionStruct = Mat5.newStruct();
        RobotDefinition robotDefinition = robotInformation.getRobotDefinition();
        List<OneDoFJointDefinition> evaluatedJoints = robotInformation.getEvaluatedJoints();
        SphereVoxelShape sphereVoxelShape = reachabilityMap.getSphereVoxelShape();
        descriptionStruct.set("robotName", (Array)Mat5.newString((String)robotDefinition.getName()));
        descriptionStruct.set("gridSizeInMeters", ReachabilityMapMatlabExporter.newDouble(reachabilityMap.getGridSizeMeters()));
        descriptionStruct.set("gridSizeInVoxels", ReachabilityMapMatlabExporter.newInt(reachabilityMap.getGridSizeVoxels()));
        descriptionStruct.set("voxelSizeInMeters", ReachabilityMapMatlabExporter.newDouble(reachabilityMap.getVoxelSize()));
        descriptionStruct.set("numberOfRays", ReachabilityMapMatlabExporter.newInt(sphereVoxelShape.getNumberOfRays()));
        descriptionStruct.set("numberOfRotationsAroundRay", ReachabilityMapMatlabExporter.newInt(sphereVoxelShape.getNumberOfRotationsAroundRay()));
        descriptionStruct.set("gridPoseXYZYPR", ReachabilityMapMatlabExporter.newPose3D((Pose3DReadOnly)new Pose3D((RigidBodyTransformReadOnly)reachabilityMap.getReferenceFrame().getTransformToRoot()), true));
        descriptionStruct.set("jointNames", ReachabilityMapMatlabExporter.newStrings(evaluatedJoints.stream().map(j -> j.getName()).collect(Collectors.toList())));
        descriptionStruct.set("jointPositionLimitLower", ReachabilityMapMatlabExporter.newDoubleVector(evaluatedJoints.stream().mapToDouble(j -> j.getPositionLowerLimit()).toArray()));
        descriptionStruct.set("jointPositionLimitUpper", ReachabilityMapMatlabExporter.newDoubleVector(evaluatedJoints.stream().mapToDouble(j -> j.getPositionUpperLimit()).toArray()));
        descriptionStruct.set("jointEffortLimitLower", ReachabilityMapMatlabExporter.newDoubleVector(evaluatedJoints.stream().mapToDouble(j -> j.getEffortLowerLimit()).toArray()));
        descriptionStruct.set("jointEffortLimitUpper", ReachabilityMapMatlabExporter.newDoubleVector(evaluatedJoints.stream().mapToDouble(j -> j.getEffortUpperLimit()).toArray()));
        descriptionStruct.set("controlFramePoseXYZYPR", ReachabilityMapMatlabExporter.newPose3D(robotInformation.getControlFramePoseInParentJoint(), true));
        return descriptionStruct;
    }

    private static Struct createPositionReachDataStruct(ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        List<OneDoFJointDefinition> evaluatedJoints = robotInformation.getEvaluatedJoints();
        Struct dataStruct = Mat5.newStruct();
        int dataLength = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || voxel.getPositionExtraData() == null) continue;
            ++dataLength;
        }
        Matrix voxelIndexMatrix = Mat5.newMatrix((int)dataLength, (int)3);
        Matrix desiredPositionMatrix = Mat5.newMatrix((int)dataLength, (int)3);
        Matrix jointPositions = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        Matrix jointTorques = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        int row = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.VoxelExtraData extraData;
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || (extraData = voxel.getPositionExtraData()) == null) continue;
            voxelIndexMatrix.setInt(row, 0, voxel.getKey().getX());
            voxelIndexMatrix.setInt(row, 1, voxel.getKey().getY());
            voxelIndexMatrix.setInt(row, 2, voxel.getKey().getZ());
            desiredPositionMatrix.setDouble(row, 0, (double)((float)extraData.getDesiredPosition().getX()));
            desiredPositionMatrix.setDouble(row, 1, (double)((float)extraData.getDesiredPosition().getY()));
            desiredPositionMatrix.setDouble(row, 2, (double)((float)extraData.getDesiredPosition().getZ()));
            for (int col = 0; col < evaluatedJoints.size(); ++col) {
                jointPositions.setFloat(row, col, extraData.getJointPositions()[col]);
                jointTorques.setFloat(row, col, extraData.getJointTorques()[col]);
            }
            ++row;
        }
        dataStruct.set("voxelKey", (Array)voxelIndexMatrix);
        dataStruct.set("desiredXYZ", (Array)desiredPositionMatrix);
        dataStruct.set("jointPositions", (Array)jointPositions);
        dataStruct.set("jointTorques", (Array)jointTorques);
        return dataStruct;
    }

    private static Struct createRayReachDataStruct(ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        List<OneDoFJointDefinition> evaluatedJoints = robotInformation.getEvaluatedJoints();
        Struct dataStruct = Mat5.newStruct();
        int dataLength = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null) continue;
            dataLength += voxel.getNumberOfReachableRays();
        }
        Matrix voxelIndexMatrix = Mat5.newMatrix((int)dataLength, (int)4);
        Matrix desiredPoseMatrix = Mat5.newMatrix((int)dataLength, (int)6);
        Matrix jointPositions = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        Matrix jointTorques = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        int row = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null) continue;
            for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
                Voxel3DGrid.VoxelExtraData extraData = voxel.getRayExtraData(rayIndex);
                if (extraData == null) continue;
                voxelIndexMatrix.setInt(row, 0, voxel.getKey().getX());
                voxelIndexMatrix.setInt(row, 1, voxel.getKey().getY());
                voxelIndexMatrix.setInt(row, 2, voxel.getKey().getZ());
                voxelIndexMatrix.setInt(row, 3, rayIndex);
                desiredPoseMatrix.setFloat(row, 0, (float)extraData.getDesiredPosition().getX());
                desiredPoseMatrix.setFloat(row, 1, (float)extraData.getDesiredPosition().getY());
                desiredPoseMatrix.setFloat(row, 2, (float)extraData.getDesiredPosition().getZ());
                desiredPoseMatrix.setFloat(row, 3, (float)extraData.getDesiredOrientation().getYaw());
                desiredPoseMatrix.setFloat(row, 4, (float)extraData.getDesiredOrientation().getPitch());
                desiredPoseMatrix.setFloat(row, 5, (float)extraData.getDesiredOrientation().getRoll());
                for (int col = 0; col < evaluatedJoints.size(); ++col) {
                    jointPositions.setFloat(row, col, extraData.getJointPositions()[col]);
                    jointTorques.setFloat(row, col, extraData.getJointTorques()[col]);
                }
                ++row;
            }
        }
        dataStruct.set("voxelKey", (Array)voxelIndexMatrix);
        dataStruct.set("desiredXYZYPR", (Array)desiredPoseMatrix);
        dataStruct.set("jointPositions", (Array)jointPositions);
        dataStruct.set("jointTorques", (Array)jointTorques);
        return dataStruct;
    }

    private static Struct createPoseReachDataStruct(ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        List<OneDoFJointDefinition> evaluatedJoints = robotInformation.getEvaluatedJoints();
        Struct dataStruct = Mat5.newStruct();
        int dataLength = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null) continue;
            dataLength += voxel.getNumberOfReachablePoses();
        }
        Matrix voxelIndexMatrix = Mat5.newMatrix((int)dataLength, (int)5);
        Matrix desiredPoseMatrix = Mat5.newMatrix((int)dataLength, (int)6);
        Matrix jointPositions = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        Matrix jointTorques = Mat5.newMatrix((int)dataLength, (int)evaluatedJoints.size());
        int row = 0;
        for (int voxelIndex = 0; voxelIndex < reachabilityMap.getNumberOfVoxels(); ++voxelIndex) {
            Voxel3DGrid.Voxel3DData voxel = reachabilityMap.getVoxel(voxelIndex);
            if (voxel == null || !voxel.atLeastOneReachablePose()) continue;
            for (int rayIndex = 0; rayIndex < voxel.getNumberOfRays(); ++rayIndex) {
                for (int rotationIndex = 0; rotationIndex < voxel.getNumberOfRotationsAroundRay(); ++rotationIndex) {
                    Voxel3DGrid.VoxelExtraData extraData = voxel.getPoseExtraData(rayIndex, rotationIndex);
                    if (extraData == null) continue;
                    voxelIndexMatrix.setInt(row, 0, voxel.getKey().getX());
                    voxelIndexMatrix.setInt(row, 1, voxel.getKey().getY());
                    voxelIndexMatrix.setInt(row, 2, voxel.getKey().getZ());
                    voxelIndexMatrix.setInt(row, 3, rayIndex);
                    voxelIndexMatrix.setInt(row, 4, rotationIndex);
                    desiredPoseMatrix.setFloat(row, 0, (float)extraData.getDesiredPosition().getX());
                    desiredPoseMatrix.setFloat(row, 1, (float)extraData.getDesiredPosition().getY());
                    desiredPoseMatrix.setFloat(row, 2, (float)extraData.getDesiredPosition().getZ());
                    desiredPoseMatrix.setFloat(row, 3, (float)extraData.getDesiredOrientation().getYaw());
                    desiredPoseMatrix.setFloat(row, 4, (float)extraData.getDesiredOrientation().getPitch());
                    desiredPoseMatrix.setFloat(row, 5, (float)extraData.getDesiredOrientation().getRoll());
                    for (int col = 0; col < evaluatedJoints.size(); ++col) {
                        jointPositions.setFloat(row, col, extraData.getJointPositions()[col]);
                        jointTorques.setFloat(row, col, extraData.getJointTorques()[col]);
                    }
                    ++row;
                }
            }
        }
        dataStruct.set("voxelKey", (Array)voxelIndexMatrix);
        dataStruct.set("desiredXYZYPR", (Array)desiredPoseMatrix);
        dataStruct.set("jointPositions", (Array)jointPositions);
        dataStruct.set("jointTorques", (Array)jointTorques);
        return dataStruct;
    }

    private static Array newDouble(double value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1);
        matrix.setDouble(0, value);
        return matrix;
    }

    private static Array newInt(int value) {
        Matrix matrix = Mat5.newMatrix((int)1, (int)1);
        matrix.setInt(0, value);
        return matrix;
    }

    private static Array newStrings(Collection<String> strings) {
        Cell cell = Mat5.newCell((int)strings.size(), (int)1);
        int index = 0;
        for (String string : strings) {
            cell.set(index++, (Array)Mat5.newString((String)string));
        }
        return cell;
    }

    private static Array newPose3D(Pose3DReadOnly pose, boolean useYawPitchRoll) {
        if (useYawPitchRoll) {
            Matrix matrix = Mat5.newMatrix((int)6, (int)1);
            int index = 0;
            matrix.setDouble(index++, pose.getX());
            matrix.setDouble(index++, pose.getY());
            matrix.setDouble(index++, pose.getZ());
            matrix.setDouble(index++, pose.getYaw());
            matrix.setDouble(index++, pose.getPitch());
            matrix.setDouble(index++, pose.getRoll());
            return matrix;
        }
        Matrix matrix = Mat5.newMatrix((int)7, (int)1);
        int index = 0;
        matrix.setDouble(index++, pose.getX());
        matrix.setDouble(index++, pose.getY());
        matrix.setDouble(index++, pose.getZ());
        matrix.setDouble(index++, pose.getOrientation().getX());
        matrix.setDouble(index++, pose.getOrientation().getY());
        matrix.setDouble(index++, pose.getOrientation().getZ());
        matrix.setDouble(index++, pose.getOrientation().getS());
        return matrix;
    }

    private static Array newDoubleVector(double ... values) {
        Matrix matrix = Mat5.newMatrix((int)values.length, (int)1);
        for (int i = 0; i < values.length; ++i) {
            matrix.setDouble(i, values[i]);
        }
        return matrix;
    }

    @Override
    public String getFileExtension() {
        return ".mat";
    }
}

