/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.commons.nio.FileTools;

public interface ReachabilityMapFileWriter {
    default public void write(Class<?> classForFilePath, ReachabilityMapRobotInformation robotInformation, Voxel3DGrid reachabilityMap) {
        File outputStream = ReachabilityMapFileWriter.newFile(robotInformation.getRobotDefinition().getName(), classForFilePath, this.getFileExtension());
        if (outputStream == null) {
            return;
        }
        this.write(outputStream, robotInformation, reachabilityMap);
    }

    public void write(File var1, ReachabilityMapRobotInformation var2, Voxel3DGrid var3);

    public String getFileExtension();

    public static File newFile(String robotName, Class<?> classForFilePath, String fileExtension) {
        String fileName = ReachabilityMapFileWriter.prependDateToFileName(robotName) + fileExtension;
        Path filePath = ReachabilityMapFileWriter.deriveResourcesPath(classForFilePath);
        try {
            FileTools.ensureDirectoryExists((Path)filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        filePath = filePath.resolve(fileName);
        return filePath.toFile();
    }

    public static Path deriveResourcesPath(Class<?> clazz) {
        ArrayList<String> pathNames = new ArrayList<String>();
        String[] packageNames = clazz.getPackage().getName().split("\\.");
        pathNames.addAll(Arrays.asList(packageNames));
        pathNames.add(StringUtils.uncapitalize((String)clazz.getSimpleName()));
        return Paths.get("src/main/resources", pathNames.toArray(new String[0]));
    }

    public static String prependDateToFileName(String fileName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_");
        Date date = new Date();
        String dateAsString = dateFormat.format(date);
        return dateAsString + fileName;
    }
}

