/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.reachabilityMap;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javafx.stage.FileChooser;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapFileWriter;
import us.ihmc.avatar.reachabilityMap.ReachabilityMapRobotInformation;
import us.ihmc.avatar.reachabilityMap.Voxel3DGrid;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;

public interface ReachabilityMapFileReader {
    public Voxel3DGrid read(File var1, ReachabilityMapRobotInformation var2);

    public String getFileType();

    public String getFileExtension();

    default public File openSelectionFileDialog() {
        File result;
        File initialDirectory = SessionVisualizerIOTools.getDefaultFilePath((String)"humanoid-reachability-map-load");
        if (initialDirectory == null) {
            initialDirectory = new File(".");
        }
        if ((result = this.openSelectionFileDialog(initialDirectory)) != null) {
            SessionVisualizerIOTools.setDefaultFilePath((String)"humanoid-reachability-map-load", (File)result.getParentFile());
        }
        return result;
    }

    default public File openSelectionFileDialog(File initialDirectory) {
        JavaFXTools.startup();
        return (File)JavaFXTools.runAndWait(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Choose reachability map to load");
            if (initialDirectory != null) {
                fileChooser.setInitialDirectory(initialDirectory);
            }
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(this.getFileType(), new String[]{"*" + this.getFileExtension()}));
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
            return fileChooser.showOpenDialog(null);
        });
    }

    default public File findLatestFile(Class<?> classForFilePath, ReachabilityMapRobotInformation robotInformation) {
        File folder = ReachabilityMapFileReader.deriveResourcesFolder(classForFilePath);
        if (!folder.exists()) {
            return null;
        }
        String fileExtension = this.getFileExtension();
        String robotName = robotInformation.getRobotDefinition().getName();
        ArrayList<File> reachabilityMapFiles = new ArrayList<File>(Arrays.asList(folder.listFiles(f -> f.getName().endsWith(robotName + fileExtension))));
        if (reachabilityMapFiles.isEmpty()) {
            return null;
        }
        Collections.sort(reachabilityMapFiles);
        return (File)reachabilityMapFiles.get(reachabilityMapFiles.size() - 1);
    }

    public static File deriveResourcesFolder(Class<?> classForFilePath) {
        return ReachabilityMapFileWriter.deriveResourcesPath(classForFilePath).toFile();
    }
}

