/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.posePlayback.DRCRobotMidiSliderBoardPositionManipulation;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.avatar.posePlayback.PoseSequenceSelectorPanel;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PoseSequenceEditorGUI
extends JFrame {
    private static final long serialVersionUID = 8890174114593028871L;
    private final PoseSequenceSelectorPanel poseSequenceSelectorPanel;
    private final ButtonPanel buttonPanel;

    public PoseSequenceEditorGUI(DRCRobotModel robotModel) {
        super("Pose sequence editor");
        this.setSize(1400, 600);
        this.poseSequenceSelectorPanel = new PoseSequenceSelectorPanel(robotModel);
        this.buttonPanel = new ButtonPanel();
        this.buttonPanelInit();
    }

    public PoseSequenceEditorGUI(YoRegistry registry, HumanoidFloatingRootJointRobot sdfRobot, FullHumanoidRobotModel fullRobotModel, DRCRobotMidiSliderBoardPositionManipulation sliderBoard) {
        super("Pose sequence editor");
        this.setSize(1400, 600);
        this.poseSequenceSelectorPanel = new PoseSequenceSelectorPanel(registry, sdfRobot, fullRobotModel, sliderBoard);
        this.buttonPanel = new ButtonPanel();
        this.buttonPanelInit();
    }

    private void buttonPanelInit() {
        this.getContentPane().add((Component)new JointNameKey(), "North");
        this.getContentPane().add((Component)this.poseSequenceSelectorPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    public void setSequence(PlaybackPoseSequence seq) {
        this.poseSequenceSelectorPanel.setSequence(seq);
    }

    public void addSequence(PlaybackPoseSequence seq) {
        this.poseSequenceSelectorPanel.addSequence(seq);
    }

    private class ButtonPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 5462601984021392064L;
        private JButton selectNewPoseSequence;
        private JButton selectPoseSequence;
        private JButton deleteRow;
        private JButton updateSCS;
        private JButton setRowWithSlider;
        private JButton save;
        private JButton switchSideDependentValues;
        private JButton copyAndInsertRow;
        private JButton insertInterpolation;

        public ButtonPanel() {
            JPanel buttonPanel = new JPanel();
            this.selectNewPoseSequence = new JButton("Select new pose sequence");
            this.selectPoseSequence = new JButton("Select pose sequence to append");
            this.deleteRow = new JButton("Delete");
            this.updateSCS = new JButton("Update SCS");
            this.setRowWithSlider = new JButton("Set row with slider");
            this.save = new JButton("Save");
            this.copyAndInsertRow = new JButton("Copy/insert row");
            this.switchSideDependentValues = new JButton("Switch side dependent values");
            this.insertInterpolation = new JButton("Insert interpolated row");
            buttonPanel.add(this.selectNewPoseSequence);
            buttonPanel.add(this.selectPoseSequence);
            buttonPanel.add(this.copyAndInsertRow);
            buttonPanel.add(this.insertInterpolation);
            buttonPanel.add(this.deleteRow);
            buttonPanel.add(this.updateSCS);
            buttonPanel.add(this.setRowWithSlider);
            buttonPanel.add(this.switchSideDependentValues);
            buttonPanel.add(this.save);
            this.selectNewPoseSequence.addActionListener(this);
            this.copyAndInsertRow.addActionListener(this);
            this.insertInterpolation.addActionListener(this);
            this.selectPoseSequence.addActionListener(this);
            this.deleteRow.addActionListener(this);
            this.updateSCS.addActionListener(this);
            this.setRowWithSlider.addActionListener(this);
            this.save.addActionListener(this);
            this.switchSideDependentValues.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)buttonPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.selectPoseSequence)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.addSequenceFromFile();
            } else if (e.getSource().equals(this.deleteRow)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.deleteSelectedRows();
            } else if (e.getSource().equals(this.updateSCS)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.updateSCS();
            } else if (e.getSource().equals(this.setRowWithSlider)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.setRowWithSlider();
            } else if (e.getSource().equals(this.save)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.save();
            } else if (e.getSource().equals(this.selectNewPoseSequence)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.newSequenceFromFile();
            } else if (e.getSource().equals(this.copyAndInsertRow)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.copyAndInsertRow();
            } else if (e.getSource().equals(this.insertInterpolation)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.insertInterpolation();
            } else if (e.getSource().equals(this.switchSideDependentValues)) {
                PoseSequenceEditorGUI.this.poseSequenceSelectorPanel.switchSideDependentValues();
            }
        }
    }

    private class JointNameKey
    extends JPanel {
        private static final long serialVersionUID = -986320074350226999L;

        public JointNameKey() {
            String key = "Joint name    =   (left, right)   +   (ankle, elbow, hip, knee, neck, shoulder, spine, wrist)   +   (yaw, pitch, roll)";
            JLabel jointNameKey = new JLabel(key);
            this.add("key", jointNameKey);
        }
    }
}

