/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import us.ihmc.avatar.posePlayback.DRCRobotMidiSliderBoardPositionManipulation;
import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseInterpolator;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceReader;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequenceWriter;
import us.ihmc.avatar.posePlayback.PoseSequenceEditorGUI;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotController.ModularRobotController;
import us.ihmc.robotics.robotController.RawSensorReader;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.simulatedSensors.SDFPerfectSimulatedSensorReader;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariable;

public class PosePlaybackSCSBridge {
    private static final boolean promptForTimeDelay = false;
    private PlaybackPoseSequence posePlaybackRobotPoseSequence;
    private PlaybackPoseSequence lastLoadedPoseSequence;
    private int frameByframePoseNumber;
    private double frameByframeTime;
    private boolean playOnlyOnePose = false;
    private final PlaybackPoseInterpolator interpolator;
    private final YoRegistry registry = new YoRegistry("PlaybackPoseSCSBridge");
    private final YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
    private final YoFramePoint3D centerOfMassPosition = new YoFramePoint3D("centerOfMass", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D centerOfMassPosition2d = new YoFramePoint3D("centerOfMass2d", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D leftAnklePosition = new YoFramePoint3D("leftAnklePosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D rightAnklePosition = new YoFramePoint3D("rightAnklePosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final SideDependentList<YoFramePoint3D> anklePositions = new SideDependentList((Object)this.leftAnklePosition, (Object)this.rightAnklePosition);
    private PlaybackPose previousPose;
    private final SideDependentList<YoGraphicCoordinateSystem> feetCoordinateSystems = new SideDependentList();
    private final YoFramePoint3D leftWristPosition = new YoFramePoint3D("leftWristPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D rightWristPosition = new YoFramePoint3D("rightWristPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final SideDependentList<YoFramePoint3D> wristPositions = new SideDependentList((Object)this.leftWristPosition, (Object)this.rightWristPosition);
    private final SideDependentList<YoGraphicCoordinateSystem> handCoordinateSystems = new SideDependentList();
    private final PoseSequenceEditorGUI poseSequenceEditorGUI;
    private final HumanoidFloatingRootJointRobot sdfRobot;
    private final FullRobotModel fullRobotModel;
    private final SimulationConstructionSet scs;
    private final double controlDT;

    public PosePlaybackSCSBridge(HumanoidFloatingRootJointRobot sdfRobot, FullHumanoidRobotModel fullRobotModel, FullHumanoidRobotModel fullRobotModelForSlider, double controlDT) throws IOException {
        this.sdfRobot = sdfRobot;
        this.fullRobotModel = fullRobotModel;
        this.controlDT = controlDT;
        this.interpolator = new PlaybackPoseInterpolator(this.registry);
        this.posePlaybackRobotPoseSequence = new PlaybackPoseSequence((FullRobotModel)fullRobotModel);
        SDFPerfectSimulatedSensorReader reader = new SDFPerfectSimulatedSensorReader((FloatingRootJointRobot)sdfRobot, (FullRobotModel)fullRobotModel, null);
        ModularRobotController controller = new ModularRobotController("Reader");
        controller.setRawSensorReader((RawSensorReader)reader);
        this.scs = new SimulationConstructionSet((Robot)sdfRobot);
        this.scs.setDT(controlDT, 1);
        this.scs.addYoRegistry(this.registry);
        String listName = this.getClass().getSimpleName();
        this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicPosition("centerOfMass", this.centerOfMassPosition, 0.03, YoAppearance.Gold()));
        this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicPosition("centerOfMass2d", this.centerOfMassPosition2d, 0.03, YoAppearance.Gold()));
        SideDependentList appearance = new SideDependentList((Object)YoAppearance.Red(), (Object)YoAppearance.Green());
        for (RobotSide robotSide : RobotSide.values) {
            String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
            this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicPosition(sidePrefix + "AnkleViz", (YoFramePoint3D)this.anklePositions.get((Enum)robotSide), 0.05, (AppearanceDefinition)appearance.get((Enum)robotSide)));
            this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)new YoGraphicPosition(sidePrefix + "WristViz", (YoFramePoint3D)this.wristPositions.get((Enum)robotSide), 0.05, (AppearanceDefinition)appearance.get((Enum)robotSide)));
            YoGraphicCoordinateSystem footCoordinateSystem = new YoGraphicCoordinateSystem(sidePrefix + "Foot", "", this.registry, true, 0.25);
            this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)footCoordinateSystem);
            this.feetCoordinateSystems.put((Enum)robotSide, (Object)footCoordinateSystem);
            YoGraphicCoordinateSystem handCoordinateSystem = new YoGraphicCoordinateSystem(sidePrefix + "Hand", "", this.registry, true, 0.25);
            this.yoGraphicsListRegistry.registerYoGraphic(listName, (YoGraphic)handCoordinateSystem);
            this.handCoordinateSystems.put((Enum)robotSide, (Object)handCoordinateSystem);
        }
        this.scs.addYoGraphicsListRegistry(this.yoGraphicsListRegistry);
        DRCRobotMidiSliderBoardPositionManipulation sliderBoard = new DRCRobotMidiSliderBoardPositionManipulation(this.scs, (FloatingRootJointRobot)sdfRobot, fullRobotModelForSlider, this.yoGraphicsListRegistry);
        sliderBoard.addCaptureSnapshotListener(new CaptureSnapshotListener(fullRobotModel, controller));
        sliderBoard.addSaveSequenceRequestedListener(new SaveSequenceListener());
        sliderBoard.addLoadSequenceRequestedListener(new LoadSequenceFromFileListener((FullRobotModel)fullRobotModel));
        sliderBoard.addClearSequenceRequestedListener(new ClearSequenceListener());
        sliderBoard.addLoadFrameByFrameSequenceRequestedListener(new LoadFrameByFrameSequenceListener());
        sliderBoard.addLoadLastSequenceRequestedListener(new LoadLastSequenceListener());
        sliderBoard.addPlayPoseFromFrameByFrameSequenceRequestedListener(new PlayPoseFromFrameByFrameSequenceListener());
        sliderBoard.addResetToBasePoseRequestedListener(new ResetToBasePoseListener());
        this.poseSequenceEditorGUI = new PoseSequenceEditorGUI(this.registry, sdfRobot, fullRobotModelForSlider, sliderBoard);
        this.poseSequenceEditorGUI.setVisible(true);
        this.scs.startOnAThread();
        CenterOfMassGraphicUpdater centerOfMassGraphicUpdater = new CenterOfMassGraphicUpdater();
        Thread thread = new Thread(centerOfMassGraphicUpdater);
        thread.start();
    }

    private boolean initPlaybackFromFile(FullRobotModel fullRobotModel, PlaybackPoseSequence sequence) {
        boolean successful = true;
        JFileChooser chooser = new JFileChooser(new File("PoseSequences"));
        int approveOption = chooser.showOpenDialog(null);
        if (approveOption != 0) {
            if (chooser.getName() != null) {
                System.err.println("Can not load selected file :" + chooser.getName());
            }
            successful = false;
            return false;
        }
        File selectedFile = chooser.getSelectedFile();
        sequence.clear();
        PlaybackPoseSequenceReader.appendFromFile(sequence, selectedFile);
        this.initPlayback(sequence);
        return successful;
    }

    private void initPlayback(PlaybackPoseSequence sequence) {
        double startTime;
        this.frameByframeTime = startTime = 0.0;
        this.interpolator.startSequencePlayback(sequence, startTime);
        this.interpolator.setTimeDelayAfterPose(0.0);
        this.frameByframePoseNumber = 0;
        this.lastLoadedPoseSequence = sequence;
    }

    private void playLoadedSequence() {
        PlaybackPose morphedPose = this.interpolator.getPose(this.frameByframeTime);
        while (!this.interpolator.isDone()) {
            this.frameByframeTime += this.controlDT;
            this.previousPose = morphedPose = this.interpolator.getPose(this.frameByframeTime);
            this.scs.setTime(this.frameByframeTime);
            this.scs.tickAndUpdate();
            System.out.println("pose #: " + this.frameByframePoseNumber++ + " \t pausing for " + this.interpolator.getNextTransitionTimeDelay());
            if (this.playOnlyOnePose) {
                morphedPose.setRobotAtPose((OneDegreeOfFreedomJointHolder)this.sdfRobot);
                return;
            }
            ThreadTools.sleep((long)((long)(this.controlDT * 1000.0)));
        }
        morphedPose.setRobotAtPose((OneDegreeOfFreedomJointHolder)this.sdfRobot);
        System.out.println("End of Play back");
    }

    private class CaptureSnapshotListener
    implements YoVariableChangedListener {
        private final FullHumanoidRobotModel fullRobotModel;
        private final ModularRobotController controller;

        public CaptureSnapshotListener(FullHumanoidRobotModel fullRobotModel, ModularRobotController controller) {
            this.fullRobotModel = fullRobotModel;
            this.controller = controller;
        }

        public void changed(YoVariable yoVariable) {
            PlaybackPose pose = new PlaybackPose((FullRobotModel)this.fullRobotModel, (OneDegreeOfFreedomJointHolder)PosePlaybackSCSBridge.this.sdfRobot);
            this.visualizeAppendages();
            System.out.println("Adding pose to sequence list: " + String.valueOf(pose));
            PosePlaybackSCSBridge.this.posePlaybackRobotPoseSequence.addPose(pose);
            double dt = 0.01;
            double morphTime = 1.0;
            PlaybackPose morphedPose = pose;
            for (double time = 0.0; time < morphTime; time += dt) {
                double morphPercentage = time / morphTime;
                morphedPose = PosePlaybackSCSBridge.this.previousPose == null ? pose : PlaybackPose.morph(PosePlaybackSCSBridge.this.previousPose, pose, morphPercentage);
                PosePlaybackSCSBridge.this.scs.setTime(time);
                PosePlaybackSCSBridge.this.scs.tickAndUpdate();
            }
            morphedPose.setRobotAtPose((OneDegreeOfFreedomJointHolder)PosePlaybackSCSBridge.this.sdfRobot);
            PosePlaybackSCSBridge.this.previousPose = pose;
        }

        private void visualizeAppendages() {
            PosePlaybackSCSBridge.this.sdfRobot.update();
            this.controller.doControl();
            this.fullRobotModel.updateFrames();
            for (RobotSide robotSide : RobotSide.values()) {
                MovingReferenceFrame ankleFrame = this.fullRobotModel.getFoot((Enum)robotSide).getParentJoint().getFrameAfterJoint();
                FramePoint3D anklePosition = new FramePoint3D((ReferenceFrame)ankleFrame);
                anklePosition.changeFrame(ReferenceFrame.getWorldFrame());
                ((YoFramePoint3D)PosePlaybackSCSBridge.this.anklePositions.get((Enum)robotSide)).set((FrameTuple3DReadOnly)anklePosition);
                MovingReferenceFrame footFrame = this.fullRobotModel.getFoot((Enum)robotSide).getBodyFixedFrame();
                ((YoGraphicCoordinateSystem)PosePlaybackSCSBridge.this.feetCoordinateSystems.get((Enum)robotSide)).setToReferenceFrame((ReferenceFrame)footFrame);
                MovingReferenceFrame wristFrame = this.fullRobotModel.getHand(robotSide).getParentJoint().getFrameAfterJoint();
                FramePoint3D wristPosition = new FramePoint3D((ReferenceFrame)wristFrame);
                wristPosition.changeFrame(ReferenceFrame.getWorldFrame());
                ((YoFramePoint3D)PosePlaybackSCSBridge.this.wristPositions.get((Enum)robotSide)).set((FrameTuple3DReadOnly)wristPosition);
                MovingReferenceFrame handFrame = this.fullRobotModel.getHand(robotSide).getBodyFixedFrame();
                FramePose3D palmPose = new FramePose3D((ReferenceFrame)handFrame);
                FramePoint3D palmPositionWithRespectToHandFrame = new FramePoint3D((ReferenceFrame)handFrame, 0.0, robotSide.negateIfRightSide(0.08), -0.04);
                double yaw = 0.0;
                double pitch = 0.0;
                double roll = robotSide.negateIfLeftSide(0.4);
                FrameQuaternion palmOrientationWithRespectToHandFrame = new FrameQuaternion((ReferenceFrame)handFrame, yaw, pitch, roll);
                palmPose.getPosition().set((FrameTuple3DReadOnly)palmPositionWithRespectToHandFrame);
                palmPose.getOrientation().set((FrameQuaternionReadOnly)palmOrientationWithRespectToHandFrame);
                PoseReferenceFrame palmFrame = new PoseReferenceFrame("palmFrame", (FramePose3DReadOnly)palmPose);
                palmFrame.update();
                ((YoGraphicCoordinateSystem)PosePlaybackSCSBridge.this.handCoordinateSystems.get((Enum)robotSide)).setToReferenceFrame((ReferenceFrame)palmFrame);
            }
        }
    }

    private class SaveSequenceListener
    implements YoVariableChangedListener {
        private SaveSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            if (((YoBoolean)yoVariable).getBooleanValue()) {
                System.out.println("saving file");
                PlaybackPoseSequenceWriter.promptWriteToFile(PosePlaybackSCSBridge.this.posePlaybackRobotPoseSequence);
            }
        }
    }

    private class LoadSequenceFromFileListener
    implements YoVariableChangedListener {
        private final FullRobotModel fullRobotModel;

        public LoadSequenceFromFileListener(FullRobotModel fullRobotModel) {
            this.fullRobotModel = fullRobotModel;
        }

        public void changed(YoVariable yoVariable) {
            if (!((YoBoolean)yoVariable).getBooleanValue()) {
                return;
            }
            System.out.println("Load Sequence");
            boolean selectedFileSuccessful = PosePlaybackSCSBridge.this.initPlaybackFromFile(this.fullRobotModel, new PlaybackPoseSequence(this.fullRobotModel));
            if (!selectedFileSuccessful) {
                return;
            }
            PosePlaybackSCSBridge.this.playOnlyOnePose = false;
            PosePlaybackSCSBridge.this.playLoadedSequence();
        }
    }

    private class ClearSequenceListener
    implements YoVariableChangedListener {
        private ClearSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            PosePlaybackSCSBridge.this.posePlaybackRobotPoseSequence.clear();
            System.out.println("Clearing Sequence");
        }
    }

    private class LoadFrameByFrameSequenceListener
    implements YoVariableChangedListener {
        private LoadFrameByFrameSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            if (!((YoBoolean)yoVariable).getBooleanValue()) {
                return;
            }
            System.out.println("Load Sequence for Frame by Frame Play Back");
            boolean selectedFileSuccessful = PosePlaybackSCSBridge.this.initPlaybackFromFile(PosePlaybackSCSBridge.this.fullRobotModel, PosePlaybackSCSBridge.this.posePlaybackRobotPoseSequence);
            if (!selectedFileSuccessful) {
                return;
            }
            PosePlaybackSCSBridge.this.playOnlyOnePose = true;
            PosePlaybackSCSBridge.this.poseSequenceEditorGUI.setSequence(PosePlaybackSCSBridge.this.posePlaybackRobotPoseSequence);
            PosePlaybackSCSBridge.this.poseSequenceEditorGUI.setVisible(true);
        }
    }

    private class LoadLastSequenceListener
    implements YoVariableChangedListener {
        private LoadLastSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            if (!((YoBoolean)yoVariable).getBooleanValue()) {
                return;
            }
            System.out.println("Load Last Sequence");
            PosePlaybackSCSBridge.this.initPlayback(PosePlaybackSCSBridge.this.lastLoadedPoseSequence);
            PosePlaybackSCSBridge.this.playOnlyOnePose = false;
            PosePlaybackSCSBridge.this.playLoadedSequence();
        }
    }

    private class PlayPoseFromFrameByFrameSequenceListener
    implements YoVariableChangedListener {
        private PlayPoseFromFrameByFrameSequenceListener() {
        }

        public void changed(YoVariable yoVariable) {
            PosePlaybackSCSBridge.this.playLoadedSequence();
        }
    }

    private class ResetToBasePoseListener
    implements YoVariableChangedListener {
        private ResetToBasePoseListener() {
        }

        public void changed(YoVariable yoVariable) {
            if (PosePlaybackSCSBridge.this.sdfRobot != null && PosePlaybackSCSBridge.this.previousPose != null) {
                PosePlaybackSCSBridge.this.previousPose.setRobotAtPose((OneDegreeOfFreedomJointHolder)PosePlaybackSCSBridge.this.sdfRobot);
            }
        }
    }

    private class CenterOfMassGraphicUpdater
    implements Runnable {
        private final Point3D comPoint = new Point3D();
        private final Point3D comPoint2d = new Point3D();

        private CenterOfMassGraphicUpdater() {
        }

        @Override
        public void run() {
            while (true) {
                PosePlaybackSCSBridge.this.sdfRobot.update();
                PosePlaybackSCSBridge.this.sdfRobot.computeCenterOfMass((Point3DBasics)this.comPoint);
                PosePlaybackSCSBridge.this.centerOfMassPosition.set((Tuple3DReadOnly)this.comPoint);
                this.comPoint2d.set(this.comPoint.getX(), this.comPoint.getY(), 0.0);
                PosePlaybackSCSBridge.this.centerOfMassPosition2d.set((Tuple3DReadOnly)this.comPoint2d);
                ThreadTools.sleep((long)100L);
            }
        }
    }
}

