/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseInterpolator;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.avatar.posePlayback.PoseCheckerCallback;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PoseInterpolatorPlaybacker {
    public static void playASequence(HumanoidFloatingRootJointRobot sdfRobot, PlaybackPoseSequence sequence, boolean showGui, PoseCheckerCallback poseCheckerCallback) {
        double startTime;
        YoRegistry registry = new YoRegistry("PoseInterpolatorPlaybacker");
        PlaybackPoseInterpolator interpolator = new PlaybackPoseInterpolator(registry);
        double simulateDT = 0.005;
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)sdfRobot, parameters);
        if (showGui) {
            int recordFrequency = 1;
            scs.setDT(simulateDT, recordFrequency);
            scs.addYoRegistry(registry);
            scs.startOnAThread();
        }
        double time = startTime = 1.7;
        interpolator.startSequencePlayback(sequence, startTime);
        PlaybackPose previousPose = null;
        while (!interpolator.isDone()) {
            scs.setTime(time += simulateDT);
            PlaybackPose pose = interpolator.getPose(time);
            if (showGui) {
                pose.setRobotAtPose((OneDegreeOfFreedomJointHolder)sdfRobot);
                scs.tickAndUpdate();
            }
            poseCheckerCallback.checkPose(pose, previousPose);
            previousPose = pose;
        }
        if (showGui) {
            ThreadTools.sleepForever();
        }
    }
}

