/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.posePlayback;

import us.ihmc.avatar.posePlayback.PlaybackPose;
import us.ihmc.avatar.posePlayback.PlaybackPoseSequence;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class PlaybackPoseInterpolator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoDouble poseStartTime = new YoDouble("poseStartTime", this.registry);
    private final YoDouble poseMorphPercentage = new YoDouble("poseMorphPercentage", this.registry);
    private final YoDouble poseMorphDuration = new YoDouble("poseMorphDuration", this.registry);
    private final YoDouble timeDelayAfterPose = new YoDouble("timeDelayAfterPose", this.registry);
    private final YoInteger poseSequenceIndex = new YoInteger("poseSequenceIndex", this.registry);
    private boolean lastPoseIncrementedSequence = false;
    private final int numberOfCoefficients = 4;
    private final YoPolynomial yoPolynomial = new YoPolynomial("posePolynomial", 4, this.registry);
    private PlaybackPoseSequence sequence;
    private boolean hasBeganInterpolating = false;

    public PlaybackPoseInterpolator(YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
    }

    public void startSequencePlayback(PlaybackPoseSequence sequence, double startTime) {
        this.sequence = sequence;
        PlaybackPose pose = sequence.getPose(0);
        this.setMorphDuration(pose.getPlayBackDuration());
        this.setTimeDelayAfterPose(pose.getPlayBackDelayBeforePose());
        this.setupPolynomialSpline(startTime, this.poseMorphDuration.getDoubleValue());
        this.poseStartTime.set(startTime);
        this.poseSequenceIndex.set(0);
        this.hasBeganInterpolating = true;
    }

    public void setMorphDuration(double morphDuration) {
        this.poseMorphDuration.set(morphDuration);
    }

    public void setTimeDelayAfterPose(double timeDelay) {
        this.timeDelayAfterPose.set(timeDelay);
    }

    private void setupPolynomialSpline(double time, double duration) {
        this.yoPolynomial.setCubic(time, time + duration, 0.0, 0.0, 1.0, 0.0);
    }

    public PlaybackPose getPose(double time) {
        double timeIntoPose = time - this.poseStartTime.getDoubleValue();
        int index = this.poseSequenceIndex.getIntegerValue();
        if (this.isDone()) {
            return this.sequence.getFinalPose();
        }
        PlaybackPose poseOne = this.sequence.getPose(index);
        PlaybackPose poseTwo = this.sequence.getPose(this.poseSequenceIndex.getIntegerValue() + 1);
        this.poseMorphPercentage.set(timeIntoPose / this.poseMorphDuration.getDoubleValue());
        PlaybackPose morphedPose = PlaybackPose.morph(poseOne, poseTwo, this.poseMorphPercentage.getDoubleValue());
        if (this.poseMorphPercentage.getDoubleValue() >= 1.0 && timeIntoPose >= this.transitionTime(poseTwo)) {
            this.poseSequenceIndex.increment();
            this.poseStartTime.set(time);
            this.lastPoseIncrementedSequence = true;
        } else {
            this.lastPoseIncrementedSequence = false;
        }
        return morphedPose;
    }

    private double transitionTime(PlaybackPose poseToTransitionInto) {
        return this.poseMorphDuration.getDoubleValue() + this.timeDelayAfterPose.getDoubleValue() + Conversions.millisecondsToSeconds((double)((long)poseToTransitionInto.getPlayBackDelayBeforePose()));
    }

    public double getTransitionTimeDelay() {
        return this.sequence.getPose(this.poseSequenceIndex.getIntegerValue()).getPlayBackDelayBeforePose();
    }

    public double getNextTransitionTimeDelay() {
        return this.sequence.getPose(this.poseSequenceIndex.getIntegerValue() + 1).getPlayBackDelayBeforePose();
    }

    public boolean didLastPoseIncrementSequence() {
        return this.lastPoseIncrementedSequence;
    }

    public boolean isDone() {
        if (this.sequence == null) {
            return false;
        }
        return this.poseSequenceIndex.getIntegerValue() >= this.sequence.getNumberOfPoses() - 1;
    }

    public boolean hasBeganInterpolating() {
        return this.hasBeganInterpolating;
    }

    public void reset() {
        this.sequence = null;
        this.hasBeganInterpolating = false;
    }
}

