/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import toolbox_msgs.msg.dds.WholeBodyTrajectoryToolboxMessage;
import toolbox_msgs.msg.dds.WholeBodyTrajectoryToolboxOutputStatus;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxCommandConverter;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.WholeBodyTrajectoryToolboxController;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.ReachingManifoldCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.RigidBodyExplorationConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WaypointBasedTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WholeBodyTrajectoryToolboxConfigurationCommand;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class WholeBodyTrajectoryToolboxModule
extends ToolboxModule {
    private final WholeBodyTrajectoryToolboxController wholeBodyTrajectoryToolboxController;

    public WholeBodyTrajectoryToolboxModule(DRCRobotModel drcRobotModel, boolean startYoVariableServer) throws IOException {
        super(drcRobotModel.getSimpleRobotName(), drcRobotModel.createFullRobotModel(), drcRobotModel.getLogModelProvider(), startYoVariableServer, 1);
        this.setTimeWithoutInputsBeforeGoingToSleep(Double.POSITIVE_INFINITY);
        this.wholeBodyTrajectoryToolboxController = new WholeBodyTrajectoryToolboxController(drcRobotModel, this.fullRobotModel, this.commandInputManager, this.statusOutputManager, this.registry, this.yoGraphicsListRegistry, startYoVariableServer);
        this.controllerNetworkSubscriber.registerSubcriberWithMessageUnpacker(WholeBodyTrajectoryToolboxMessage.class, 10, MessageUnpackingTools.createWholeBodyTrajectoryToolboxMessageUnpacker());
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)new WholeBodyTrajectoryToolboxCommandConverter(this.fullRobotModel));
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.wholeBodyTrajectoryToolboxController;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return WholeBodyTrajectoryToolboxModule.supportedCommands();
    }

    static List<Class<? extends Command<?, ?>>> supportedCommands() {
        ArrayList commands = new ArrayList();
        commands.add(WaypointBasedTrajectoryCommand.class);
        commands.add(RigidBodyExplorationConfigurationCommand.class);
        commands.add(ReachingManifoldCommand.class);
        commands.add(WholeBodyTrajectoryToolboxConfigurationCommand.class);
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return WholeBodyTrajectoryToolboxModule.supportedStatus();
    }

    static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(WholeBodyTrajectoryToolboxOutputStatus.class);
        return status;
    }

    @Override
    public Set<Class<? extends Command<?, ?>>> silentCommands() {
        HashSet commands = new HashSet();
        commands.add(WaypointBasedTrajectoryCommand.class);
        commands.add(RigidBodyExplorationConfigurationCommand.class);
        commands.add(ReachingManifoldCommand.class);
        commands.add(WholeBodyTrajectoryToolboxConfigurationCommand.class);
        return commands;
    }

    public ROS2Topic getOutputTopic() {
        return WholeBodyTrajectoryToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic getOutputTopic(String robotName) {
        return ToolboxAPIs.WHOLE_BODY_TRAJECTORY_TOOLBOX.withRobot(robotName).withOutput();
    }

    public ROS2Topic getInputTopic() {
        return WholeBodyTrajectoryToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic getInputTopic(String robotName) {
        return ToolboxAPIs.WHOLE_BODY_TRAJECTORY_TOOLBOX.withRobot(robotName).withInput();
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ROS2Topic controllerOutputTopic = HumanoidControllerAPI.getOutputTopic((String)this.robotName);
        ros2Node.createSubscription(controllerOutputTopic.withTypeName(RobotConfigurationData.class), s -> {
            if (this.wholeBodyTrajectoryToolboxController != null) {
                this.wholeBodyTrajectoryToolboxController.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
    }
}

