/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import toolbox_msgs.msg.dds.KinematicsToolboxRigidBodyMessage;
import us.ihmc.avatar.networkProcessor.wholeBodyTrajectoryToolboxModule.ConstrainedRigidBodyTrajectory;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.wholeBodyTrajectory.ConfigurationSpaceName;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.ReachingManifoldCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.RigidBodyExplorationConfigurationCommand;
import us.ihmc.humanoidRobotics.communication.wholeBodyTrajectoryToolboxAPI.WaypointBasedTrajectoryCommand;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialData;
import us.ihmc.manipulation.planning.exploringSpatial.SpatialNode;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;

public class WholeBodyTrajectoryToolboxData {
    private static final boolean VERBOSE = true;
    private final FullHumanoidRobotModel fullRobotModel;
    private double trajectoryTime;
    private int dimensionOfExploration = 0;
    private final List<RigidBodyBasics> allRigidBodies = new ArrayList<RigidBodyBasics>();
    private final Map<String, RigidBodyBasics> nameToRigidBodyMap = new HashMap<String, RigidBodyBasics>();
    private final Map<RigidBodyBasics, ConstrainedRigidBodyTrajectory> rigidBodyDataMap = new HashMap<RigidBodyBasics, ConstrainedRigidBodyTrajectory>();
    private final List<ReachingManifoldCommand> reachingManifolds;

    public WholeBodyTrajectoryToolboxData(FullHumanoidRobotModel fullRobotModel, List<WaypointBasedTrajectoryCommand> endEffectorTrajectories, List<ReachingManifoldCommand> reachingManifolds, List<RigidBodyExplorationConfigurationCommand> explorationConfigurations) {
        this.fullRobotModel = fullRobotModel;
        this.reachingManifolds = reachingManifolds;
        HashMap<RigidBodyBasics, RigidBodyExplorationConfigurationCommand> explorationMap = new HashMap<RigidBodyBasics, RigidBodyExplorationConfigurationCommand>();
        HashMap<RigidBodyBasics, WaypointBasedTrajectoryCommand> trajectoryMap = new HashMap<RigidBodyBasics, WaypointBasedTrajectoryCommand>();
        for (int i = 0; i < explorationConfigurations.size(); ++i) {
            RigidBodyExplorationConfigurationCommand exp = explorationConfigurations.get(i);
            explorationMap.put(exp.getRigidBody(), exp);
        }
        HashSet rigidBodySet = new HashSet(explorationMap.keySet());
        if (endEffectorTrajectories != null) {
            int i;
            this.trajectoryTime = 0.0;
            for (i = 0; i < endEffectorTrajectories.size(); ++i) {
                this.trajectoryTime = Math.max(this.trajectoryTime, endEffectorTrajectories.get(i).getLastWaypointTime());
            }
            for (i = 0; i < endEffectorTrajectories.size(); ++i) {
                WaypointBasedTrajectoryCommand traj = endEffectorTrajectories.get(i);
                trajectoryMap.put(traj.getEndEffector(), traj);
            }
            rigidBodySet.addAll(trajectoryMap.keySet());
        } else if (reachingManifolds != null) {
            this.trajectoryTime = 25.0;
        } else {
            PrintTools.info((String)"no trajectory or manifold");
        }
        this.allRigidBodies.addAll(rigidBodySet);
        this.allRigidBodies.forEach(body -> this.nameToRigidBodyMap.put(body.getName(), (RigidBodyBasics)body));
        for (RigidBodyBasics rigidBody : this.allRigidBodies) {
            WaypointBasedTrajectoryCommand trajectory = trajectoryMap.isEmpty() ? null : (WaypointBasedTrajectoryCommand)trajectoryMap.get(rigidBody);
            RigidBodyExplorationConfigurationCommand exploration = (RigidBodyExplorationConfigurationCommand)explorationMap.get(rigidBody);
            if (exploration == null) {
                exploration = new RigidBodyExplorationConfigurationCommand(rigidBody, new ConfigurationSpaceName[0]);
            }
            String message = "Received for rigid body: " + rigidBody.getName();
            if (trajectory != null) {
                message = message + " a trajectory request";
            }
            if (exploration != null) {
                message = message + " an exploration request";
            }
            PrintTools.info((String)message);
            ConstrainedRigidBodyTrajectory constrainedRigidBodyTrajectory = null;
            for (RigidBodyBasics candidateRigidBody : fullRobotModel.getElevator().subtreeIterable()) {
                if (candidateRigidBody.getName() != rigidBody.getName()) continue;
                constrainedRigidBodyTrajectory = new ConstrainedRigidBodyTrajectory(candidateRigidBody, trajectory, exploration);
                break;
            }
            if (constrainedRigidBodyTrajectory == null) {
                PrintTools.info((String)("fullrobot model has no " + String.valueOf(rigidBody)));
            }
            this.rigidBodyDataMap.put(rigidBody, constrainedRigidBodyTrajectory);
            this.dimensionOfExploration += exploration.getNumberOfDegreesOfFreedomToExplore();
        }
        PrintTools.info((String)("Total exploration dimension is " + this.dimensionOfExploration));
    }

    public SpatialData createRandomInitialSpatialData() {
        SpatialData spatialData = new SpatialData();
        for (int i = 0; i < this.allRigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.allRigidBodies.get(i);
            if (!this.rigidBodyDataMap.get(rigidBody).hasTrajectoryCommand()) continue;
            this.rigidBodyDataMap.get(rigidBody).appendRandomSpatial(spatialData);
        }
        return spatialData;
    }

    public SpatialData createRandomSpatialData() {
        SpatialData spatialData = new SpatialData();
        for (int i = 0; i < this.allRigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.allRigidBodies.get(i);
            this.rigidBodyDataMap.get(rigidBody).appendRandomSpatial(spatialData);
        }
        return spatialData;
    }

    public List<KinematicsToolboxRigidBodyMessage> createMessages(SpatialNode node) {
        ArrayList<KinematicsToolboxRigidBodyMessage> messages = new ArrayList<KinematicsToolboxRigidBodyMessage>();
        double timeInTrajectory = node.getTime();
        for (int i = 0; i < node.getSize(); ++i) {
            RigidBodyBasics rigidBody = this.nameToRigidBodyMap.get(node.getName(i));
            Pose3D poseToAppend = node.getSpatialData(i);
            KinematicsToolboxRigidBodyMessage message = this.rigidBodyDataMap.get(rigidBody).createMessage(timeInTrajectory, poseToAppend);
            messages.add(message);
        }
        return messages;
    }

    public double getMaximumDistanceFromManifolds(SpatialNode node) {
        double distance = Double.MAX_VALUE;
        for (int j = 0; j < this.reachingManifolds.size(); ++j) {
            for (int i = 0; i < node.getSpatialData().getRigidBodySpatials().size(); ++i) {
                if (!((String)node.getSpatialData().getRigidBodyNames().get(i)).equals(this.reachingManifolds.get(j).getRigidBody().getName())) continue;
                ReachingManifoldCommand manifold = this.reachingManifolds.get(j);
                RigidBodyBasics rigidBody = this.nameToRigidBodyMap.get(node.getName(i));
                Pose3D currentSpatial = this.rigidBodyDataMap.get(rigidBody).getPoseToWorldFrame(node.getSpatialData(i));
                Object closestPose = null;
                distance = currentSpatial.getPosition().distance((Point3DReadOnly)closestPose.getPosition());
            }
        }
        return distance;
    }

    public Pose3D getTestFrame(SpatialNode node) {
        for (int j = 0; j < this.reachingManifolds.size(); ++j) {
            for (int i = 0; i < node.getSpatialData().getRigidBodySpatials().size(); ++i) {
                if (!((String)node.getSpatialData().getRigidBodyNames().get(i)).equals(this.reachingManifolds.get(j).getRigidBody().getName())) continue;
                ReachingManifoldCommand manifold = this.reachingManifolds.get(j);
                RigidBodyBasics rigidBody = this.nameToRigidBodyMap.get(node.getName(i));
                Pose3D currentSpatial = this.rigidBodyDataMap.get(rigidBody).getPoseToWorldFrame(node.getSpatialData(i));
                Pose3D closestPose = null;
                return closestPose;
            }
        }
        return null;
    }

    public void holdConfiguration(FullHumanoidRobotModel fullRobotModel) {
        for (int i = 0; i < this.allRigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.allRigidBodies.get(i);
            for (RigidBodyBasics candidateRigidBody : fullRobotModel.getElevator().subtreeIterable()) {
                if (candidateRigidBody.getName() != rigidBody.getName()) continue;
                this.rigidBodyDataMap.get(rigidBody).holdConfiguration(candidateRigidBody);
            }
        }
    }

    public void updateInitialConfiguration() {
        for (int i = 0; i < this.allRigidBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.allRigidBodies.get(i);
            this.rigidBodyDataMap.get(rigidBody).updateInitialResult();
        }
    }

    public double getTrajectoryTime() {
        return this.trajectoryTime;
    }

    public int getExplorationDimension() {
        return this.dimensionOfExploration;
    }
}

