/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.walkingPreview;

import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.WalkingStatusMessage;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewContactStateHolder;
import us.ihmc.avatar.networkProcessor.walkingPreview.WalkingPreviewTask;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.PlaneContactState;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.SettableFootSwitch;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;

public class FootstepListPreviewTask
implements WalkingPreviewTask {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FloatingJointReadOnly rootJoint;
    private final FootstepDataListCommand footstepList;
    private final CommandInputManager walkingInputManager;
    private final StatusMessageOutputManager walkingOutputManager;
    private int numberOfFootstepsRemaining;
    private final AtomicReference<WalkingStatus> latestWalkingStatus = new AtomicReference<Object>(null);
    private StatusMessageOutputManager.StatusMessageListener<FootstepStatusMessage> footstepStatusMessageListener = this::processFootstepStatus;
    private StatusMessageOutputManager.StatusMessageListener<WalkingStatusMessage> walkingStatusMessageListener = this::processWalkingStatus;
    private final SideDependentList<YoPlaneContactState> footContactStates;
    private final SideDependentList<WalkingPreviewContactStateHolder> contactStateHolders = new SideDependentList();
    private final InverseDynamicsCommandList commandList = new InverseDynamicsCommandList();
    private final SideDependentList<SettableFootSwitch> footSwitches;
    private RobotSide currentSwingSide = null;
    private final BalanceManager balanceManager;

    public FootstepListPreviewTask(FloatingJointReadOnly rootJoint, FootstepDataListCommand footstepList, CommandInputManager walkingInputManager, StatusMessageOutputManager walkingOutputManager, SideDependentList<YoPlaneContactState> footContactStates, BalanceManager balanceManager, SideDependentList<SettableFootSwitch> footSwitchesToUpdate) {
        this.rootJoint = rootJoint;
        this.footstepList = footstepList;
        this.walkingInputManager = walkingInputManager;
        this.walkingOutputManager = walkingOutputManager;
        this.footContactStates = footContactStates;
        this.balanceManager = balanceManager;
        this.footSwitches = footSwitchesToUpdate;
    }

    public void onEntry() {
        for (RobotSide robotSide : RobotSide.values) {
            if (this.contactStateHolders.get((Enum)robotSide) != null) {
                ((WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)robotSide)).clearFrames();
            }
            this.contactStateHolders.put((Enum)robotSide, (Object)WalkingPreviewContactStateHolder.holdAtCurrent(robotSide.getSideNameFirstLowerCaseLetter() + "_step_preview", (PlaneContactState)this.footContactStates.get((Enum)robotSide)));
        }
        this.walkingInputManager.submitCommand((Command)this.footstepList);
        this.numberOfFootstepsRemaining = this.footstepList.getNumberOfFootsteps();
        this.walkingOutputManager.attachStatusMessageListener(FootstepStatusMessage.class, this.footstepStatusMessageListener);
        this.walkingOutputManager.attachStatusMessageListener(WalkingStatusMessage.class, this.walkingStatusMessageListener);
    }

    private void processFootstepStatus(FootstepStatusMessage statusMessage) {
        RobotSide side = RobotSide.fromByte((byte)statusMessage.getRobotSide());
        FootstepStatus status = FootstepStatus.fromByte((byte)statusMessage.getFootstepStatus());
        FramePose3D desiredFootstep = new FramePose3D(worldFrame, (Tuple3DReadOnly)statusMessage.getDesiredFootPositionInWorld(), (Orientation3DReadOnly)statusMessage.getDesiredFootOrientationInWorld());
        switch (status) {
            case STARTED: {
                if (this.contactStateHolders.get((Enum)side) != null) {
                    ((WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)side)).clearFrames();
                }
                this.contactStateHolders.put((Enum)side, null);
                ((SettableFootSwitch)this.footSwitches.get((Enum)side)).setFootContactState(false);
                this.currentSwingSide = side;
                break;
            }
            case COMPLETED: {
                --this.numberOfFootstepsRemaining;
                if (this.contactStateHolders.get((Enum)side) != null) {
                    ((WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)side)).clearFrames();
                }
                this.contactStateHolders.put((Enum)side, (Object)new WalkingPreviewContactStateHolder(side.getSideNameFirstLowerCaseLetter() + "_step_complete", (PlaneContactState)this.footContactStates.get((Enum)side), (FramePose3DReadOnly)desiredFootstep));
                this.currentSwingSide = null;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected status: " + String.valueOf(status));
            }
        }
    }

    private void processWalkingStatus(WalkingStatusMessage status) {
        this.latestWalkingStatus.set(WalkingStatus.fromByte((byte)status.getWalkingStatus()));
    }

    public void doAction(double timeInState) {
        this.commandList.clear();
        for (RobotSide robotSide : RobotSide.values) {
            WalkingPreviewContactStateHolder contactStateHolder = (WalkingPreviewContactStateHolder)this.contactStateHolders.get((Enum)robotSide);
            if (contactStateHolder == null) continue;
            contactStateHolder.doControl();
            this.commandList.addCommand(contactStateHolder.getOutput());
        }
        if (this.currentSwingSide != null && this.balanceManager.isICPPlanDone()) {
            ((SettableFootSwitch)this.footSwitches.get((Enum)this.currentSwingSide)).setFootContactState(true);
        }
    }

    public void onExit(double timeInState) {
        this.destroyListeners();
    }

    public boolean isDone(double timeInState) {
        if (this.numberOfFootstepsRemaining > 0) {
            return false;
        }
        if (this.latestWalkingStatus.get() == null) {
            return false;
        }
        return this.latestWalkingStatus.get() == WalkingStatus.COMPLETED && this.rootJoint.getJointTwist().getLinearPart().length() < 0.005;
    }

    @Override
    public InverseDynamicsCommand<?> getOutput() {
        return this.commandList;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyListeners();
    }

    private void destroyListeners() {
        if (this.footstepStatusMessageListener != null) {
            this.walkingOutputManager.detachStatusMessageListener(FootstepStatusMessage.class, this.footstepStatusMessageListener);
            this.footstepStatusMessageListener = null;
        }
        if (this.walkingStatusMessageListener != null) {
            this.walkingOutputManager.detachStatusMessageListener(WalkingStatusMessage.class, this.walkingStatusMessageListener);
            this.walkingStatusMessageListener = null;
        }
    }
}

