/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.trackingCameraPublisher;

import controller_msgs.msg.dds.RobotConfigurationData;
import geometry_msgs.Point;
import geometry_msgs.Pose;
import geometry_msgs.Quaternion;
import geometry_msgs.Vector3;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import nav_msgs.Odometry;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.StateEstimatorAPI;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.robotics.kinematics.TimeStampedTransform3D;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RosNavMsgsOdometrySubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class TrackingCameraBridge {
    private static final boolean Debug = false;
    private final String name = this.getClass().getSimpleName();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadTools.createNamedThreadFactory((String)this.name));
    private ScheduledFuture<?> publisherTask;
    private final AtomicReference<TrackingCameraData> trackingCameraDataToPublish = new AtomicReference<Object>(null);
    private final AtomicReference<StampedPosePacket> stampedPosePacketToPublish = new AtomicReference<Object>(null);
    private final FullRobotModel fullRobotModel;
    private SensorFrameInitializationTransformer sensorFrameInitializationTransformer = null;
    private final RigidBodyTransform initialTransformToWorld = new RigidBodyTransform();
    private boolean initialized = false;
    private final RobotConfigurationDataBuffer robotConfigurationDataBuffer = new RobotConfigurationDataBuffer();
    private RobotROSClockCalculator rosClockCalculator = null;
    private final Consumer<StampedPosePacket> stampedPosePacketPublisher;

    public TrackingCameraBridge(FullRobotModelFactory modelFactory, ROS2Node ros2Node) {
        this(modelFactory.getRobotDefinition().getName(), modelFactory.createFullRobotModel(), ros2Node);
    }

    public TrackingCameraBridge(String robotName, FullRobotModel fullRobotModel, ROS2Node ros2Node) {
        this.fullRobotModel = fullRobotModel;
        ros2Node.createSubscription(StateEstimatorAPI.getRobotConfigurationDataTopic((String)robotName).withTypeName(RobotConfigurationData.class), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
        this.stampedPosePacketPublisher = arg_0 -> ((ROS2Publisher)ros2Node.createPublisher(PerceptionAPI.T265_POSE)).publish(arg_0);
    }

    public TrackingCameraBridge(String robotName, FullRobotModel fullRobotModel, RealtimeROS2Node realtimeROS2Node) {
        this.fullRobotModel = fullRobotModel;
        realtimeROS2Node.createSubscription(StateEstimatorAPI.getRobotConfigurationDataTopic((String)robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
        this.stampedPosePacketPublisher = arg_0 -> ((ROS2Publisher)realtimeROS2Node.createPublisher(PerceptionAPI.T265_POSE)).publish(arg_0);
    }

    public void start() {
        this.publisherTask = this.executorService.scheduleAtFixedRate(this::readAndPublishInternal, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.publisherTask.cancel(false);
        this.executorService.shutdownNow();
    }

    public void receiveTrackingCameraDataFromROS1(String trackingCameraDataROSTopic, RosMainNode rosMainNode) {
        rosMainNode.attachSubscriber(trackingCameraDataROSTopic, (RosTopicSubscriberInterface)this.createNavigationMessageSubscriber());
    }

    public void setROSClockCalculator(RobotROSClockCalculator rosClockCalculator) {
        this.rosClockCalculator = rosClockCalculator;
    }

    public void setCustomInitializationTransformer(SensorFrameInitializationTransformer transformer) {
        this.sensorFrameInitializationTransformer = transformer;
    }

    private RosNavMsgsOdometrySubscriber createNavigationMessageSubscriber() {
        return new RosNavMsgsOdometrySubscriber(){

            public void onNewMessage(Odometry message) {
                long timeStamp = message.getHeader().getStamp().totalNsecs();
                Pose pose = message.getPose().getPose();
                Vector3 linearVelocity = message.getTwist().getTwist().getLinear();
                Vector3 angularVelocity = message.getTwist().getTwist().getAngular();
                TrackingCameraData trackingCameraData = new TrackingCameraData();
                trackingCameraData.setTimeStamp(timeStamp);
                trackingCameraData.setConfidence(1.0);
                trackingCameraData.setPosition(pose.getPosition());
                trackingCameraData.setOrientation(pose.getOrientation());
                trackingCameraData.setLinearVelocity(linearVelocity);
                trackingCameraData.setAngularVelocity(angularVelocity);
                TrackingCameraBridge.this.trackingCameraDataToPublish.set(trackingCameraData);
            }

            protected void newPose(String frameID, TimeStampedTransform3D transform) {
            }
        };
    }

    public void readAndPublish() {
        if (this.publisherTask != null) {
            throw new RuntimeException("The publisher is running using its own thread, cannot manually update it.");
        }
        this.readAndPublishInternal();
    }

    private void readAndPublishInternal() {
        try {
            this.transformDataAndPublish();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.executorService.shutdown();
        }
    }

    private void transformDataAndPublish() {
        TrackingCameraData dataToPublish = this.trackingCameraDataToPublish.getAndSet(null);
        if (dataToPublish == null) {
            return;
        }
        if (this.rosClockCalculator == null) {
            long robotTimestamp = dataToPublish.getTimeStamp();
            this.robotConfigurationDataBuffer.updateFullRobotModelWithNewestData(this.fullRobotModel, null);
        } else {
            boolean success;
            long rosTimestamp = dataToPublish.getTimeStamp();
            long robotTimestamp = this.rosClockCalculator.computeRobotMonotonicTime(rosTimestamp);
            boolean waitForTimestamp = true;
            if (this.robotConfigurationDataBuffer.getNewestTimestamp() == -1L) {
                return;
            }
            boolean bl = success = this.robotConfigurationDataBuffer.updateFullRobotModel(waitForTimestamp, robotTimestamp, this.fullRobotModel, null) != -1L;
            if (!success) {
                return;
            }
        }
        if (!this.initialized && this.sensorFrameInitializationTransformer != null) {
            this.initialized = true;
            this.sensorFrameInitializationTransformer.computeTransformToWorld(this.fullRobotModel, this.initialTransformToWorld);
            this.computeTrackingCameraInitialTransform(this.initialTransformToWorld, dataToPublish);
            return;
        }
        dataToPublish.applyTransform(this.initialTransformToWorld);
        StampedPosePacket message = dataToPublish.toPacket();
        this.stampedPosePacketToPublish.set(message);
        this.stampedPosePacketPublisher.accept(message);
    }

    public StampedPosePacket pollNewData() {
        return this.stampedPosePacketToPublish.getAndSet(null);
    }

    private void computeTrackingCameraInitialTransform(RigidBodyTransform initialTransformToWorld, TrackingCameraData initialTrackingCameraData) {
        initialTransformToWorld.multiplyInvertOther((RigidBodyTransformReadOnly)new RigidBodyTransform((Orientation3DReadOnly)initialTrackingCameraData.orientation, (Tuple3DReadOnly)initialTrackingCameraData.position));
    }

    public static interface SensorFrameInitializationTransformer {
        public void computeTransformToWorld(FullRobotModel var1, RigidBodyTransform var2);
    }

    private class TrackingCameraData {
        long timeStamp;
        double confidence;
        Point3D position = new Point3D();
        us.ihmc.euclid.tuple4D.Quaternion orientation = new us.ihmc.euclid.tuple4D.Quaternion();
        Vector3D linearVelocity = new Vector3D();
        Vector3D angularVelocity = new Vector3D();

        private TrackingCameraData() {
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public void setConfidence(double confidence) {
            this.confidence = confidence;
        }

        public void setOrientation(Quaternion quaternion) {
            this.orientation.set(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getW());
        }

        public void setPosition(Point position) {
            this.position.set(position.getX(), position.getY(), position.getZ());
        }

        public void setLinearVelocity(Vector3 linearVelocity) {
            this.linearVelocity.set(linearVelocity.getX(), linearVelocity.getY(), linearVelocity.getZ());
        }

        public void setAngularVelocity(Vector3 angularVelocity) {
            this.angularVelocity.set(angularVelocity.getX(), angularVelocity.getY(), angularVelocity.getZ());
        }

        public void applyTransform(RigidBodyTransform transformToWorld) {
            transformToWorld.transform((Point3DBasics)this.position);
            transformToWorld.transform((Orientation3DBasics)this.orientation);
            transformToWorld.transform((Vector3DBasics)this.linearVelocity);
            transformToWorld.transform((Vector3DBasics)this.angularVelocity);
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public StampedPosePacket toPacket() {
            StampedPosePacket message = new StampedPosePacket();
            message.getPose().getPosition().set(this.position);
            message.getPose().getOrientation().set(this.orientation);
            message.getTwist().getLinear().set(this.linearVelocity);
            message.getTwist().getAngular().set(this.angularVelocity);
            message.setTimestamp(this.timeStamp);
            message.setConfidenceFactor(this.confidence);
            return message;
        }
    }
}

