/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.stepConstraintToolboxModule;

import controller_msgs.msg.dds.CapturabilityBasedStatus;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.StepConstraintMessage;
import java.util.ArrayList;
import java.util.List;
import perception_msgs.msg.dds.PlanarRegionMessage;
import perception_msgs.msg.dds.PlanarRegionsListMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.stepConstraintToolboxModule.StepConstraintToolboxController;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.communication.ToolboxAPIs;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.robotDataLogger.RobotVisualizer;
import us.ihmc.robotDataLogger.util.JVMStatisticsGenerator;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;

public class StepConstraintToolboxModule
extends ToolboxModule {
    private static final int DEFAULT_UPDATE_PERIOD_MILLISECONDS = 10;
    protected final StepConstraintToolboxController controller;
    private ROS2Publisher<StepConstraintMessage> constraintRegionPublisher;

    public StepConstraintToolboxModule(DRCRobotModel robotModel, boolean startYoVariableServer, double gravityZ) {
        super(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), startYoVariableServer, 10);
        this.setTimeWithoutInputsBeforeGoingToSleep(Double.POSITIVE_INFINITY);
        this.controller = new StepConstraintToolboxController(this.statusOutputManager, this.constraintRegionPublisher, robotModel.getWalkingControllerParameters(), this.fullRobotModel, gravityZ, this.registry, this.yoGraphicsListRegistry);
        this.startYoVariableServer();
        if (this.yoVariableServer != null) {
            JVMStatisticsGenerator jvmStatisticsGenerator = new JVMStatisticsGenerator((RobotVisualizer)this.yoVariableServer);
            jvmStatisticsGenerator.start();
        }
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ROS2Topic controllerPubGenerator = HumanoidControllerAPI.getOutputTopic((String)this.robotName);
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(RobotConfigurationData.class), s -> {
            if (this.controller != null) {
                this.controller.updateRobotConfigurationData((RobotConfigurationData)s.takeNextData());
            }
        });
        RobotConfigurationData robotConfigurationData = new RobotConfigurationData();
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(RobotConfigurationData.class), s -> {
            if (this.controller != null) {
                s.takeNextData((Object)robotConfigurationData, null);
                this.controller.updateRobotConfigurationData(robotConfigurationData);
            }
        });
        CapturabilityBasedStatus capturabilityBasedStatus = new CapturabilityBasedStatus();
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(CapturabilityBasedStatus.class), s -> {
            if (this.controller != null) {
                s.takeNextData((Object)capturabilityBasedStatus, null);
                this.controller.updateCapturabilityBasedStatus(capturabilityBasedStatus);
            }
        });
        FootstepStatusMessage statusMessage = new FootstepStatusMessage();
        ros2Node.createSubscription(controllerPubGenerator.withTypeName(FootstepStatusMessage.class), s -> {
            if (this.controller != null) {
                s.takeNextData((Object)statusMessage, null);
                this.controller.updateFootstepStatus(statusMessage);
            }
        });
        ros2Node.createSubscription(REACommunicationProperties.outputTopic.withTypeName(PlanarRegionsListMessage.class), s -> this.updatePlanarRegion((PlanarRegionsListMessage)s.takeNextData()));
        this.constraintRegionPublisher = ros2Node.createPublisher(HumanoidControllerAPI.getInputTopic((String)this.robotName).withTypeName(StepConstraintMessage.class));
    }

    public void setSwitchPlanarRegionConstraintsAutomatically(boolean switchAutomatically) {
        this.controller.setSwitchPlanarRegionConstraintsAutomatically(switchAutomatically);
    }

    public void updatePlanarRegion(PlanarRegionsListMessage planarRegionsListMessage) {
        if (this.controller != null) {
            this.controller.updatePlanarRegions(planarRegionsListMessage);
        }
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        return new ArrayList();
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return StepConstraintToolboxModule.supportedStatus();
    }

    public static List<Class<? extends Settable<?>>> supportedStatus() {
        ArrayList status = new ArrayList();
        status.add(PlanarRegionsListMessage.class);
        status.add(PlanarRegionMessage.class);
        return status;
    }

    public ROS2Topic getOutputTopic() {
        return StepConstraintToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic getOutputTopic(String robotName) {
        return ToolboxAPIs.STEP_CONSTRAINT_TOOLBOX.withRobot(robotName).withOutput();
    }

    public ROS2Topic getInputTopic() {
        return StepConstraintToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic getInputTopic(String robotName) {
        return ToolboxAPIs.STEP_CONSTRAINT_TOOLBOX.withRobot(robotName).withInput();
    }
}

