/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.reaStateUpdater;

import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import controller_msgs.msg.dds.WalkingStatusMessage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import perception_msgs.msg.dds.REAStateRequestMessage;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.HumanoidControllerAPI;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.ros2.ROS2NodeBuilder;
import us.ihmc.ros2.ROS2Publisher;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.tools.thread.CloseableAndDisposable;

public class HumanoidAvatarStereoREAStateUpdater
implements CloseableAndDisposable {
    private final RealtimeROS2Node ros2Node;
    private final ROS2Publisher<REAStateRequestMessage> reaStateRequestPublisher;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(ThreadTools.createNamedThreadFactory((String)this.getClass().getSimpleName()));
    private final REAStateRequestMessage clearRequestMessage = new REAStateRequestMessage();
    private final REAStateRequestMessage pauseRequestMessage = new REAStateRequestMessage();
    private final REAStateRequestMessage resumeRequestMessage = new REAStateRequestMessage();
    private final REAStateRequestMessage clearAndResumeRequestMessage = new REAStateRequestMessage();

    public HumanoidAvatarStereoREAStateUpdater(DRCRobotModel robotModel) {
        this(robotModel, REACommunicationProperties.inputTopic);
    }

    public HumanoidAvatarStereoREAStateUpdater(DRCRobotModel robotModel, ROS2Topic<?> inputTopic) {
        String robotName = robotModel.getSimpleRobotName();
        this.clearRequestMessage.setRequestClear(true);
        this.pauseRequestMessage.setRequestPause(true);
        this.resumeRequestMessage.setRequestResume(true);
        this.clearAndResumeRequestMessage.setRequestClear(true);
        this.clearAndResumeRequestMessage.setRequestResume(true);
        this.ros2Node = new ROS2NodeBuilder().buildRealtime("avatar_rea_state_updater");
        this.reaStateRequestPublisher = this.ros2Node.createPublisher(inputTopic.withTypeName(REAStateRequestMessage.class));
        this.ros2Node.createSubscription(HumanoidControllerAPI.getOutputTopic((String)robotName).withTypeName(HighLevelStateChangeStatusMessage.class), this::handleHighLevelStateChangeMessage);
        this.ros2Node.createSubscription(HumanoidControllerAPI.getOutputTopic((String)robotName).withTypeName(WalkingStatusMessage.class), this::handleWalkingStatusMessage);
        this.ros2Node.spin();
    }

    private void handleHighLevelStateChangeMessage(Subscriber<HighLevelStateChangeStatusMessage> subscriber) {
        if (this.executorService.isShutdown()) {
            return;
        }
        HighLevelStateChangeStatusMessage newMessage = (HighLevelStateChangeStatusMessage)subscriber.takeNextData();
        if (newMessage.getInitialHighLevelControllerName() == newMessage.getEndHighLevelControllerName()) {
            return;
        }
        switch (HighLevelControllerName.fromByte((byte)newMessage.getEndHighLevelControllerName())) {
            case WALKING: {
                this.executorService.execute(() -> this.reaStateRequestPublisher.publish((Object)this.clearAndResumeRequestMessage));
                break;
            }
            default: {
                this.executorService.execute(() -> this.reaStateRequestPublisher.publish((Object)this.pauseRequestMessage));
            }
        }
    }

    private void handleWalkingStatusMessage(Subscriber<WalkingStatusMessage> subscriber) {
        if (this.executorService.isShutdown()) {
            return;
        }
        WalkingStatusMessage newMessage = (WalkingStatusMessage)subscriber.takeNextData();
        switch (WalkingStatus.fromByte((byte)newMessage.getWalkingStatus())) {
            case STARTED: 
            case RESUMED: {
                this.executorService.execute(() -> this.reaStateRequestPublisher.publish((Object)this.pauseRequestMessage));
                break;
            }
            case COMPLETED: 
            case PAUSED: {
                this.executorService.execute(() -> this.reaStateRequestPublisher.publish((Object)this.resumeRequestMessage));
                break;
            }
        }
    }

    private void shutdown() {
        this.executorService.shutdownNow();
        this.ros2Node.destroy();
    }

    public void closeAndDispose() {
        this.shutdown();
    }
}

