/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.avatar.networkProcessor.objectDetectorToolBox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import perception_msgs.msg.dds.DetectedFiducialPacket;
import perception_msgs.msg.dds.DoorLocationPacket;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.modules.ToolboxController;
import us.ihmc.avatar.networkProcessor.modules.ToolboxModule;
import us.ihmc.avatar.networkProcessor.objectDetectorToolBox.ObjectDetectorToolboxController;
import us.ihmc.communication.PerceptionAPI;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2Topic;

public class ObjectDetectorToolboxModule
extends ToolboxModule {
    private final ObjectDetectorToolboxController controller;

    public ObjectDetectorToolboxModule(String robotName, FullHumanoidRobotModel desiredFullRobotModel, LogModelProvider modelProvider) {
        super(robotName, desiredFullRobotModel, modelProvider, false, 250);
        this.controller = new ObjectDetectorToolboxController(this.fullRobotModel, this.statusOutputManager, this.registry);
        this.setTimeWithoutInputsBeforeGoingToSleep(1200000.0);
    }

    @Override
    public ToolboxController getToolboxController() {
        return this.controller;
    }

    @Override
    public void registerExtraPuSubs(ROS2Node ros2Node) {
        ros2Node.createSubscription(FiducialDetectorToolboxModule.getOutputTopic(this.robotName).withTypeName(DetectedFiducialPacket.class), s -> {
            if (this.controller != null) {
                this.controller.receivedPacket((DetectedFiducialPacket)s.takeNextData());
                this.receivedInput.set(true);
            }
        });
    }

    @Override
    public List<Class<? extends Command<?, ?>>> createListOfSupportedCommands() {
        ArrayList commands = new ArrayList();
        return commands;
    }

    @Override
    public List<Class<? extends Settable<?>>> createListOfSupportedStatus() {
        return Collections.singletonList(DoorLocationPacket.class);
    }

    @Override
    public ROS2Topic<?> getOutputTopic() {
        return ObjectDetectorToolboxModule.getOutputTopic(this.robotName);
    }

    public static ROS2Topic<?> getOutputTopic(String robotName) {
        return PerceptionAPI.OBJECT_DETECTOR_TOOLBOX_OUTPUT.withRobot(robotName);
    }

    @Override
    public ROS2Topic<?> getInputTopic() {
        return ObjectDetectorToolboxModule.getInputTopic(this.robotName);
    }

    public static ROS2Topic<?> getInputTopic(String robotName) {
        return PerceptionAPI.OBJECT_DETECTOR_TOOLBOX_INPUT.withRobot(robotName);
    }
}

